/*
    Text maid for Windows
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "jump.h"
#include <commctrl.h>
#include "dialog.h"
#include "edit.h"
#include "general.h"
#include "resource.h"


/******************************************************************************
*                                                                             *
* Wv֐Q                                                              *
*                                                                             *
******************************************************************************/
/*  ja:wsֈړ
     hWnd,EChE
    nLine,Vs(1...)
      RET,TRUE:I,FALSE:G[                                        */
BOOL
JumpOperation(HWND      hWnd,
              const int nLine)
{
  int sx, sy;
  POINT ptCursor, ptTop;
  LPTEXTWND ptw;

  ptw = (LPTEXTWND)GetWindowLong (hWnd, 0);
  ptCursor = ptw->ptCursor;
  ptTop = ptw->ptTop;
  sx = max (ptw->siWnd.cx / ptw->nFontSize, 1);
  sy = max (ptw->siWnd.cy / (ptw->nFontSize * 2), 1);
  ptw->ptCursor.y = nLine < 0 ? ptw->nMax + nLine : nLine - 1;
  if (ptw->ptCursor.x < ptw->ptTop.x)
    ptw->ptTop.x = ptw->ptCursor.x;
  else if (ptw->ptCursor.x - sx + 1 > ptw->ptTop.x)
    ptw->ptTop.x = ptw->ptCursor.x - sx + 1;
  if (ptw->ptCursor.y < ptw->ptTop.y)
    ptw->ptTop.y = ptw->ptCursor.y;
  else if (ptw->ptCursor.y - sy + 1 > ptw->ptTop.y)
    ptw->ptTop.y = ptw->ptCursor.y - sy + 1;
  HideCaret (hWnd);
  if (ptw->ptSelect.x >= 0)
    {
      if (ptw->ptSelect.y == ptw->ptCursor.y
                            && ptw->ptSelect.x == GetAlignPos (&ptw->lpStart,
                                &ptw->nOff, ptw->ptCursor.x, ptw->ptCursor.y,
                                                            ptw->nTab, FALSE))
        {
          if (!ClearSel (hWnd, &ptw->ptSelect, &ptCursor))
            return FALSE;
          ptw->ptSelect.x = -1;
          if (!SetMenuBar (ptw))
            return FALSE;
        }
      else if (!ClearSel (hWnd, &ptw->ptCursor, &ptCursor))
        {
          return FALSE;
        }
    }
  if (!DrawCaret (hWnd) || !MoveTextWindow (hWnd, &ptTop))
    return FALSE;
  ShowCaret (hWnd);
  return TRUE;
}


/******************************************************************************
*                                                                             *
* ja:Wv_CAO֐Q                                                  *
*                                                                             *
******************************************************************************/
BOOL CALLBACK
JumpDlgProc (HWND   hDlg,
             UINT   uMsg,
             WPARAM wParam,
             LPARAM lParam)
{
  static LPJMPDLG jmp = NULL;

  switch (uMsg)
    {
      case WM_INITDIALOG:
        jmp = (LPJMPDLG)lParam;
        /* ja:GfBgRg[̐ݒ */
        SendDlgItemMessage (hDlg, IDC_EDIT71, EM_LIMITTEXT, 12, 0);
        if (!SetDlgItemInt (hDlg, IDC_EDIT71, jmp->nCursor, TRUE))
          {
            MessageBox (hDlg, _T("SetDlgItemInt"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
            EndDialog (hDlg, IDCANCEL);
            return TRUE;
          }
        /* ja:Abv_ERg[̐ݒ */
        SendDlgItemMessage (hDlg, IDC_UPDOWN71,
                                UDM_SETRANGE, 0, MAKELPARAM (jmp->nMax, 1));
        /* ja:Rg[̕\ */
        if (!EnableDlgItem (hDlg, IDOK, FALSE))
          {
            MessageBox (hDlg, _T("EnableDlgItem"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
            EndDialog (hDlg, IDCANCEL);
          }
        return TRUE;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDOK:
              jmp->nCursor = GetDlgItemInt (hDlg, IDC_EDIT71, NULL, TRUE);
            case IDCANCEL:
              if (!EndDialog (hDlg, LOWORD (wParam)))
                MessageBox (hDlg, _T("EndDialog"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              jmp = NULL;
              return TRUE;
            case IDC_EDIT71:
              {
                int nValue;

                if (HIWORD (wParam) != EN_CHANGE)
                  return TRUE;
                nValue = GetDlgItemInt (hDlg, IDC_EDIT71, NULL, TRUE);
                /* ja:Rg[̕\ */
                if (jmp && !EnableDlgItem (hDlg, IDOK,
                                        1 <= nValue && nValue <= jmp->nMax))
                  {
                    MessageBox (hDlg, _T("EnableDlgItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                  }
              }
          }
        return TRUE;
    }
  return FALSE;
}
