/*
    Text maid for Windows
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "replace.h"
#include "dialog.h"
#include "find.h"
#include "resource.h"


int nReplace = 0;               /* ja:o^Ău */
BOOL bReplaceArrow = TRUE;      /* ja:TRUE:֌ */
BOOL bReplaceCase = FALSE;      /* ja:TRUE:啶ʂ */
BOOL bReplaceWidth = FALSE;     /* ja:TRUE:Sppʂ */
LPTSTR lpszReplace[32];         /* ja:u镶 */


/******************************************************************************
*                                                                             *
* ja:u_CAOQ                                                          *
*                                                                             *
******************************************************************************/
BOOL CALLBACK
ReplaceDlgProc (HWND   hDlg,
                UINT   uMsg,
                WPARAM wParam,
                LPARAM lParam)
{
  static LPREPLACE lprp;

  switch (uMsg)
    {
      case WM_INITDIALOG:
        {
          int i;

          lprp = (LPREPLACE)lParam;
          /* ja:`FbN{bNX̐ݒ */
          if (!CheckDlgButton (hDlg, IDC_CHECKBOX91,
                                lprp->bCase ? BST_CHECKED : BST_UNCHECKED)
                    || !CheckDlgButton (hDlg, IDC_CHECKBOX92,
                                lprp->bWidth ? BST_CHECKED : BST_UNCHECKED))
            {
              MessageBox (hDlg, _T("CheckDlgButton"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          /* ja:R{{bNX̐ݒ */
          for (i = 0; i < 2; i++)
            SendDlgItemMessage (hDlg, IDC_COMBOBOX91 + i, CB_LIMITTEXT,
                                                            MAXFIND - 1, 0);
          for (i = 0; i < nFind; i++)
            SendDlgItemMessage (hDlg, IDC_COMBOBOX91, CB_ADDSTRING,
                                                    0, (LPARAM)lpszFind[i]);
          if (nFind > 0)
            {
              SendDlgItemMessage (hDlg, IDC_COMBOBOX91, CB_SETCURSEL, 0, 0);
              /* ja:Rg[̕\ */
              if (!EnableDlgItem (hDlg, IDC_PUSHBUTTON91, TRUE)
                                        || !EnableDlgItem (hDlg, IDOK, TRUE))
                {
                  MessageBox (hDlg, _T("EnableDlgItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  EndDialog (hDlg, IDCANCEL);
                  return TRUE;
                }
            }
          for (i = 0; i < nReplace; i++)
            SendDlgItemMessage (hDlg, IDC_COMBOBOX92, CB_ADDSTRING,
                                                    0, (LPARAM)lpszReplace[i]);
          if (nReplace > 0)
            SendDlgItemMessage (hDlg, IDC_COMBOBOX92, CB_SETCURSEL, 0, 0);
          if (!CheckRadioButton (hDlg, IDC_RADIOBUTTON91, IDC_RADIOBUTTON92,
                        lprp->bArrow ? IDC_RADIOBUTTON92 : IDC_RADIOBUTTON91))
            {
              MessageBox (hDlg, _T("CheckRadioButton"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
            }
        }
        return TRUE;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDOK:
            case IDC_PUSHBUTTON91:
              lprp->bCase = IsDlgButtonChecked (hDlg, IDC_CHECKBOX91)
                                                                == BST_CHECKED;
              lprp->bWidth = IsDlgButtonChecked (hDlg, IDC_CHECKBOX92)
                                                                == BST_CHECKED;
              lprp->bArrow = IsDlgButtonChecked (hDlg, IDC_RADIOBUTTON92)
                                                                == BST_CHECKED;
              GetDlgItemText (hDlg, IDC_COMBOBOX91, lprp->szSrc, MAXFIND);
              GetDlgItemText (hDlg, IDC_COMBOBOX92, lprp->szDst, MAXFIND);
            case IDCANCEL:
              if (!EndDialog (hDlg, LOWORD (wParam)))
                MessageBox (hDlg, _T("EndDialog"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              return TRUE;
            case IDC_COMBOBOX91:
              {
                int nLength;

                switch (HIWORD (wParam))
                  {
                    case CBN_EDITCHANGE:
                      nLength = GetWindowTextLength ((HWND)lParam);
                      break;
                    case CBN_SELCHANGE:
                      nLength = 1;
                      break;
                    default:return TRUE;
                  }
                /* ja:Rg[̕\ */
                if (!EnableDlgItem (hDlg, IDC_PUSHBUTTON91, nLength > 0)
                                || !EnableDlgItem (hDlg, IDOK, nLength > 0))
                  {
                    MessageBox (hDlg, _T("EnableDlgItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                  }
              }
          }
        return TRUE;
    }
  return FALSE;
}
