/*
    fndir
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include <tchar.h>
#include "fndir.h"
#include "memapi.h"


/******************************************************************************
*                                                                             *
* ja:t@C͊֐                                                       *
*                                                                             *
******************************************************************************/
/*  ja:t@Č
    lpszFIle,ꂽt@C
         pfd,t@C̊evf
         RET,TRUE:I,FALSE:G[                                     */
BOOL WINAPI
MergeFileName (LPTSTR  lpszFile,
               LPFNDIR pfd)
{
  int i, s;
  int nBuffer[MAXDIR]; /* ja:0:1oCg,1:1oCg,2oCg */

  lstrcpy (lpszFile, pfd->szDrive);
  switch (lstrlen (lpszFile))
    {
      case 2:
        if (lpszFile[1] != ':')
          {
            lpszFile[0] = '\0';
            return FALSE;
          }
      case 1:
        if (!IsCharAlpha (lpszFile[0]))
          {
            lpszFile[0] = '\0';
            return FALSE;
          }
        lpszFile[1] = ':';
        lpszFile[2] = '\0';
      case 0:
        break;
      default:
        lpszFile[0] = '\0';
        return FALSE;
    }
  s = lstrlen (pfd->szDir);
  if (s > 0)
    {
      lstrcat (lpszFile, pfd->szDir);
      i = 0;
#ifdef UNICODE
      MemorySet (nBuffer, 0, MAXDIR * sizeof (int));
#else /* not UNICODE */
      while (i < s)
        if (IsDBCSLeadByteEx (CP_ACP, pfd->szDir[i]))
          {
            nBuffer[i++] = 1;
            nBuffer[i++] = 2;
          }
        else
          {
            nBuffer[i++] = 0;
          }
      if (i != s)
        {
          lpszFile[0] = '\0';
          return FALSE;
        }
#endif /* not UNICODE */
      if (nBuffer[s - 1] == 2
                        || nBuffer[s - 1] == 0 && pfd->szDir[s - 1] != '\\')
        {
          s = lstrlen (lpszFile);
          lpszFile[s] = '\\';
          lpszFile[s + 1] = '\0';
        }
    }
  s = lstrlen (pfd->szName);
  if (s > 0)
    {
#ifndef UNICODE
      for (i = 0; i < s;
                    i += IsDBCSLeadByteEx (CP_ACP, pfd->szName[i]) ? 2 : 1);
      if (i != s)
        {
          lpszFile[0] = '\0';
          return FALSE;
        }
#endif /* not UNICODE */
      lstrcat (lpszFile, pfd->szName);
    }
  s = lstrlen (pfd->szExt);
  if (s > 0)
    {
#ifndef UNICODE
      for (i = 0; i < s;
                        i += IsDBCSLeadByteEx (CP_ACP, pfd->szExt[i]) ? 2 : 1);
      if (i != s)
        {
          lpszFile[0] = '\0';
          return FALSE;
        }
#endif /* not UNICODE */
      if (pfd->szExt[0] != '.')
        lstrcat (lpszFile, _T("."));
      lstrcat (lpszFile, pfd->szExt);
    }
  return TRUE;
}


/*  ja:t@C̕
    lpszFile,t@C
         pfd,t@C̊evf
         RET,TRUE:I,FALSE:G[                                     */
BOOL WINAPI
SplitFileName (LPCTSTR lpszFile,
               LPFNDIR pfd)
{
  int i, s;
  int nDir;            /* ja:pX */
  int nName;           /* ja:t@C */
  int nExt;            /* ja:gq */
  int nBuffer[MAXDIR]; /* ja:0:1oCg,1:1oCg,2oCg */

  pfd->szDrive[0] = pfd->szDir[0] = pfd->szName[0] = pfd->szExt[0] = '\0';
  s = lstrlen (lpszFile);
  if (s >= MAXPATH)
    return FALSE;
#ifdef UNICODE
  for (i = 0; i < s; i++)
    {
      switch (lpszFile[i])
        {
          case '/': case ',': case ';': case '\"':
          case '<': case '>': case '|': return -1;
        }
      nBuffer[i] = 0;
    }
#else /* not UNICODE */
  i = 0;
  while (i < s)
    if (IsDBCSLeadByteEx (CP_ACP, lpszFile[i]))
      {
        nBuffer[i++] = 1;
        nBuffer[i++] = 2;
      }
    else
      {
        switch (lpszFile[i])
          {
            case '/': case ',': case ';': case '\"':
            case '<': case '>': case '|': return -1;
          }
        nBuffer[i++] = 0;
      }
  if (i != s)
    return -1;
#endif /* not UNICODE */

  for (nExt = s - 1; nExt >= 0; nExt--)
    if (lpszFile[nExt] == '\\' && nBuffer[nExt] == 0)
      nExt = 0;
    else if (lpszFile[nExt] == '.' && nBuffer[nExt] == 0)
      break;
  if (nExt >= 0)
    {
      if (lstrlen (lpszFile + nExt) >= MAXEXT)
        return FALSE;
      lstrcpy (pfd->szExt, lpszFile + nExt);
    }
  else
    {
      nExt = s;
    }

  for (nName = nExt - 1; nName >= 0; nName--)
    if ((lpszFile[nName] == ':' || lpszFile[nName] == '\\')
                                                        && nBuffer[nName] == 0)
      {
        nName++;
        break;
      }
  if (nName <= 0)
    nName = 0;
  if (nExt - nName > MAXFILE)
    {
      pfd->szExt[0] = '\0';
      return FALSE;
    }
  MemoryCopy (pfd->szName, lpszFile + nName, (nExt - nName) * sizeof (TCHAR));
  pfd->szName[nExt - nName] = '\0';

  for (nDir = nName - 1; nDir >= 0; nDir--)
    if (lpszFile[nDir] == ':' && nBuffer[nDir] == 0)
      {
        nDir++;
        break;
      }
  if (nDir <= 0)
    nDir = 0;
  if (nName - nDir > MAXDIR)
    {
      pfd->szName[0] = pfd->szExt[0] = '\0';
      return FALSE;
    }
  MemoryCopy (pfd->szDir, lpszFile + nDir, (nName - nDir) * sizeof (TCHAR));
  pfd->szDir[nName - nDir] = '\0';

  switch (nDir)
    {
      case 2:
        if (!IsCharAlpha (lpszFile[0]))
          {
            pfd->szDir[0] = pfd->szName[0] = pfd->szExt[0] = '\0';
            return FALSE;
          }
        pfd->szDrive[0] = lpszFile[0];
        pfd->szDrive[1] = ':';
        pfd->szDrive[2] = '\0';
      case 0:
        return TRUE;
    }
  pfd->szDir[0] = pfd->szName[0] = pfd->szExt[0] = '\0';
  return FALSE;
}


/*  ja:Ot@C擾
     lpszLongName,Ot@C
    lpszShortName,t@C                                                */
VOID WINAPI
GetLongFile (LPTSTR  lpszLongName,
             LPCTSTR lpszShortName)
{
  int i = 0, j;
  DWORD dwSize;             /* ja:tpX̒ */
  LPTSTR p;
  TCHAR szFile[MAXPATH];    /* ja:tpX */

  dwSize = GetFullPathName (lpszShortName, MAXPATH, szFile, &p);
  if (dwSize == 0 || dwSize >= MAXPATH)
    {
      lstrcpy (lpszLongName, lpszShortName);
      return;
    }
  if (dwSize >= 2)
    {
      if (szFile[1] == ':')
        {
          lpszLongName[0] = (TCHAR)CharUpper ((LPTSTR)szFile[0]);
          lpszLongName[1] = ':';
          if (szFile[2] == '\\')
            {
              lpszLongName[2] = '\\';
              i = 3;
            }
          else
            {
              i = 2;
            }
        }
      else if (szFile[0] == '\\' && szFile[1] == '\\')
        {
          i = 2;
          while (i < dwSize)
            {
              if (szFile[i] == '\\')
                break;
#ifdef UNICODE
              i++;
#else /* not UNICODE */
              i += IsDBCSLeadByteEx (CP_ACP, szFile[i]) ? 2 : 1;
#endif /* not UNICODE */
            }
          i++;
          MemoryCopy (lpszLongName, szFile, i * sizeof (TCHAR));
        }
    }
  lpszLongName[i] = '\0';
  j = i;
  while (i <= dwSize)
    {
      if (szFile[i] == '\0' || szFile[i] == '\\')
        {
          int s;
          HANDLE hFind;             /* ja:nh */
          WIN32_FIND_DATA rcf;

          s = lstrlen (lpszLongName);
          MemoryCopy (lpszLongName + s, szFile + j, (i - j) * sizeof (TCHAR));
          lpszLongName[s + i - j] = '\0';
          hFind = FindFirstFile (lpszLongName, &rcf);
          if (hFind != INVALID_HANDLE_VALUE)
            FindClose (hFind);
          else
            lstrcpy (rcf.cFileName, _T("."));
          if (lstrcmp (rcf.cFileName, _T(".")) != 0)
            {
              MemoryCopy (lpszLongName + s, rcf.cFileName,
                                    lstrlen (rcf.cFileName) * sizeof (TCHAR));
              s += lstrlen (rcf.cFileName);
            }
          else
            {
              s += i - j;
            }
          if (szFile[i] == '\\')
            lpszLongName[s++] = '\\';
          lpszLongName[s] = '\0';
          j = i + 1;
        }
#ifdef UNICODE
      i++;
#else /* not UNICODE */
      i += IsDBCSLeadByteEx (CP_ACP, szFile[i]) ? 2 : 1;
#endif /* not UNICODE */
    }
}


/*  ja:t@C̑݊mF
    lpszFile,t@C
         RET,TRUE:݂,FALSE:݂Ȃ                                 */
BOOL WINAPI
IsFile (LPCTSTR lpszFile)
{
  HANDLE hFind; /* nh */
  WIN32_FIND_DATA rcf;

  hFind = FindFirstFile (lpszFile, &rcf);
  if (hFind != INVALID_HANDLE_VALUE)
    {
      FindClose (hFind);
      return TRUE;
    }
  return FALSE;
}
