/*
    Text maid for Windows
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "wndmain.h"
#include <commctrl.h>
#include <htmlhelp.h>
#include <shlobj.h>
#include "dialog.h"
#include "file.h"
#include "find.h"
#include "format.h"
#include "general.h"
#include "history.h"
#include "imectrl.h"
#include "jump.h"
#include "memapi.h"
#include "other.h"
#include "replace.h"
#include "resource.h"
#include "valchr.h"
#include "valstr.h"
#include "version.h"


/******************************************************************************
*                                                                             *
* ja:EChE֐Q                                                         *
*                                                                             *
******************************************************************************/
static BOOL CALLBACK
CloseEnumProc (HWND   hWnd,
               LPARAM lParam)
{
  TCHAR szText[MAXPATH];

  GetClassName (hWnd, szText, MAXPATH - 1);
  if (lstrcmp (szText, TEXTCLASS) == 0)
    {
      if (IsIconic (hWnd))
        SendMessage (hWndClient, WM_MDIRESTORE, (WPARAM)hWnd, 0);
      if (!SendMessage (hWnd, WM_QUERYENDSESSION, 0, 0))
        return FALSE;
      SendMessage (hWndClient, WM_MDIDESTROY, (WPARAM)hWnd, 0);
    }
  return TRUE;
}


LRESULT CALLBACK
WndProc (HWND   hWnd,
         UINT   uMsg,
         WPARAM wParam,
         LPARAM lParam)
{
  static HWND hWndClip;     /* ja:̃Nbv{[hI[i[ */

  switch (uMsg)
    {
      case WM_CREATE:/* ja:EChEꂽ */
        {
          int i, j;
          CLIENTCREATESTRUCT ccs;
          HMENU hMenu;
          TCHAR szText[MAXPATH];
          TBBUTTON tbbutton[18] = {
{STD_FILENEW,    CM_NEW,      TBSTATE_ENABLED, TBSTYLE_BUTTON, {0, 0}, 0, 0},
{STD_FILEOPEN,   CM_OPEN,     TBSTATE_ENABLED, TBSTYLE_BUTTON, {0, 0}, 0, 0},
{STD_FILESAVE,   CM_SAVE,     0,               TBSTYLE_BUTTON, {0, 0}, 0, 0},
{0,              0,           TBSTATE_ENABLED, TBSTYLE_SEP,    {0, 0}, 0, 0},
{STD_PROPERTIES, CM_PROPERTY, 0,               TBSTYLE_BUTTON, {0, 0}, 0, 0},
{0,              0,           TBSTATE_ENABLED, TBSTYLE_SEP,    {0, 0}, 0, 0},
{STD_PRINT,      CM_PRINT,    0,               TBSTYLE_BUTTON, {0, 0}, 0, 0},
{0,              0,           TBSTATE_ENABLED, TBSTYLE_SEP,    {0, 0}, 0, 0},
{STD_CUT,        CM_CUT,      0,               TBSTYLE_BUTTON, {0, 0}, 0, 0},
{STD_COPY,       CM_COPY,     0,               TBSTYLE_BUTTON, {0, 0}, 0, 0},
{STD_PASTE,      CM_PASTE,    0,               TBSTYLE_BUTTON, {0, 0}, 0, 0},
{STD_DELETE,     CM_DELETE,   0,               TBSTYLE_BUTTON, {0, 0}, 0, 0},
{0,              0,           TBSTATE_ENABLED, TBSTYLE_SEP,    {0, 0}, 0, 0},
{STD_UNDO,       CM_UNDO,     0,               TBSTYLE_BUTTON, {0, 0}, 0, 0},
{STD_REDOW,      CM_REDO,     0,               TBSTYLE_BUTTON, {0, 0}, 0, 0},
{0,              0,           TBSTATE_ENABLED, TBSTYLE_SEP,    {0, 0}, 0, 0},
{STD_FIND,       CM_FIND,     0,               TBSTYLE_BUTTON, {0, 0}, 0, 0},
{STD_REPLACE,    CM_REPLACE,  0,               TBSTYLE_BUTTON, {0, 0}, 0, 0}};
          UINT uID[8] = {CM_UNDO, 0, CM_CUT, CM_COPY,
                                            CM_PASTE, CM_DELETE, 0, CM_ALL};

          InitIme ();
          hWndClip = SetClipboardViewer (hWnd);
          hWndTool = CreateToolbarEx (hWnd, WS_CHILD | WS_VISIBLE
                                | CCS_NODIVIDER | TBSTYLE_TOOLTIPS,
                                1, 0, HINST_COMMCTRL, IDB_STD_SMALL_COLOR,
                                tbbutton, 18, 0, 0, 0, 0, sizeof (TBBUTTON));
          if (!hWndTool)
            {
              MessageBox (hWnd, _T("CreateToolbarEx"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWnd);
              return 0;
            }
          hWndStat = CreateStatusWindow (WS_CHILD | WS_VISIBLE
                                            | SBARS_SIZEGRIP, _T(""), hWnd, 2);
          if (!hWndStat)
            {
              MessageBox (hWnd, _T("CreateStatusWindow"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWnd);
              return 0;
            }
          ccs.hWindowMenu = GetSubMenu (GetMenu (hWnd), MENUTOP - 2);
          ccs.idFirstChild = 300;
          hWndClient = CreateWindowEx (0, _T("MDICLIENT"), NULL,
                            WS_HSCROLL | WS_VSCROLL
                                    | WS_CHILD | WS_CLIPCHILDREN | WS_VISIBLE,
                            0, 0, 0, 0, hWnd, (HMENU)3, hInst, (LPVOID)&ccs);
          if (!hWndClient)
            {
              MessageBox (hWnd, _T("CreateWindowEx"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWnd);
              return 0;
            }
          uDlMsg = RegisterWindowMessage (DRAGLISTMSGSTRING);
          if (uDlMsg == 0)
            {
              MessageBox (hWnd, _T("RegisterWindowMessage"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWnd);
              return 0;
            }
          /* ja:̃y */
          hPenNull = GetStockObject (NULL_PEN);
          if (!hPenNull)
            {
              MessageBox (hWnd, _T("GetStockObject"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWnd);
              return 0;
            }
          /* ja:|bvAbvj[ */
          hMenu = GetMenu (hWnd);
          if (!hMenu)
            {
              MessageBox (hWnd, _T("GetMenu"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWnd);
              return FALSE;
            }
          hMenuPopup = CreatePopupMenu ();
          if (!hMenuPopup)
            {
              MessageBox (hWnd, _T("CreatePopupMenu"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWnd);
              return 0;
            }
          for (i = 0; i < 8; i++)
            if (uID[i] > 0)
              {
                if (GetMenuString (hMenu,uID[i], szText, MAXPATH,
                                                            MF_BYCOMMAND) == 0)
                  {
                    MessageBox (hWnd, _T("GetMenuString"),
                                        APPLICATION, MB_OK | MB_ICONSTOP);
                    DestroyWindow (hWnd);
                    return 0;
                  }
                for (j = 0; szText[j] != '\0';
#ifdef UNICODE
                            j++)
#else /* not UNICODE */
                            j += IsDBCSLeadByteEx (CP_SJIS, szText[j]) ? 2 : 1)
#endif /* not UNICODE */
                  if (szText[j] == '\t')
                    {
                      szText[j]='\0';
                      break;
                    }
                if (!AppendMenu (hMenuPopup, 0, uID[i], szText))
                  {
                    MessageBox (hWnd, _T("AppendMenu"),
                                        APPLICATION, MB_OK | MB_ICONSTOP);
                    DestroyWindow (hWnd);
                    return 0;
                  }
              }
            else if (!AppendMenu (hMenuPopup, MF_SEPARATOR, 0, NULL))
              {
                MessageBox (hWnd, _T("AppendMenu"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                DestroyWindow (hWnd);
                return 0;
              }
        }
      case WM_SYSCOLORCHANGE:
        if ((hBrushWindow && !DeleteObject (hBrushWindow))
                        | (hBrushGray && !DeleteObject (hBrushGray))
                        | (hBrushHighLight && !DeleteObject (hBrushHighLight))
                        | (hPenGray && !DeleteObject (hPenGray))
                        | (hPenGrid && !DeleteObject (hPenGrid)))
          {
            MessageBox (hWnd, _T("DeleteObject"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
            hBrushWindow = hBrushHighLight = NULL;
            hPenGray = hPenGrid = NULL;
            DestroyWindow (hWnd);
            return 0;
          }
        hBrushWindow = hBrushGray = hBrushHighLight = NULL;
        hPenGray = hPenGrid = NULL;
        crWindowText = GetSysColor (COLOR_WINDOWTEXT);
        crGrayText = GetSysColor (COLOR_GRAYTEXT);
        crHighLightText = GetSysColor (COLOR_HIGHLIGHTTEXT);
        if (!(hBrushWindow = CreateSolidBrush (GetSysColor (COLOR_WINDOW)))
                || !(hBrushGray = CreateSolidBrush (crGrayText))
                || !(hBrushHighLight
                        = CreateSolidBrush (GetSysColor (COLOR_HIGHLIGHT))))
          {
            MessageBox (hWnd, _T("CreateSolidBrush"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
            DestroyWindow (hWnd);
            return 0;
          }
        if (!(hPenGray = CreatePen (PS_SOLID, 0, crGrayText))
                || !(hPenGrid = CreatePen (PS_SOLID, 0,
                                                GetSysColor (COLOR_BTNFACE))))
          {
            MessageBox (hWnd, _T("CreatePen"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
            DestroyWindow (hWnd);
            return 0;
          }
        break;
      case WM_SIZE:
        {
          int y;
          RECT rc;

          SendMessage (hWndTool, TB_AUTOSIZE, 0, 0);
          if (!GetWindowRect (hWndTool, &rc))
            {
              MessageBox (hWnd, _T("GetWindowRect"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWnd);
              return 0;
            }
          y = rc.bottom - rc.top;
          if (!GetWindowRect (hWndStat, &rc))
            {
              MessageBox (hWnd, _T("GetWindowRect"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWnd);
              return 0;
            }
          if (!MoveWindow (hWndStat, 0, HIWORD (lParam) - rc.bottom + rc.top,
                                    LOWORD(lParam), rc.bottom - rc.top, TRUE)
                    || !MoveWindow (hWndClient, 0, y, LOWORD (lParam),
                            HIWORD (lParam) - y - rc.bottom + rc.top, TRUE))
            {
              MessageBox (hWnd, _T("MoveWindow"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWnd);
            }
        }
        return 0;
      case WM_NOTIFY:
        switch (((LPNMHDR)lParam)->code)
          {
            case TTN_NEEDTEXT:
              ((LPTOOLTIPTEXT)lParam)->lpszText
                            = (LPTSTR)(((LPNMHDR)lParam)->idFrom + TIPBASE);
              ((LPTOOLTIPTEXT)lParam)->hinst = hInst;
              break;
            case TTN_SHOW:
              {
                TCHAR szText[MAXPATH];

                if (LoadString (hInst, ((LPNMHDR)lParam)->idFrom,
                                                    szText, MAXPATH - 1) != 0)
                  {
                    SendMessage (hWndStat, SB_SIMPLE, TRUE, 0);
                    if (!SendMessage (hWndStat, SB_SETTEXT,
                                        SBT_NOBORDERS | 255, (LPARAM)szText))
                      {
                        MessageBox (hWnd, _T("SB_SETTEXT"),
                                            APPLICATION, MB_OK | MB_ICONSTOP);
                        DestroyWindow (hWnd);
                      }
                  }
              }
              break;
            case TTN_POP:
              if (!SendMessage (hWndStat, SB_SETTEXT, 255, (LPARAM) _T("")))
                {
                  MessageBox (hWnd, _T("SB_SETTEXT"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                  DestroyWindow (hWnd);
                }
              SendMessage (hWndStat, SB_SIMPLE, FALSE, 0);
          }
        break;
      case WM_MENUSELECT:
        {
          int nMenu;
          HMENU hMenu;
          UINT ids[2] = {0, 0};

          hMenu = GetMenu (hWnd);
          if (!hMenu)
            {
              MessageBox (hWnd, _T("GetMenu"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWnd);
              return 0;
            }
          nMenu = (GetMenuItemCount (hMenu) != MENUTOP);
          if (300 <= LOWORD (wParam) && LOWORD (wParam) < 400)
            MenuHelp (uMsg, MAKEWPARAM (IDS_WND, HIWORD (wParam)), lParam,
                                                hMenu, hInst, hWndStat, ids);
          else if (200 <= LOWORD (wParam) && LOWORD (wParam) < 300)
            MenuHelp (uMsg, MAKEWPARAM (IDS_THIS, HIWORD (wParam)), lParam,
                                                hMenu, hInst, hWndStat, ids);
          else if (HIWORD (wParam) & MF_SYSMENU
                                || LOWORD (wParam) >= 100
                                || nMenu != 0 && LOWORD (wParam) == 0
                                || HIWORD (wParam) == 0xffff && !(HMENU)lParam)
            MenuHelp (uMsg, wParam, lParam, hMenu, hInst, hWndStat, ids);
          else
            MenuHelp (uMsg, MAKEWPARAM (IDS_FILE + LOWORD (wParam) - nMenu,
                        HIWORD (wParam)), lParam, hMenu, hInst, hWndStat, ids);
        }
        return 0;
      case WM_CHANGECBCHAIN:
        if (hWndClip == (HWND)wParam)
            hWndClip = (HWND)lParam;
        else if (hWndClip)
          SendMessage (hWndClip, uMsg, wParam, lParam);
        return 0;
      case WM_DRAWCLIPBOARD:
        {
          int nResult;
          BOOL f;
          HMENU hMenu;
          UINT uPriority[2] = {CF_TEXT, CF_UNICODETEXT};

          nResult = GetPriorityClipboardFormat (uPriority, 2);
          f = nResult && nResult != -1;
          if (fClipBoard != f)
            {
              fClipBoard = f;
              hMenu = GetMenu (hWnd);
              if (!hMenu)
                {
                  MessageBox (hWnd, _T("GetMenu"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                  DestroyWindow (hWnd);
                  return 0;
                }
              if (EnableMenuItem (hMenu, CM_PASTE, fClipBoard
                                        ? MF_ENABLED : MF_GRAYED) == (BOOL)-1)
                {
                  MessageBox (hWnd, _T("EnableMenuItem"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                  DestroyWindow (hWnd);
                  return 0;
                }
              if (!DrawMenuBar (hWnd))
                {
                  MessageBox (hWnd, _T("DrawMenuBar"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                  DestroyWindow (hWnd);
                  return 0;
                }
              if (IsWindow (hWndTool) && !SendMessage (hWndTool,
                                        TB_ENABLEBUTTON, CM_PASTE, fClipBoard
                                    && IsWindow ((HWND)SendMessage (hWndClient,
                                                    WM_MDIGETACTIVE, 0, 0))))
                {
                  MessageBox (hWnd, _T("TB_ENABLEBUTTON"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                  DestroyWindow (hWnd);
                  return 0;
                }
            }
          if (hWndClip)
            SendMessage (hWndClip, uMsg, wParam, lParam);
        }
        return 0;
      case WM_DROPFILES:
        {
          int i, nFile;

          SetForegroundWindow (hWnd);
          nFile = DragQueryFile ((HDROP)wParam, 0xffffffff, NULL, 0);
          for (i = 0; i < nFile; i++)
            {
              TCHAR szFile[MAXPATH];

              DragQueryFile ((HDROP)wParam, i, szFile, MAXPATH - 1);
              OpenEditFile (szFile);
            }
          DragFinish ((HDROP)wParam);
        }
        return 0;
      case WM_USER:
        {
          TCHAR szFile[MAXPATH];

          if (GlobalGetAtomName ((ATOM)wParam, szFile, MAXPATH) > 0)
            {
              HWND hWndChild;
              static int nInitLine = 0;

              if (szFile[0] == '-' || szFile[0] == '/')
                switch ((int)CharUpper ((LPTSTR)szFile[1]))
                  {
                    case 'C':
                      if (szFile[2] == '\0')
                        nCodeDef=' ';
                      else
                        nCodeDef = StrVal (&nCodeDef, szFile + 2, 10, TRUE);
                      break;
                    case 'F':
                      if (szFile[2] == '\0')
                        dwFilter = 0;
                      else
                        StrVal (&dwFilter, szFile + 2, 10, TRUE);
                      break;
                    case 'H':
                      nHistory = IsCharNumeric (szFile[2]) && szFile[3] == '\0'
                                                        ? szFile[2] - '0' : 4;
                      if (!ModifyHistory (hWnd, nHistory, MENUTOP, MENUFILE))
                        {
                          MessageBox (hWnd, _T("ModifyHistory"),
                                            APPLICATION, MB_OK | MB_ICONSTOP);
                          DestroyWindow (hWnd);
                          return 0;
                        }
                      break;
                    case 'L':
                      StrVal (&nInitLine, szFile + 2, 10, TRUE);
                      break;
                    case 'S':
                      if (szFile[2] == '\0')
                        {
                          bFindArrow = TRUE;
                          bFindCase = FALSE;
                          bFindWidth = FALSE;
                          bReplaceArrow = TRUE;
                          bReplaceCase = FALSE;
                          bReplaceWidth = FALSE;
                        }
                      else
                        {
                          DWORD dwStat;

                          StrVal (&dwStat, szFile + 2, 10, TRUE);
                          bFindArrow = !(dwStat & 4);
                          bFindCase = dwStat & 1;
                          bFindWidth = dwStat & 2;
                          bReplaceArrow = !(dwStat & 32);
                          bReplaceCase = dwStat & 8;
                          bReplaceWidth = dwStat & 16;
                        }
                      break;
                    case 'Z':
                      fZoomed = szFile[2] - '0';
                  }
              else if ((hWndChild = OpenEditFile (szFile)) && nInitLine != 0)
                JumpOperation (hWndChild, nInitLine);
            }
        }
        return 0;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case CM_NEW:
              OpenEditFile (NULL);
              return 0;
            case CM_OPEN:
              {
                int i,nPos = 0;
                LPTSTR lpszFilter = NULL;
                OPENFILENAME ofn;
                TCHAR szFile[MAXPATH];

                /* ja:tB^̐ݒ */
                for (i = 0; i < nFileType; i++)
                  {
                    int nLength;

                    nLength = lstrlen (lpFileType[i].szText) + 1;
                    lpszFilter = MemoryReAlloc (lpszFilter,
                                        (nPos + nLength + 1) * sizeof (TCHAR));
                    MemoryCopy (lpszFilter + nPos, lpFileType[i].szText,
                                                    nLength * sizeof (TCHAR));
                    nPos += nLength;
                    nLength = lstrlen (lpFileType[i].szExt) + 1;
                    lpszFilter = MemoryReAlloc (lpszFilter,
                                        (nPos + nLength + 1) * sizeof (TCHAR));
                    MemoryCopy (lpszFilter + nPos, lpFileType[i].szExt,
                                                    nLength * sizeof (TCHAR));
                    nPos += nLength;
                  }
                lpszFilter[nPos] = '\0';
                szFile[0] = '\0';
                ofn.lStructSize = sizeof (OPENFILENAME);
                ofn.hwndOwner = hWndClient;
                ofn.lpstrFilter = lpszFilter;
                ofn.nFilterIndex = dwFilter + 1;
                ofn.lpstrCustomFilter = NULL;
                ofn.lpstrFile = szFile;
                ofn.nMaxFile = MAXPATH;
                ofn.lpstrFileTitle = NULL;
                ofn.lpstrInitialDir = szOpenPath;
                ofn.lpstrTitle = NULL;
                ofn.Flags = OFN_HIDEREADONLY | OFN_NOCHANGEDIR;
                ofn.lpstrDefExt = NULL;
                if (GetOpenFileName (&ofn))
                  {
                    dwFilter = ofn.nFilterIndex - 1;
                    MemoryCopy (szOpenPath, szFile, ofn.nFileOffset);
                    szOpenPath[ofn.nFileOffset] = '\0';
                    OpenEditFile (szFile);
                  }
                MemoryFree (lpszFilter);
              }
              return 0;
            case CM_CLOSE:
              {
                HWND hWndChild;

                hWndChild = (HWND)SendMessage (hWndClient, WM_MDIGETACTIVE,
                                                                        0, 0);
                if (SendMessage (hWndChild, WM_QUERYENDSESSION, 0, 0))
                  SendMessage (hWndClient, WM_MDIDESTROY,
                                                        (WPARAM)hWndChild, 0);
              }
              return 0;
            case CM_EXIT:
              SendMessage(hWnd,WM_CLOSE,0,0);
              return 0;
            case CM_HISTORY:
              if (!ModifyHistoryDlg (hInst, MAKEINTRESOURCE (DIALOG_B), hWnd,
                                                &nHistory, MENUTOP, MENUFILE))
                {
                  MessageBox (hWnd, _T("ModifyHistoryDlg"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                  DestroyWindow (hWnd);
                }
              return 0;
            case CM_FORMAT:
              DialogBoxGUI (hInst, MAKEINTRESOURCE (DIALOG_E),
                                                        hWnd, FormatDlgProc);
              return 0;
            case CM_HTILE:
              {
                HWND hWndChild;

                SendMessage (hWndClient, WM_MDITILE, MDITILE_HORIZONTAL, 0);
                hWndChild = (HWND)SendMessage (hWndClient,
                                                        WM_MDIGETACTIVE, 0, 0);
                if (hWndChild)
                  DrawCaret (hWndChild);
              }
              return 0;
            case CM_VTILE:
              {
                HWND hWndChild;

                SendMessage (hWndClient, WM_MDITILE, MDITILE_VERTICAL, 0);
                hWndChild = (HWND)SendMessage (hWndClient,
                                                        WM_MDIGETACTIVE, 0, 0);
                if (hWndChild)
                  DrawCaret (hWndChild);
              }
              return 0;
            case CM_CASCADE:
              {
                HWND hWndChild;

                SendMessage (hWndClient, WM_MDICASCADE, 0, 0);
                hWndChild = (HWND)SendMessage (hWndClient,
                                                        WM_MDIGETACTIVE, 0, 0);
                if (hWndChild)
                  DrawCaret (hWndChild);
              }
              return 0;
            case CM_TOPIC:
              if (!HtmlHelp (hWnd, szHelpFile, HH_DISPLAY_TOPIC, 0))
                MessageBox (hWnd, LoadText (hInst, IDS_OTHER_HELP),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              return 0;
            case CM_VERSION:
              DialogBoxGUI (hInst, MAKEINTRESOURCE (DIALOG_F),
                                                            hWnd, HelpDlgProc);
              return 0;
            case 200: case 201: case 202:
            case 203: case 204: case 205:
            case 206: case 207: case 208:
              {
                TCHAR szFile[MAXPATH];

                if (!GetHistory (szFile, hWnd, LOWORD (wParam)))
                  {
                    MessageBox (hWnd, _T("GetHistory"),
                                        APPLICATION, MB_OK | MB_ICONSTOP);
                    DestroyWindow (hWnd);
                    return 0;
                  }
                OpenEditFile (szFile);
              }
              return 0;
            default:
              {
                HWND hWndChild;

                hWndChild = (HWND)SendMessage (hWndClient, WM_MDIGETACTIVE,
                                                                        0, 0);
                if (IsWindow (hWndChild))
                  SendMessage (hWndChild, WM_COMMAND, wParam, lParam);
              }
          }
        break;
      case WM_QUERYENDSESSION:
      case WM_CLOSE:
        EnumChildWindows (hWndClient, CloseEnumProc, TRUE);
        if (IsWindow ((HWND)SendMessage (hWndClient, WM_MDIGETACTIVE, 0, 0)))
          return 0;
        break;
      case WM_DESTROY:
        RegWrite ();
        if (hWndClip)
          ChangeClipboardChain (hWnd, hWndClip);
        if ((hBrushWindow && !DeleteObject (hBrushWindow))
                        | (hBrushGray && !DeleteObject (hBrushGray))
                        | (hBrushHighLight && !DeleteObject (hBrushHighLight))
                        | (hPenGray && !DeleteObject (hPenGray))
                        | (hPenGrid && !DeleteObject (hPenGrid)))
          MessageBox (hWnd, _T("DeleteObject"),
                            APPLICATION, MB_OK | MB_ICONEXCLAMATION);
        if (hMenuPopup && !DestroyMenu (hMenuPopup))
          MessageBox (hWnd, _T("DestroyMenu"),
                            APPLICATION, MB_OK | MB_ICONEXCLAMATION);
        ExitIme ();
        PostQuitMessage (0);
        return 0;
    }
  return DefFrameProc (hWnd, hWndClient, uMsg, wParam, lParam);
}
