/*
    Text maid for Windows
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "valchr.h"
#include <commctrl.h>
#include "dialog.h"
#include "other.h"
#include "resource.h"
#include "valstr.h"


int nCodeDef = ' ';             /* ja:R[h */


/******************************************************************************
*                                                                             *
* ja:R[h͊֐Q                                                     *
*                                                                             *
******************************************************************************/
BOOL CALLBACK
ValChrDlgProc (HWND   hDlg,
               UINT   uMsg,
               WPARAM wParam,
               LPARAM lParam)
{
  static int nCode, *lpnCode;

  switch (uMsg)
    {
      case WM_INITDIALOG:
        {
          TCHAR szText[13];

          lpnCode = (int *)lParam;
          nCode = *lpnCode;
          /* ja:GfBgRg[̐ݒ */
          SendDlgItemMessage (hDlg, IDC_EDIT61, EM_LIMITTEXT, 12, 0);
          switch (nCode >> 8)
            {
              case  0: ValStr (nCode & 255, szText, 16, -2, FALSE); break;
              case  1: ValStr (nCode & 255, szText, 10,  0, FALSE); break;
              default: ValStr (nCode & 255, szText,  8, -3, FALSE);
            }
          if (!SetDlgItemText (hDlg, IDC_EDIT61, szText))
            {
              MessageBox (hDlg, _T("SetDlgItemText"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          /* ja:WI{^̐ݒ */
          if (!CheckRadioButton (hDlg, IDC_RADIOBUTTON61, IDC_RADIOBUTTON63,
                                            IDC_RADIOBUTTON61 + (nCode >> 8)))
            {
              MessageBox (hDlg, _T("CheckRadioButton"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          /* ja:Abv_ERg[̐ݒ */
          SendDlgItemMessage (hDlg, IDC_UPDOWN61,
                                UDM_SETPOS, 0, MAKELPARAM (nCode & 255, 0));
          SendDlgItemMessage (hDlg, IDC_UPDOWN61,
                                        UDM_SETRANGE, 0, MAKELPARAM (255, 0));
        }
        return TRUE;
      case WM_VSCROLL:
        {
          TCHAR szText[13];

          switch (nCode >> 8)
            {
              case  0: ValStr (HIWORD (wParam), szText, 16, -2, FALSE); break;
              case  1: ValStr (HIWORD (wParam), szText, 10,  0, FALSE); break;
              default: ValStr (HIWORD (wParam), szText,  8, -3, FALSE);
            }
          if (!SetDlgItemText (hDlg, IDC_EDIT61, szText))
            {
              MessageBox (hDlg, _T("SetDlgItemText"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
            }
        }
        return TRUE;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDOK:
              *lpnCode=nCode;
            case IDCANCEL:
              if (!EndDialog (hDlg, LOWORD (wParam)))
                MessageBox (hDlg, _T("EndDialog"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              return TRUE;
            case IDC_EDIT61:
              {
                int nValue;
                TCHAR szText[13];

                if (HIWORD (wParam) != EN_CHANGE)
                  return TRUE;
                GetDlgItemText (hDlg, IDC_EDIT61, szText, 12);
                switch (nCode >> 8)
                  {
                    case  0: StrVal (&nValue, szText, 16, FALSE); break;
                    case  1: StrVal (&nValue, szText, 10, FALSE); break;
                    default: StrVal (&nValue, szText,  8, FALSE);
                  }
                nCode = nCode & 0x300 | nValue & 0xff;
                if (!(0 <= nValue && nValue <= 255 ? SetDlgItemTextA( hDlg,
                                                IDC_STATIC61, lpszCode[nValue])
                        : SetDlgItemText (hDlg, IDC_STATIC61,
                                        LoadText (hInst, IDS_OTHER_NOINPUT))))
                  {
                    MessageBox (hDlg, _T("SetDlgItemText"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                /* ja:Rg[̕\ */
                EnableDlgItem (hDlg, IDOK, 0 <= nValue && nValue <= 255
                                && !IsDBCSLeadByteEx (CP_SJIS, (BYTE)nValue));
              }
              return TRUE;
            case IDC_RADIOBUTTON61:
            case IDC_RADIOBUTTON62:
            case IDC_RADIOBUTTON63:
              {
                TCHAR szText[13];

                nCode = LOWORD (wParam) - IDC_RADIOBUTTON61 << 8
                                                                | nCode & 0xff;
                switch (nCode >> 8)
                  {
                    case  0:
                      ValStr (nCode & 255, szText, 16, -2, FALSE); break;
                    case  1:
                      ValStr (nCode & 255, szText, 10,  0, FALSE); break;
                    default:
                      ValStr (nCode & 255, szText,  8, -3, FALSE);
                  }
                if (!SetDlgItemText (hDlg, IDC_EDIT61, szText))
                  {
                    MessageBox (hDlg, _T("SetDlgItemText"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                  }
              }
          }
        return TRUE;
    }
  return FALSE;
}
