/*
    Text maid for Windows
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __TMAID_H__
#define __TMAID_H__


#include <tchar.h>
#include <windows.h>
#include "fndir.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define MAINCLASS _T("Text maid Main Window Class")
#define TEXTCLASS _T("Text maid Text Window Class")
#define APPLICATION _T("Text maid")
#define MAXFIND 1024
#define MENUTOP 6
#define MENUFILE 12
#define CP_SJIS 932


typedef struct _FILETYPE
{
  int nID;                          /* ja:t@C^CvID(-1:) */
  int nMargin;                      /* ja:E}[W */
  int nTab;                         /* ja:^u̕ */
  BOOL fAssociate;                  /* ja:TRUE:֘AÂ */
  BOOL fAutoIndent;                 /* ja:TRUE: */
  BOOL fCode;                       /* ja:TRUE:^ũR[h\ */
  BOOL fCRLF;                       /* ja:TRUE:sR[h\ */
  BOOL fEOF;                        /* ja:TRUE:1Ah𖖔ɏ */
  BOOL fLimit;                      /* ja:TRUE:E}[WŐ܂Ԃ */
  BOOL fOverWrite;                  /* ja:TRUE:t@C㏑mF */
  BOOL fRecycle;                    /* ja:TRUE:ݔ𗘗p */
  BOOL fSpace;                      /* ja:TRUE:Xy[XDF̎lpŕ\ */
  BOOL fSysColor;                   /* ja:TRUE:VXeFg */
  BOOL fTabConv;                    /* ja:TRUE:^uXy[Xɕϊ */
  BOOL fGline;                      /* ja:TRUE:Obh\ */
  BOOL fMline;                      /* ja:TRUE:E}[W\ */
  BOOL fUline;                      /* ja:TRUE:^u\ */
  BOOL fVline;                      /* ja:TRUE:^uc\ */
  COLORREF crColor[12];
  DWORD dwAuto;
  LOGFONT lf;
  TCHAR szText[MAXPATH], szExt[MAXPATH];
  UINT uCRLF, uCharSet;             /* ja:s,LN^[Zbg */
} FILETYPE, *LPFILETYPE;
typedef struct _DOING
{
  int nLength;                      /* ja: */
  BOOL fCaret;
  LPSTR lpszText;
  POINT ptCursor, ptSelect;
  struct _DOING *next;
} DOING, *LPDOING;
typedef struct _LINEBUF
{
  int nLength;                      /* ja: */
  BOOL fMargin;                     /* ja:TRUE:E}[W,FALSE:ʏ̉s */
  LPSTR lpszText;
  struct _LINEBUF *prev, *next;
} LINEBUF, *LPLINEBUF;
typedef struct _TEXTWND
{
  int nID;                          /* ja:t@C^CvID(-1:) */
  int nFontSize;                    /* ja:tHg̕ */
  int nMargin;                      /* ja:E}[W */
  int nMax;                         /* ja:s */
  int nOff;                         /* ja:݂yW */
  int nSame;                        /* ja:tpXɕt鐔l */
  int nTab;                         /* ja:^u̕ */
  BOOL fAutoIndent;                 /* ja:TRUE: */
  BOOL fCreate;                     /* ja:TRUE:VK쐬ꂽ,FALSE: */
  BOOL fEdit;                       /* ja:TRUE:ҏWĂ,FALSE:ҏW */
  BOOL fAssociate;                  /* ja:TRUE:֘AÂ */
  BOOL fCode;                       /* ja:TRUE:^ũR[h\ */
  BOOL fCRLF;                       /* ja:TRUE:sR[h\ */
  BOOL fEOF;                        /* ja:TRUE:1Ah𖖔ɏ */
  BOOL fLimit;                      /* ja:TRUE:E}[WŐ܂Ԃ */
  BOOL fOverWrite;                  /* ja:TRUE:t@C㏑mF */
  BOOL fRecycle;                    /* ja:TRUE:ݔ𗘗p */
  BOOL fSpace;                      /* ja:TRUE:Xy[XDF̎lpŕ\ */
  BOOL fSysColor;                   /* ja:TRUE:VXeFg */
  BOOL fTabConv;                    /* ja:TRUE:^uXy[Xɕϊ */
  BOOL fGline;                      /* ja:TRUE:Obh\ */
  BOOL fMline;                      /* ja:TRUE:E}[W\ */
  BOOL fUline;                      /* ja:TRUE:^u\ */
  BOOL fVline;                      /* ja:TRUE:^uc\ */
  COLORREF crColor[12];             /* ja:\F */
  HBRUSH hBrushWindow;              /* ja:wi */
  HBRUSH hBrushSpace;               /* ja:SpXy[X */
  HBRUSH hBrushCrlf;                /* ja:s */
  HBRUSH hBrushHighLight;           /* ja:Iꂽwi */
  HFONT hFont, hFontsm;             /* ja:tHg */
  HPEN hPenTab;                     /* ja:^u */
  HPEN hPenMargin;                  /* ja:E}[W */
  HPEN hPenGrid;                    /* ja:Obg */
  LOGFONT lf;                       /* ja:tHg */
  LPDOING lpUndo, lpRedo;           /* ja:ҏW */
  LPLINEBUF lpStart;                /* ja:Cobt@ */
  POINT ptCursor, ptTop, ptSelect;  /* ja:Lbgʒu,I */
  SIZE siWnd;                       /* ja:EChẼTCY */
  TCHAR szFile[MAXPATH];            /* ja:t@CƃtpX */
  UINT uCRLF, uCharSet;             /* ja:s,LN^[Zbg */
} TEXTWND, *LPTEXTWND;


/* ja:VXeϐ */
extern int nFileCount;          /* ja:VK쐬ꂽt@C̐ */
extern int nTypeCount;          /* ja:VK쐬ꂽt@C^Cv̐ */
extern BOOL fClipBoard;         /* ja:TRUE:Nbv{[hɂ,FALSE:Ȃ */
extern BOOL fZoomed;            /* ja:TRUE:ő剻,FALSE:ʏ */
extern UINT uDlMsg;             /* ja:hbOXg̃bZ[W */
extern UINT uIns;               /* ja:Lbg̏(0:},1:㏑) */


/* ja:t@C^Cv */
extern int nFileType;           /* ja:o^Ăt@C^Cv */
extern LPFILETYPE lpFileType;   /* ja:t@C^Cv */


/* ja:Ŝɑ΂ݒ(_CAOŕύX\) */
extern int nHistory;            /* ja:t@C̗̍ő吔(0...9) */
extern int nRegStat;            /* ja:WXgread/write */
extern DWORD dwFilter;          /* ja:tB^ */
extern TCHAR szOpenPath[MAXPATH];/* ja:Ōɓǂݍ񂾃t@C̃pX */
extern TCHAR szSavePath[MAXPATH];/* ja:Ōɏ񂾃t@C̃pX */
extern TCHAR szHelpFile[MAXPATH];/* ja:wṽt@C */


/* ja:F */
extern COLORREF crWindowText;   /* ja:EChE̕(W:) */
extern COLORREF crGrayText;     /* ja:DF̕(W:DF) */
extern COLORREF crHighLightText;/* ja:Iꂽ(W:) */
extern HBRUSH hBrushWindow;     /* ja:wi */
extern HBRUSH hBrushGray;       /* ja:SpXy[X,s */
extern HBRUSH hBrushHighLight;  /* ja:Iꂽwi */
extern HPEN hPenGray;           /* ja:^u,E}[W */
extern HPEN hPenGrid;           /* ja:Obg */
extern HPEN hPenNull;           /* ja:̃y */


extern HACCEL hAccel;           /* ja:ANZ[^L[ */
extern HINSTANCE hInst;
extern HMENU hMenuPopup;
extern HWND hDlgCancel;         /* ja:f_CAO{bNX */
extern HWND hWndMain;           /* ja:CEChE */
extern HWND hWndClient;         /* ja:MDINCAgEChE */
extern HWND hWndTool;           /* ja:CEChẼc[o[ */
extern HWND hWndStat;           /* ja:CEChẼXe[^Xo[ */


extern CHAR cCRLF[2];
extern LPSTR lpszCode[256];


/*
ja:\F
 0,
 1,wi
 2,Rg[R[h
 3,SpXy[X
 4,sR[h
 5,^u
 6,E}[W
 7,Obh
 8,Iꂽ
 9,Iꂽwi
10,()
11,Rg[R[h()

\
 0,Obh
 1,SpXy[X
 2,sR[h
 3,E}[W
 4,^uR[h
 5,^u
 6,֘At
 7,1AR[h
 8,ݔ
 9,VXeF
10,܂Ԃ
11,gp(PƂCR/LF)
12,㏑
13,c
14,0:,1:CRLF,2:CR,3:LF
15
16,0:,1:UNICODE(gGfBA),2:UNICODE(rbNGfBA)
17,3:UTF-7,4:UFT-8,5:ISO-2022-JP,6:EUC-JP,7:SHIFT_JIS
18

/u
0,啶
1,Spp
2,0ȂΉ֌
*/


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __TMAID_H__ */
