/*
    Text maid for Windows
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "tmaid.h"
#include <commctrl.h>
#include <shlobj.h>
#include "argument.h"
#include "dialog.h"
#include "file.h"
#include "find.h"
#include "jump.h"
#include "license.h"
#include "memapi.h"
#include "other.h"
#include "replace.h"
#include "resource.h"
#include "valchr.h"
#include "valstr.h"
#include "wndmain.h"
#include "wndtext.h"


/* ja:VXeϐ */
int nFileCount = 0;             /* ja:VK쐬ꂽt@C̐ */
int nTypeCount = 0;             /* ja:VK쐬ꂽt@C^Cv̐ */
BOOL fClipBoard = FALSE;        /* ja:TRUE:Nbv{[hɂ,FALSE:Ȃ */
BOOL fZoomed = FALSE;           /* ja:TRUE:ő剻,FALSE:ʏ */
UINT uDlMsg;                    /* hbOXg̃bZ[W */
UINT uIns=0;                    /* Lbg̏(0:},1:㏑) */


/* ja:t@C^Cv */
int nFileType = 0;              /* ja:o^Ăt@C^Cv */
LPFILETYPE lpFileType = NULL;   /* ja:t@C^Cv */


/* ja:Ŝɑ΂ݒ(_CAOŕύX\) */
int nHistory = 4;               /* ja:t@C̗̍ő吔(0...9) */
int nRegStat = 3;               /* ja:WXgread/write */
DWORD dwFilter = 0;             /* ja:tB^ */
TCHAR szOpenPath[MAXPATH];      /* ja:Ōɓǂݍ񂾃t@C̃pX */
TCHAR szSavePath[MAXPATH];      /* ja:Ōɏ񂾃t@C̃pX */
TCHAR szHelpFile[MAXPATH];      /* ja:wṽt@C */


/* ja:F */
COLORREF crWindowText;          /* ja:EChE̕(W:) */
COLORREF crGrayText;            /* ja:DF̕(W:DF) */
COLORREF crHighLightText;       /* ja:Iꂽ(W:) */
HBRUSH hBrushWindow = NULL;     /* ja:wi */
HBRUSH hBrushGray = NULL;       /* ja:SpXy[X,s */
HBRUSH hBrushHighLight = NULL;  /* ja:Iꂽwi */
HPEN hPenGray = NULL;           /* ja:^u,E}[W */
HPEN hPenGrid = NULL;           /* ja:Obg */
HPEN hPenNull;                  /* ja:̃y */


HACCEL hAccel;                  /* ja:ANZ[^L[ */
HINSTANCE hInst;
HMENU hMenuPopup = NULL;
HWND hDlgCancel;                /* ja:f_CAO{bNX */
HWND hWndMain;                  /* ja:CEChE */
HWND hWndClient;                /* ja:MDINCAgEChE */
HWND hWndTool;                  /* ja:CEChẼc[o[ */
HWND hWndStat;                  /* ja:CEChẼXe[^Xo[ */


CHAR cCRLF[2] = {0x0d, 0x0a};
LPSTR lpszCode[256];


/******************************************************************************
*                                                                             *
* ja:C֐Q                                                             *
*                                                                             *
******************************************************************************/
int WINAPI
WinMain (HINSTANCE hInstance,
         HINSTANCE hPrevInstance,
         LPSTR     lpszCmdLine,
         int       nCmdShow)
{
  int i, nArgc, nInitLine = 0;
  int nLeft = CW_USEDEFAULT, nTop = CW_USEDEFAULT;
  int nRight = CW_USEDEFAULT, nBottom = CW_USEDEFAULT;
  BOOL fNewFile = FALSE, fSecondWindow = FALSE;
  COLORREF crBtnFace, crHighLight, crWindow;
  DWORD dwStat;
  HKEY hKey;
  HMENU hMenu;
  LPITEMIDLIST pid;
  MSG msg;
  TCHAR **lpszArgv;
  WNDCLASS wc;

  InitCommonControls ();
  /* ja:ϐ̏ */
  hInst = hInstance;
  if (SHGetSpecialFolderLocation (NULL, CSIDL_PERSONAL, &pid) == NOERROR)
    {
      if (!SHGetPathFromIDList (pid, szOpenPath))
        {
          MessageBox (NULL, _T("SHGetPathFromIDList"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          return 0;
        }
      CoTaskMemFree (pid);
    }
  else
    {
      szOpenPath[0] = '\0';
    }
  lstrcpy (szSavePath, szOpenPath);
  i = GetModuleFileName (hInstance, szHelpFile, MAXPATH);
  if (0 < i && i < MAXPATH)
    {
      FNDIR fd;

      SplitFileName (szHelpFile, &fd);
      lstrcpy (fd.szExt, _T(".CHM"));
      MergeFileName (szHelpFile, &fd);
    }
  crBtnFace = GetSysColor (COLOR_BTNFACE);
  crGrayText = GetSysColor (COLOR_GRAYTEXT);
  crHighLight = GetSysColor (COLOR_HIGHLIGHT);
  crHighLightText = GetSysColor (COLOR_HIGHLIGHTTEXT);
  crWindow = GetSysColor (COLOR_WINDOW);
  crWindowText = GetSysColor (COLOR_WINDOWTEXT);
  for (i = 0; i < 256; i++)
    {
      lpszCode[i] = MemoryAlloc (sizeof (CHAR) * 5);
      LoadStringA (hInstance, IDS_CODE00 + i, lpszCode[i], 5);
    }

  /* ja:R}hC̉ */
  if (!MakeArgument (&nArgc, &lpszArgv, lpszCmdLine))
    {
      MessageBox (NULL, _T("MakeArgument"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      return 0;
    }

  /* ja:WXg̈R}hC擾 */
  for (i = 0; i < nArgc; i++)
    if (((lpszArgv[i])[0] == '-' || (lpszArgv[i])[0] == '/')
                        && (int)CharUpper ((LPTSTR)(lpszArgv[i])[1]) == 'Q')
      nRegStat = IsCharNumeric ((lpszArgv[i])[2]) && (lpszArgv[i])[3] == '\0'
                                                ? (lpszArgv[i])[2] - '0' : 3;

  if (nRegStat & 1 && RegOpenKeyEx (HKEY_CURRENT_USER,
                                    _T("Software\\IwamotoKazuki\\Text maid"),
                                    0, KEY_ALL_ACCESS, &hKey) == ERROR_SUCCESS)
    {
      /* ja:WXgǂݏo */
      HKEY hKeySub;
      RECT rc0;

      RegGetValueEx (hKey, _T("code"), REG_DWORD, &nCodeDef, sizeof (int));
      RegGetValueEx (hKey, _T("filter"), REG_DWORD, &dwFilter, sizeof (DWORD));
      RegGetValueEx (hKey, _T("findstat"), REG_DWORD, &dwStat, sizeof (DWORD));
      RegGetValueEx (hKey, _T("history"), REG_DWORD, &nHistory, sizeof (int));
      RegGetValueEx (hKey, _T("newfile"), REG_DWORD, &fNewFile, sizeof (BOOL));
      RegGetValueEx (hKey, _T("prev"), REG_DWORD,
                                                &fSecondWindow, sizeof (BOOL));
      RegGetValueEx (hKey, _T("zoomed"), REG_DWORD, &fZoomed, sizeof (BOOL));
      RegGetValueEx (hKey, _T("openpath"), REG_SZ,
                                        szOpenPath, MAXPATH * sizeof (TCHAR));
      RegGetValueEx (hKey, _T("savepath"), REG_SZ,
                                        szSavePath, MAXPATH * sizeof (TCHAR));
      if (RegGetValueEx (hKey, _T("rect"),
                            REG_BINARY, &rc0, sizeof (RECT)) == ERROR_SUCCESS)
        {
          RECT rc1, rc2;

          rc1.left = rc1.top = 0;
          rc1.right = GetSystemMetrics (SM_CXSCREEN);
          rc1.bottom = GetSystemMetrics (SM_CYSCREEN);
          if (IntersectRect (&rc2, &rc0, &rc1)
                            && rc2.left < rc2.right && rc2.top < rc2.bottom)
            {
              nLeft = rc2.left;
              nTop = rc2.top;
              nRight = rc2.right - nLeft;
              nBottom = rc2.bottom - nTop;
            }
          else
            {
              nLeft = nTop = nRight = nBottom = CW_USEDEFAULT;
            }
        }
      bFindArrow = !(dwStat & 4);
      bFindCase = dwStat & 1;
      bFindWidth = dwStat & 2;
      bReplaceArrow = !(dwStat & 32);
      bReplaceCase = dwStat & 8;
      bReplaceWidth = dwStat & 16;
      /* ja:t@C^Cv */
      RegGetValueEx (hKey, _T("ftnum"), REG_DWORD, &nFileType, sizeof (int));
      lpFileType = MemoryAlloc (nFileType * sizeof (FILETYPE));
      for (i = 0; i < nFileType; i++)
        {
          DWORD dwData;
          TCHAR szName[MAXPATH];

          wsprintf (szName, _T("FILETYPE%d"), i);
          if (RegOpenKeyEx (hKey, szName, 0, KEY_ALL_ACCESS,
                                                    &hKeySub) != ERROR_SUCCESS)
            break;
          lpFileType[i].nID = nTypeCount++;
          RegGetValueEx (hKeySub, _T("text"), REG_SZ,
                            lpFileType[i].szText, MAXPATH * sizeof (TCHAR));
          RegGetValueEx (hKeySub, _T("ext"), REG_SZ,
                                lpFileType[i].szExt, MAXPATH * sizeof (TCHAR));
          RegGetValueEx (hKeySub, _T("margin"), REG_DWORD,
                                &lpFileType[i].nMargin, sizeof (int));
          RegGetValueEx (hKeySub, _T("tab"), REG_DWORD,
                                &lpFileType[i].nTab, sizeof (int));
          RegGetValueEx (hKeySub, _T("auto"), REG_DWORD,
                                &lpFileType[i].dwAuto, sizeof (DWORD));
          RegGetValueEx (hKeySub, _T("view"), REG_DWORD,
                                &dwStat, sizeof (DWORD));
          if (RegQueryValueEx (hKeySub, _T("logfont"), NULL, NULL,
                                            NULL, &dwData) == ERROR_SUCCESS)
            if (dwData == sizeof (LOGFONT))
              {
                RegGetValueEx (hKeySub, _T("logfont"), REG_BINARY,
                                        &lpFileType[i].lf, sizeof (LOGFONT));
              }
#ifdef UNICODE
            else if (dwData == sizeof (LOGFONTA))
              {
                LOGFONTA lfa;

                RegGetValueEx (hKeySub, _T("logfont"), REG_BINARY,
                                                    &lfa, sizeof (LOGFONTA));
                lpFileType[i].lf.lfHeight = lfa.lfHeight;
                lpFileType[i].lf.lfWidth = lfa.lfWidth;
                lpFileType[i].lf.lfEscapement = lfa.lfEscapement;
                lpFileType[i].lf.lfOrientation = lfa.lfOrientation;
                lpFileType[i].lf.lfWeight = lfa.lfWeight;
                lpFileType[i].lf.lfItalic = lfa.lfItalic;
                lpFileType[i].lf.lfUnderline = lfa.lfUnderline;
                lpFileType[i].lf.lfStrikeOut = lfa.lfStrikeOut;
                lpFileType[i].lf.lfCharSet = lfa.lfCharSet;
                lpFileType[i].lf.lfOutPrecision = lfa.lfOutPrecision;
                lpFileType[i].lf.lfClipPrecision = lfa.lfClipPrecision;
                lpFileType[i].lf.lfQuality = lfa.lfQuality;
                lpFileType[i].lf.lfPitchAndFamily = lfa.lfPitchAndFamily;
                MultiByteToWideChar (CP_ACP, 0, lfa.lfFaceName, -1,
                                    lpFileType[i].lf.lfFaceName, LF_FACESIZE);
              }
#else /* not UNICODE */
            else if (dwData == sizeof (LOGFONTW))
              {
                LOGFONTA lfw;

                RegGetValueEx (hKeySub, _T("logfont"), REG_BINARY,
                                                    &lfw, sizeof (LOGFONTW));
                lpFileType[i].lf.lfHeight = lfw.lfHeight;
                lpFileType[i].lf.lfWidth = lfw.lfWidth;
                lpFileType[i].lf.lfEscapement = lfw.lfEscapement;
                lpFileType[i].lf.lfOrientation = lfw.lfOrientation;
                lpFileType[i].lf.lfWeight = lfw.lfWeight;
                lpFileType[i].lf.lfItalic = lfw.lfItalic;
                lpFileType[i].lf.lfUnderline = lfw.lfUnderline;
                lpFileType[i].lf.lfStrikeOut = lfw.lfStrikeOut;
                lpFileType[i].lf.lfCharSet = lfw.lfCharSet;
                lpFileType[i].lf.lfOutPrecision = lfw.lfOutPrecision;
                lpFileType[i].lf.lfClipPrecision = lfw.lfClipPrecision;
                lpFileType[i].lf.lfQuality = lfw.lfQuality;
                lpFileType[i].lf.lfPitchAndFamily = lfw.lfPitchAndFamily;
                WideCharToMultiByte (CP_ACP, 0, lfw.lfFaceName, -1,
                        lpFileType[i].lf.lfFaceName, LF_FACESIZE, NULL, NULL);
              }
#endif /* not UNICODE */
          RegGetValueEx (hKeySub, _T("color"), REG_BINARY,
                                lpFileType[i].crColor, sizeof (COLORREF) * 12);
          if (RegCloseKey (hKeySub) != ERROR_SUCCESS)
            {
              MessageBox (NULL, _T("RegCloseKey"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              RegCloseKey (hKey);
              return 0;
            }
          lpFileType[i].fAssociate = dwStat & 64;
          lpFileType[i].fAutoIndent = dwStat & 2048;
          lpFileType[i].fCode = dwStat & 16;
          lpFileType[i].fCRLF = dwStat & 4;
          lpFileType[i].fEOF = dwStat & 128;
          lpFileType[i].fLimit = dwStat & 1024;
          lpFileType[i].fOverWrite = dwStat & 4096;
          lpFileType[i].fRecycle = dwStat & 256;
          lpFileType[i].fSpace = dwStat & 2;
          lpFileType[i].fSysColor = dwStat & 512;
          lpFileType[i].fTabConv = dwStat & 524288;
          lpFileType[i].fGline = dwStat & 1;
          lpFileType[i].fMline = dwStat & 8;
          lpFileType[i].fUline = dwStat & 32;
          lpFileType[i].fVline = dwStat & 8192;
          lpFileType[i].uCRLF = dwStat >> 14 & 3;
          lpFileType[i].uCharSet = dwStat >> 16 & 7;
        }
      nFileType = i;
      /* ja: */
      RegGetValueEx (hKey, _T("findnum"), REG_DWORD, &nFind, sizeof (int));
      if (nFind > 0 && RegOpenKeyEx (hKey, _T("find"), 0, KEY_ALL_ACCESS,
                                                    &hKeySub) == ERROR_SUCCESS)
        {
          for (i = 0; i < nFind; i++)
            {
              TCHAR szName[MAXPATH];

              lpszFind[i] = MemoryAlloc (MAXFIND * sizeof (TCHAR));
              wsprintf (szName, _T("findstr%02d"), i);
              if (RegGetValueEx (hKeySub, szName, REG_SZ, lpszFind[i], MAXFIND)
                                    != ERROR_SUCCESS || *lpszFind[i] == '\0')
                {
                  MemoryFree (lpszFind[i]);
                  break;
                }
              lpszFind[i] = MemoryReAlloc (lpszFind[i],
                                (lstrlen (lpszFind[i]) + 1) * sizeof (TCHAR));
            }
          nFind = i;
          if (RegCloseKey (hKeySub) != ERROR_SUCCESS)
            {
              MessageBox (NULL, _T("RegCloseKey"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              RegCloseKey (hKey);
              return 0;
            }
        }
      /* ja:u */
      RegGetValueEx (hKey, _T("repnum"), REG_DWORD, &nReplace, sizeof (int));
      if (nReplace > 0 && RegOpenKeyEx (hKey, _T("replace"), 0, KEY_ALL_ACCESS,
                                                    &hKeySub) == ERROR_SUCCESS)
        {
          for (i = 0; i < nReplace; i++)
            {
              TCHAR szName[MAXPATH];

              lpszReplace[i] = MemoryAlloc (MAXFIND * sizeof (TCHAR));
              wsprintf (szName, _T("repstr%02d"), i);
              if (RegGetValueEx (hKeySub, szName, REG_SZ, lpszReplace[i],
                        MAXFIND) != ERROR_SUCCESS || *lpszReplace[i] == '\0')
                {
                  MemoryFree (lpszReplace[i]);
                  break;
                }
              lpszReplace[i] = MemoryReAlloc (lpszReplace[i],
                            (lstrlen (lpszReplace[i]) + 1) * sizeof (TCHAR));
            }
          nReplace = i;
          if (RegCloseKey (hKeySub) != ERROR_SUCCESS)
            {
              MessageBox (NULL, _T("RegCloseKey"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
              RegCloseKey (hKey);
              return 0;
            }
        }
      if (RegCloseKey (hKey) != ERROR_SUCCESS)
        {
          MessageBox (NULL, _T("RegCloseKey"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          return 0;
        }
    }
  else if (DialogBoxParamGUI (hInstance, MAKEINTRESOURCE (DIALOG_1),
                            NULL, LicenseDlgProc, (LPARAM)hInstance) != IDOK)
    {
      /* ja:CZXւ̓ӂȂAI */
      return 0;
    }

  /* ja:R}hC */
  for (i = 0; i < nArgc; i++)
    if ((lpszArgv[i])[0] == '-' || (lpszArgv[i])[0] == '/')
      switch ((int)CharUpper ((LPTSTR)(lpszArgv[i])[1]))
        {
          case 'C':
            if ((lpszArgv[i])[2] == '\0')
              nCodeDef = ' ';
            else
              StrVal (&nCodeDef, lpszArgv[i] + 2, 10, TRUE);
            break;
          case 'F':
            if ((lpszArgv[i])[2] == '\0')
              dwFilter = 0;
            else
              StrVal (&dwFilter, lpszArgv[i] + 2, 10, TRUE);
            break;
          case 'H':
            nHistory = IsCharNumeric ((lpszArgv[i])[2])
                    && (lpszArgv[i])[3] == '\0' ? (lpszArgv[i])[2] - '0' : 4;
            break;
          case 'L':
            StrVal (&nInitLine, lpszArgv[i] + 2, 10, TRUE);
            break;
          case 'N':
            fNewFile = (lpszArgv[i])[2] - '0';
            break;
          case 'Q':
            break;
          case 'S':
            if ((lpszArgv[i])[2] == '\0')
              {
                bFindArrow = TRUE;
                bFindCase = FALSE;
                bFindWidth=FALSE;
                bReplaceArrow = TRUE;
                bReplaceCase = FALSE;
                bReplaceWidth = FALSE;
              }
            else
              {
                StrVal (&dwStat, lpszArgv[i] + 2, 10, TRUE);
                bFindArrow = !(dwStat & 4);
                bFindCase = dwStat & 1;
                bFindWidth = dwStat & 2;
                bReplaceArrow = !(dwStat & 32);
                bReplaceCase = dwStat & 8;
                bReplaceWidth = dwStat & 16;
              }
            break;
          case 'W':
            if ((lpszArgv[i])[2] == '\0')
              {
                nLeft = nTop = nRight = nBottom = CW_USEDEFAULT;
              }
            else
              {
                int j, k = 2;

                for (j = 0; j < 4; j++)
                  {
                    int l;
                    TCHAR szName[MAXPATH];

                    for (l = 0; l < 8 && IsCharNumeric ((lpszArgv[i])[k]); l++)
                      szName[l] = (lpszArgv[i])[k++];
                    szName[l] = '\0';
                    if (l != 0 && StrVal (&l, szName, 10, TRUE))
                      {
                        switch (j)
                          {
                            case 0: nLeft = l; break;
                            case 1: nTop = l; break;
                            case 2: nRight = l; break;
                            case 3: nBottom = l;
                          }
                      }
                    while ((lpszArgv[i])[k] != '\0' && (lpszArgv[i])[k] != ','
                                                    && (lpszArgv[i])[k] != '.')
                      k++;
                    if ((lpszArgv[i])[k] == '\0')
                      break;
                    k++;
                  }
              }
            break;
          case 'X':
            fSecondWindow = (lpszArgv[i])[2] - '0';
            break;
          case 'Z':
            fZoomed = (lpszArgv[i])[2] - '0';
            break;
          default:
            MessageBox (NULL, LoadText (hInst, IDS_OTHER_COMMAND),
                                APPLICATION, MB_OK | MB_ICONSTOP);
            return 0;
        }

  if (!fSecondWindow && (hWndMain = FindWindow (MAINCLASS, NULL)))
    {
      ATOM atom;

      if (IsIconic (hWndMain))
        ShowWindow (hWndMain, SW_RESTORE);
      else
        SetForegroundWindow (hWndMain);
      atom = GlobalAddAtom (_T("-L0"));
      if (atom == 0)
        {
          MessageBox (NULL, _T("GlobalAddAtom"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          return 0;
        }
      SendMessage (hWndMain, WM_USER, atom, 0);
      if (GlobalDeleteAtom (atom) != 0)
        {
          MessageBox (NULL, _T("GlobalDeleteAtom"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          return 0;
        }
      for (i = 0; i < nArgc; i++)
        if ((lpszArgv[i])[0] == '-' || (lpszArgv[i])[0] == '/')
          {
            atom = GlobalAddAtom (lpszArgv[i]);
            if (atom == 0)
              {
                MessageBox (NULL, _T("GlobalAddAtom"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                return 0;
              }
            SendMessage (hWndMain, WM_USER, atom, 0);
            if (GlobalDeleteAtom (atom) != 0)
              {
                MessageBox (NULL, _T("GlobalDeleteAtom"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                return 0;
              }
          }
      for (i = 0; i < nArgc; i++)
        if ((lpszArgv[i])[0] != '-' && (lpszArgv[i])[0] != '/')
          {
            TCHAR szFile[MAXPATH];

            GetLongFile (szFile, lpszArgv[i]);
            atom = GlobalAddAtom (szFile);
            if (atom == 0)
              {
                MessageBox (NULL, _T("GlobalAddAtom"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                return 0;
              }
            SendMessage (hWndMain, WM_USER, atom, 0);
            if (GlobalDeleteAtom (atom) != 0)
              {
                MessageBox (NULL, _T("GlobalDeleteAtom"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
                return 0;
              }
          }
      return 0;
    }

  if (nFileType <= 0)
    {
      HDC hDC;
      TEXTMETRIC tm;

      nFileType = 1;
      lpFileType = MemoryAlloc (nFileType * sizeof (FILETYPE));
      lpFileType[0].nID = nTypeCount++;
      lstrcpy (lpFileType[0].szText, LoadText (hInst, IDS_OTHER_FILTER));
      lstrcpy (lpFileType[0].szExt, _T("*.*"));
      lpFileType[0].nMargin = 80;
      lpFileType[0].nTab = 8;
      lpFileType[0].fAssociate = TRUE;
      lpFileType[0].fSysColor = TRUE;
      /* ja:tHg */
      hDC = CreateCompatibleDC (NULL);
      if (!hDC)
        {
          MessageBox (NULL, _T("CreateCompatibleDC"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          return 0;
        }
      for (i = 0; i < 6; i++)
        {
          const int nObject[6] = {DEFAULT_GUI_FONT, ANSI_VAR_FONT,
            SYSTEM_FONT, ANSI_FIXED_FONT, SYSTEM_FIXED_FONT, OEM_FIXED_FONT};
          HFONT hFont;

          hFont = GetStockObject (nObject[i]);
          if (!hFont)
            continue;
          hFont = SelectObject (hDC, hFont);
          if (GetTextMetrics (hDC, &tm) && GetTextFace (hDC, LF_FACESIZE,
                                            lpFileType[0].lf.lfFaceName) > 0)
            {
              hFont = SelectObject (hDC, hFont);
              break;
            }
          hFont = SelectObject (hDC,hFont);
        }
      if (!DeleteDC (hDC))
        {
          MessageBox (NULL, _T("DeleteDC"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          return 0;
        }
      if (i < 6)
        {
          lpFileType[0].lf.lfHeight = tm.tmHeight;
          lpFileType[0].lf.lfWidth = tm.tmAveCharWidth;
          lpFileType[0].lf.lfEscapement =
          lpFileType[0].lf.lfOrientation = 0;
          lpFileType[0].lf.lfWeight = tm.tmWeight;
          lpFileType[0].lf.lfItalic = tm.tmItalic;
          lpFileType[0].lf.lfUnderline = tm.tmUnderlined;
          lpFileType[0].lf.lfStrikeOut = tm.tmStruckOut;
          lpFileType[0].lf.lfCharSet = tm.tmCharSet;
          lpFileType[0].lf.lfOutPrecision = OUT_DEFAULT_PRECIS;
          lpFileType[0].lf.lfClipPrecision = CLIP_DEFAULT_PRECIS;
          lpFileType[0].lf.lfQuality = DEFAULT_QUALITY;
          lpFileType[0].lf.lfPitchAndFamily = tm.tmPitchAndFamily;
        }
      else if (!SystemParametersInfo (SPI_GETICONTITLELOGFONT,
                    sizeof (LOGFONT), &lpFileType[0].lf, SPIF_UPDATEINIFILE))
        {
          MessageBox (NULL, _T("SystemParametersInfo"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
          return 0;
        }
      lpFileType[0].lf.lfPitchAndFamily
                    = lpFileType[0].lf.lfPitchAndFamily & ~15 | FIXED_PITCH;
      lpFileType[0].crColor[ 0] = crWindowText;
      lpFileType[0].crColor[ 1] = crWindow;
      lpFileType[0].crColor[ 2] =
      lpFileType[0].crColor[ 3] =
      lpFileType[0].crColor[ 4] =
      lpFileType[0].crColor[ 5] =
      lpFileType[0].crColor[ 6] = crGrayText;
      lpFileType[0].crColor[ 7] = crBtnFace;
      lpFileType[0].crColor[ 8] = crHighLightText;
      lpFileType[0].crColor[ 9] = crHighLight;
      lpFileType[0].crColor[10] = RGB (  0,   0,   0);
      lpFileType[0].crColor[11] = RGB (128, 128, 128);
    }

  wc.style         = 0;
  wc.lpfnWndProc   = WndProc;
  wc.cbClsExtra    = 0;
  wc.cbWndExtra    = 0;
  wc.hInstance     = hInstance;
  wc.hIcon         = LoadIcon (hInstance, MAKEINTRESOURCE (ICON_1));
  wc.hCursor       = LoadCursor (NULL, IDC_ARROW);
  wc.hbrBackground = (HBRUSH)(COLOR_APPWORKSPACE + 1);
  wc.lpszMenuName  = NULL;
  wc.lpszClassName = MAINCLASS;
  if (RegisterClass (&wc) == 0)
    {
      MessageBox (NULL, _T("RegisterClass"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      return 0;
    }

  wc.style         = CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW;
  wc.cbClsExtra    = 0;
  wc.lpfnWndProc   = TextWndProc;
  wc.cbWndExtra    = sizeof (LPTEXTWND);
  wc.hInstance     = hInstance;
  wc.hIcon         = LoadIcon (hInstance, MAKEINTRESOURCE (ICON_1));
  wc.hCursor       = LoadCursor (NULL, IDC_IBEAM);
  wc.hbrBackground = NULL;
  wc.lpszMenuName  = NULL;
  wc.lpszClassName = TEXTCLASS;
  if (RegisterClass (&wc) == 0)
    {
      MessageBox (NULL, _T("RegisterClass"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      return 0;
    }

  hWndMain = CreateWindowEx (WS_EX_ACCEPTFILES, MAINCLASS,
                            APPLICATION, WS_CLIPCHILDREN |WS_OVERLAPPEDWINDOW,
                            nLeft, nTop, nRight, nBottom, NULL,
                            LoadMenu (hInstance, MAKEINTRESOURCE (MENU_1)),
                                                            hInstance, NULL);
  if (!hWndMain)
    {
      MessageBox (NULL, _T("CreateWindowEx"),
                        APPLICATION, MB_OK | MB_ICONSTOP);
      return 0;
    }

  hAccel = LoadAccelerators (hInstance, MAKEINTRESOURCE (MENU_1));
  if (!hAccel)
    {
      MessageBox (hWndMain, _T("LoadAccelerators"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWndMain);
      return 0;
    }

  ShowWindow (hWndMain, nCmdShow);
  if (!UpdateWindow (hWndMain))
    {
      MessageBox (hWndMain, _T("UpdateWindow"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWndMain);
      return 0;
    }

  hMenu = GetMenu (hWndMain);
  if (!hMenu)
    {
      MessageBox (hWndMain, _T("GetMenu"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWndMain);
      return 0;
    }
  hMenu = GetSubMenu (hMenu, 0);
  if (!hMenu)
    {
      MessageBox (hWndMain, _T("GetSubMenu"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWndMain);
      return 0;
    }
  if (nRegStat & 1 && RegOpenKeyEx (HKEY_CURRENT_USER,
                                    _T("Software\\IwamotoKazuki\\Text maid"),
                                    0, KEY_ALL_ACCESS, &hKey) == ERROR_SUCCESS)
    {
      for (i = 0; i <nHistory; i++)
        {
          TCHAR szName[MAXPATH], szHistory[MAXPATH + 3];

          wsprintf (szName, _T("history%d"), i);
          if (RegGetValueEx (hKey, szName, REG_SZ, szHistory + 3,
                                    MAXPATH * sizeof (TCHAR)) != ERROR_SUCCESS
                                                    || szHistory[3] == '\0')
            break;
          szHistory[0] = '&';
          szHistory[1] = i + '1';
          szHistory[2] = ' ';
          if (!InsertMenu (hMenu, i + MENUFILE - 1,
                                            MF_BYPOSITION, i + 200, szHistory))
            {
              MessageBox (hWndMain, _T("InsertMenu"),
                                    APPLICATION, MB_OK | MB_ICONSTOP);
              DestroyWindow (hWndMain);
              return 0;
            }
        }
      if (RegCloseKey (hKey) != ERROR_SUCCESS)
        {
          MessageBox (hWndMain, _T("RegCloseKey"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
          DestroyWindow (hWndMain);
          return 0;
        }
      if (i != 0 && !InsertMenu (hMenu, i + MENUFILE - 1,
                                        MF_BYPOSITION | MF_SEPARATOR, 0, NULL))
        {
          MessageBox (hWndMain, _T("InsertMenu"),
                                APPLICATION, MB_OK | MB_ICONSTOP);
          DestroyWindow (hWndMain);
          return 0;
        }
    }
  if (!DrawMenuBar (hWndMain))
    {
      MessageBox (hWndMain, _T("DrawMenuBar"),
                            APPLICATION, MB_OK | MB_ICONSTOP);
      DestroyWindow (hWndMain);
      return 0;
    }

  for (i = 0; i <nArgc; i++)
    if ((lpszArgv[i])[0] != '-' && (lpszArgv[i])[0] != '/')
      {
        HWND hWnd;

        fNewFile = FALSE;
        hWnd = OpenEditFile (lpszArgv[i]);
        if (!hWnd || nInitLine != 0 && !JumpOperation (hWnd, nInitLine))
          {
            MessageBox (hWndMain, lpszArgv[i],
                                    APPLICATION, MB_OK | MB_ICONSTOP);
            break;
          }
      }
  if (fNewFile)
    OpenEditFile (NULL);

  FreeArgument (nArgc, &lpszArgv);

  while (GetMessage (&msg, NULL, 0, 0))
    if (!TranslateMDISysAccel (hWndClient, &msg)
                            && !TranslateAccelerator (hWndMain, hAccel, &msg))
      {
        TranslateMessage (&msg);
        DispatchMessage (&msg);
      }
  return 0;
}
