/*
    Text maid for Windows
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "reload.h"
#include "resource.h"


/******************************************************************************
*                                                                             *
* ja:ēǂݍ݃_CAO֐Q                                               *
*                                                                             *
******************************************************************************/
BOOL CALLBACK
ReloadDlgProc (HWND   hDlg,
               UINT   uMsg,
               WPARAM wParam,
               LPARAM lParam)
{
  static LPRELOAD lpReload;

  switch (uMsg)
    {
      case WM_INITDIALOG:
        {
          int i = 0, j = 0, k = 0;
          TCHAR szMessage[4096];

          lpReload = (LPRELOAD)lParam;
          /* ja:R{{bNX̐ݒ */
          LoadString (hInst, IDS_FTYPE_CRLF, szMessage, 4096);
          while (k < 3)
#ifndef UNICODE
            if (IsDBCSLeadByteEx (CP_SJIS, szMessage[i]))
              {
                i += 2;
              }
            else
#endif /* not UNICODE */
              {
                if (szMessage[i] == '\0' || szMessage[i] == ',')
                  {
                    szMessage[i] = '\0';
                    SendDlgItemMessage (hDlg, IDC_COMBOBOX21, CB_SETITEMDATA,
                    SendDlgItemMessage (hDlg, IDC_COMBOBOX21, CB_ADDSTRING,
                                            0, (LPARAM)(szMessage + j)), ++k);
                    j = i + 1;
                  }
                i++;
              }
          for (i = SendDlgItemMessage (hDlg, IDC_COMBOBOX21, CB_GETCOUNT,
                                                        0, 0) - 1; i >= 0; i--)
            if (SendDlgItemMessage (hDlg, IDC_COMBOBOX21, CB_GETITEMDATA,
                                                    i, 0) == lpReload->uCRLF)
              {
                SendDlgItemMessage (hDlg, IDC_COMBOBOX21, CB_SETCURSEL, i, 0);
                break;
              }
          if (i < 0)
            SendDlgItemMessage (hDlg, IDC_COMBOBOX21, CB_SETCURSEL, 0, 0);
          LoadString (hInst, IDS_FTYPE_CHARSET, szMessage, 4096);
          i = j = k = 0;
          while (k < 7)
#ifndef UNICODE
            if (IsDBCSLeadByteEx (CP_SJIS, szMessage[i]))
              {
                i += 2;
              }
            else
#endif /* not UNICODE */
              {
                if (szMessage[i] == '\0' || szMessage[i] == ',')
                  {
                    szMessage[i] = '\0';
                    SendDlgItemMessage (hDlg, IDC_COMBOBOX22, CB_SETITEMDATA,
                    SendDlgItemMessage (hDlg, IDC_COMBOBOX22, CB_ADDSTRING,
                                            0, (LPARAM)(szMessage + j)), ++k);
                    j = i + 1;
                  }
                i++;
              }
          for (i = SendDlgItemMessage (hDlg, IDC_COMBOBOX22, CB_GETCOUNT,
                                                        0, 0) - 1; i >= 0; i--)
            if (SendDlgItemMessage (hDlg, IDC_COMBOBOX22, CB_GETITEMDATA,
                                                i, 0) == lpReload->uCharSet)
              {
                SendDlgItemMessage (hDlg, IDC_COMBOBOX22, CB_SETCURSEL, i, 0);
                break;
              }
          if (i < 0)
            SendDlgItemMessage (hDlg, IDC_COMBOBOX22, CB_SETCURSEL, 0, 0);
        }
        return TRUE;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDOK:
              lpReload->uCRLF = SendDlgItemMessage (hDlg, IDC_COMBOBOX21,
                                    CB_GETITEMDATA, SendDlgItemMessage (hDlg,
                                    IDC_COMBOBOX21, CB_GETCURSEL, 0, 0), 0);
              lpReload->uCharSet = SendDlgItemMessage (hDlg, IDC_COMBOBOX22,
                                    CB_GETITEMDATA, SendDlgItemMessage (hDlg,
                                    IDC_COMBOBOX22, CB_GETCURSEL, 0, 0), 0);
            case IDCANCEL:
              if (!EndDialog (hDlg, LOWORD (wParam)))
                MessageBox (hDlg, _T("EndDialog"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
          }
        return TRUE;
    }
  return FALSE;
}
