/*
    Text maid for Windows
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "prop.h"
#include <commctrl.h>
#include "dialog.h"
#include "ftype.h"
#include "other.h"
#include "resource.h"


/******************************************************************************
*                                                                             *
* ja:vpeB֐Q                                                         *
*                                                                             *
******************************************************************************/
BOOL CALLBACK
PropertyDlgProc (HWND   hDlg,
                 UINT   uMsg,
                 WPARAM wParam,
                 LPARAM lParam)
{
  static int nID, nFontSize;
  static LOGFONT lf;
  static LPCTSTR lpszColor[12];
  static LPFILETYPE lpFType;
  static TCHAR szColor[4096];

  switch (uMsg)
    {
      case WM_INITDIALOG:
        {
          int i = 0, j = 1, k;
          TCHAR szMessage[4096];

          lpFType = (LPFILETYPE)lParam;
          nID = lpFType->nID;
          lf = lpFType->lf;
          /* ja:F̓ǂݍ */
          LoadString (hInst, IDS_FTYPE_COLOR, szColor, 4096);
          lpszColor[0] = szColor;
          while (szColor[i] != '\0' && j < 12)
#ifndef UNICODE
            if (IsDBCSLeadByteEx (CP_SJIS, szColor[i]))
              {
                i += 2;
              }
            else
#endif /* not UNICODE */
              {
                if (szColor[i] == ',')
                  {
                    lpszColor[j++] = szColor + i + 1;
                    szColor[i] = '\0';
                  }
                i++;
              }
          /* ja:`FbN{bNX̐ݒ */
          if (!CheckDlgButton (hDlg, IDC_CHECKBOX51,
                            lpFType->fGline ? BST_CHECKED : BST_UNCHECKED)
                    || !CheckDlgButton (hDlg, IDC_CHECKBOX52,
                            lpFType->fSpace ? BST_CHECKED : BST_UNCHECKED)
                    || !CheckDlgButton (hDlg, IDC_CHECKBOX53,
                            lpFType->fCRLF ? BST_CHECKED : BST_UNCHECKED)
                    || !CheckDlgButton (hDlg, IDC_CHECKBOX54,
                            lpFType->fMline ? BST_CHECKED : BST_UNCHECKED)
                    || !CheckDlgButton (hDlg, IDC_CHECKBOX55,
                            lpFType->fLimit ? BST_CHECKED : BST_UNCHECKED)
                    || !CheckDlgButton (hDlg, IDC_CHECKBOX56,
                            lpFType->fCode ? BST_CHECKED : BST_UNCHECKED)
                    || !CheckDlgButton (hDlg, IDC_CHECKBOX57,
                            lpFType->fUline ? BST_CHECKED : BST_UNCHECKED)
                    || !CheckDlgButton (hDlg, IDC_CHECKBOX58,
                            lpFType->fVline ? BST_CHECKED : BST_UNCHECKED)
                    || !CheckDlgButton (hDlg, IDC_CHECKBOX59,
                            lpFType->fAutoIndent ? BST_CHECKED : BST_UNCHECKED)
                    || !CheckDlgButton (hDlg, IDC_CHECKBOX5A,
                            lpFType->fTabConv ? BST_CHECKED : BST_UNCHECKED)
                    || !CheckDlgButton (hDlg, IDC_CHECKBOX5B,
                            lpFType->fEOF ? BST_CHECKED : BST_UNCHECKED)
                    || !CheckDlgButton (hDlg, IDC_CHECKBOX5C,
                            lpFType->fRecycle ? BST_CHECKED : BST_UNCHECKED)
                    || !CheckDlgButton (hDlg, IDC_CHECKBOX5D,
                            lpFType->fOverWrite ? BST_CHECKED : BST_UNCHECKED)
                    || !CheckDlgButton (hDlg, IDC_CHECKBOX5E,
                            lpFType->fSysColor ? BST_CHECKED : BST_UNCHECKED))
            {
              MessageBox (hDlg, _T("CheckDlgButton"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          /* ja:R{{bNX̐ݒ */
          LoadString (hInst, IDS_FTYPE_CRLF, szMessage, 4096);
          i = j = k = 0;
          while (k < 3)
#ifndef UNICODE
            if (IsDBCSLeadByteEx (CP_SJIS, szMessage[i]))
              {
                i += 2;
              }
            else
#endif /* not UNICODE */
              {
                if (szMessage[i] == '\0' || szMessage[i] == ',')
                  {
                    szMessage[i] = '\0';
                    SendDlgItemMessage (hDlg, IDC_COMBOBOX51, CB_SETITEMDATA,
                    SendDlgItemMessage (hDlg, IDC_COMBOBOX51, CB_ADDSTRING,
                                            0, (LPARAM)(szMessage + j)), ++k);
                    j = i + 1;
                  }
                i++;
              }
          for (i = SendDlgItemMessage (hDlg, IDC_COMBOBOX51, CB_GETCOUNT,
                                                        0, 0) - 1; i >= 0; i--)
            if (SendDlgItemMessage (hDlg, IDC_COMBOBOX51, CB_GETITEMDATA,
                                                    i, 0) == lpFType->uCRLF)
              {
                SendDlgItemMessage (hDlg, IDC_COMBOBOX51, CB_SETCURSEL, i, 0);
                break;
              }
          if (i < 0)
            SendDlgItemMessage (hDlg, IDC_COMBOBOX51, CB_SETCURSEL, 0, 0);
          LoadString (hInst, IDS_FTYPE_CHARSET, szMessage, 4096);
          i = j = k = 0;
          while (k < 7)
#ifndef UNICODE
            if (IsDBCSLeadByteEx (CP_SJIS, szMessage[i]))
              {
                i += 2;
              }
            else
#endif /* not UNICODE */
              {
                if (szMessage[i] == '\0' || szMessage[i] == ',')
                  {
                    szMessage[i] = '\0';
                    SendDlgItemMessage (hDlg, IDC_COMBOBOX52, CB_SETITEMDATA,
                    SendDlgItemMessage (hDlg, IDC_COMBOBOX52, CB_ADDSTRING,
                                            0, (LPARAM)(szMessage + j)), ++k);
                    j = i + 1;
                  }
                i++;
              }
          for (i = SendDlgItemMessage (hDlg, IDC_COMBOBOX52, CB_GETCOUNT,
                                                        0, 0) - 1; i >= 0; i--)
            if (SendDlgItemMessage (hDlg, IDC_COMBOBOX52, CB_GETITEMDATA,
                                                    i, 0) == lpFType->uCharSet)
              {
                SendDlgItemMessage (hDlg, IDC_COMBOBOX52, CB_SETCURSEL, i, 0);
                break;
              }
          if (i < 0)
            SendDlgItemMessage (hDlg, IDC_COMBOBOX52, CB_SETCURSEL, 0, 0);
          /* ja:GfBgRg[̐ݒ */
          for (i = IDC_EDIT51; i <= IDC_EDIT52; i++)
            SendDlgItemMessage (hDlg, i, EM_LIMITTEXT, 12, 0);
          if (!SetDlgItemInt (hDlg, IDC_EDIT51, lpFType->nMargin, TRUE)
                    || !SetDlgItemInt (hDlg, IDC_EDIT52, lpFType->nTab, TRUE))
            {
              MessageBox (hDlg, _T("SetDlgItemInt"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          /* ja:Xg{bNX̐ݒ */
          SendDlgItemMessage (hDlg, IDC_LISTBOX51, LB_RESETCONTENT, 0, 0);
          for (i = 0; i < 12; i++)
            SendDlgItemMessage (hDlg, IDC_LISTBOX51, LB_SETITEMDATA,
                        SendDlgItemMessage (hDlg, IDC_LISTBOX51, LB_ADDSTRING,
                                0, (LPARAM)lpszColor[i]), lpFType->crColor[i]);
          /* ja:Abv_ERg[̐ݒ */
          SendDlgItemMessage (hDlg, IDC_UPDOWN51,
                                UDM_SETRANGE, 0, MAKELPARAM (UD_MAXVAL, 1));
          SendDlgItemMessage (hDlg, IDC_UPDOWN52,
                                UDM_SETRANGE, 0, MAKELPARAM (UD_MAXVAL, 1));
          /* ja:Rg[̕\ */
          if (!EnableDlgItem (hDlg, IDC_LISTBOX51, !lpFType->fSysColor)
                                        || !EnableDlgItem (hDlg, IDOK, FALSE))
            {
              MessageBox (hDlg, _T("EnableDlgItem"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
            }
        }
        return TRUE;
      case WM_MEASUREITEM:
        {
          HDC hDC;
          HWND hWnd;
          TEXTMETRIC tm;

          hWnd = GetDlgItem (hDlg, IDC_LISTBOX51);
          if (!hWnd)
            {
              MessageBox (hDlg, _T("GetDlgItem"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          hDC = GetDC (hWnd);
          if (!hDC)
            {
              MessageBox (hDlg, _T("GetDC"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          if (!GetTextMetrics (hDC, &tm))
            {
              MessageBox (hDlg, _T("GetTextMetrics"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              ReleaseDC (hDlg, hDC);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          if (ReleaseDC (hDlg, hDC) != 1)
            {
              MessageBox (hDlg, _T("ReleaseDC"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          nFontSize = (tm.tmHeight + 1) / 2;
          ((LPMEASUREITEMSTRUCT)lParam)->itemHeight = nFontSize * 2;
        }
        return TRUE;
      case WM_DRAWITEM:
        if (((LPDRAWITEMSTRUCT)lParam)->itemID == -1)
          break;
        switch (((LPDRAWITEMSTRUCT)lParam)->itemAction)
          {
            case ODA_SELECT:
            case ODA_DRAWENTIRE:
              {
                TCHAR szText[17];
                int nBkMode;
                COLORREF crText, crWindow;
                HBRUSH hBrush;
                RECT rc;
                nBkMode = SetBkMode(((LPDRAWITEMSTRUCT)lParam)->hDC,
                                                                TRANSPARENT);
                if (((LPDRAWITEMSTRUCT)lParam)->itemState & ODS_DISABLED)
                  {
                    crWindow
                        = SendMessage (((LPDRAWITEMSTRUCT)lParam)->hwndItem,
                        LB_GETITEMDATA, ((LPDRAWITEMSTRUCT)lParam)->itemID, 0);
                    crWindow= RGB(
                        (GetRValue (crWindow) + GetRValue (crGrayText)) / 2,
                        (GetGValue (crWindow) + GetGValue (crGrayText)) / 2,
                        (GetBValue (crWindow) + GetBValue (crGrayText)) / 2);
                    crText = SetTextColor (((LPDRAWITEMSTRUCT)lParam)->hDC,
                                                                crGrayText);
                    EnableScrollBar (((LPDRAWITEMSTRUCT)lParam)->hwndItem,
                                                    SB_VERT, ESB_DISABLE_BOTH);
                  }
                else
                  {
                    crWindow
                        = SendMessage (((LPDRAWITEMSTRUCT)lParam)->hwndItem,
                        LB_GETITEMDATA, ((LPDRAWITEMSTRUCT)lParam)->itemID, 0);
                    crText = SetTextColor (((LPDRAWITEMSTRUCT)lParam)->hDC,
                        ((LPDRAWITEMSTRUCT)lParam)->itemState & ODS_SELECTED
                                            ? crHighLightText : crWindowText);
                    EnableScrollBar (((LPDRAWITEMSTRUCT)lParam)->hwndItem,
                                                    SB_VERT, ESB_ENABLE_BOTH);
                  }
                if (!FillRect (((LPDRAWITEMSTRUCT)lParam)->hDC,
                                        &((LPDRAWITEMSTRUCT)lParam)->rcItem,
                        ((LPDRAWITEMSTRUCT)lParam)->itemState & ODS_SELECTED
                                            ? hBrushHighLight : hBrushWindow))
                  {
                    MessageBox (hDlg, _T("FillRect"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                hBrush = CreateSolidBrush (crWindow);
                if (!hBrush)
                  {
                    MessageBox (hDlg, _T("CreateSolidBrush"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                rc.left = ((LPDRAWITEMSTRUCT)lParam)->rcItem.left + 1;
                rc.top = ((LPDRAWITEMSTRUCT)lParam)->rcItem.top + 1;
                rc.right = rc.left + nFontSize * 3 - 2;
                rc.bottom = ((LPDRAWITEMSTRUCT)lParam)->rcItem.bottom - 1;
                if (!FillRect (((LPDRAWITEMSTRUCT)lParam)->hDC, &rc, hBrush))
                  {
                      MessageBox (hDlg, _T("FillRect"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                      EndDialog (hDlg, IDCANCEL);
                      return TRUE;
                  }
                if (!DeleteObject (hBrush))
                  {
                    MessageBox (hDlg, _T("DeleteObject"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                SendMessage (((LPDRAWITEMSTRUCT)lParam)->hwndItem, LB_GETTEXT,
                        ((LPDRAWITEMSTRUCT)lParam)->itemID, (LPARAM)szText);
                if (!TextOut (((LPDRAWITEMSTRUCT)lParam)->hDC,
                    ((LPDRAWITEMSTRUCT)lParam)->rcItem.left + nFontSize * 3,
                    ((LPDRAWITEMSTRUCT)lParam)->rcItem.top,
                                                    szText, lstrlen (szText)))
                  {
                    MessageBox (hDlg, _T("TextOut"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                SetBkMode (((LPDRAWITEMSTRUCT)lParam)->hDC, nBkMode);
                SetTextColor (((LPDRAWITEMSTRUCT)lParam)->hDC, crText);
              }
              break;
            case ODA_FOCUS:
              if (!DrawFocusRect (((LPDRAWITEMSTRUCT)lParam)->hDC,
                                        &((LPDRAWITEMSTRUCT)lParam)->rcItem))
                {
                  MessageBox (hDlg, _T("DrawFocusRect"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  EndDialog (hDlg, IDCANCEL);
                }
          }
        return TRUE;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDOK:
              {
                int i;

                lpFType->nID = nID;
                lpFType->nMargin
                                = GetDlgItemInt (hDlg, IDC_EDIT51, NULL, TRUE);
                lpFType->nTab = GetDlgItemInt (hDlg, IDC_EDIT52, NULL, TRUE);
                lpFType->fGline
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX51) == BST_CHECKED;
                lpFType->fSpace
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX52) == BST_CHECKED;
                lpFType->fCRLF
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX53) == BST_CHECKED;
                lpFType->fMline
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX54) == BST_CHECKED;
                lpFType->fLimit
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX55) == BST_CHECKED;
                lpFType->fCode
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX56) == BST_CHECKED;
                lpFType->fUline
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX57) == BST_CHECKED;
                lpFType->fVline
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX58) == BST_CHECKED;
                lpFType->fAutoIndent
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX59) == BST_CHECKED;
                lpFType->fTabConv
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX5A) == BST_CHECKED;
                lpFType->fEOF
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX5B) == BST_CHECKED;
                lpFType->fRecycle
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX5C) == BST_CHECKED;
                lpFType->fOverWrite
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX5D) == BST_CHECKED;
                lpFType->fSysColor
                    = IsDlgButtonChecked (hDlg, IDC_CHECKBOX5E) == BST_CHECKED;
                lpFType->uCRLF = SendDlgItemMessage (hDlg, IDC_COMBOBOX51,
                    CB_GETITEMDATA, SendDlgItemMessage (hDlg, IDC_COMBOBOX51,
                                                    CB_GETCURSEL, 0, 0), 0);
                lpFType->uCharSet = SendDlgItemMessage (hDlg, IDC_COMBOBOX52,
                    CB_GETITEMDATA, SendDlgItemMessage (hDlg, IDC_COMBOBOX52,
                                                    CB_GETCURSEL, 0, 0), 0);
                for (i = 0; i < 12; i++)
                  lpFType->crColor[i] = SendDlgItemMessage (hDlg,
                                        IDC_LISTBOX51, LB_GETITEMDATA, i, 0);
                lpFType->lf = lf;
              }
            case IDCANCEL:
              if (!EndDialog (hDlg, LOWORD (wParam)))
                MessageBox (hDlg, _T("EndDialog"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              return TRUE;
            case IDC_COMBOBOX51:
            case IDC_COMBOBOX52:
              if (HIWORD (wParam) != CBN_SELCHANGE)
                return TRUE;
              goto loop;
            case IDC_CHECKBOX5E:
              SendDlgItemMessage (hDlg, IDC_LISTBOX51, LB_SETSEL, FALSE, -1);
              /* ja:Rg[̕\ */
              if (!EnableDlgItem (hDlg, IDC_LISTBOX51,
                        IsDlgButtonChecked (hDlg, IDC_CHECKBOX5E) != BST_CHECKED)
                            || !EnableDlgItem (hDlg, IDC_PUSHBUTTON51, FALSE))
                {
                  MessageBox (hDlg, _T("EnableDlgItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  EndDialog (hDlg, IDCANCEL);
                }
              goto loop;
            case IDC_EDIT51:
            case IDC_EDIT52:
              if (HIWORD (wParam) != EN_CHANGE)
                return TRUE;
              goto loop;
            case IDC_LISTBOX51:
              if (HIWORD (wParam) != LBN_SELCHANGE)
                return TRUE;
              /* ja:Rg[̕\ */
              if (!EnableDlgItem (hDlg, IDC_PUSHBUTTON51,
                    SendDlgItemMessage (hDlg, IDC_LISTBOX51, LB_GETSELCOUNT,
                                                                    0, 0) > 0))
                {
                  MessageBox (hDlg, _T("EnableDlgItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  EndDialog (hDlg, IDCANCEL);
                }
              return TRUE;
            case IDC_PUSHBUTTON51:
              {
                int i, nItems;
                CHOOSECOLOR cc;
                HWND hWnd;
                INT list[12];
                static DWORD dwCustColors[16] = {
                                    RGB ( 64,  64,  64), RGB (  0, 128, 255),
                                    RGB (  0, 255, 128), RGB (128,   0, 255),
                                    RGB (128, 255,   0), RGB (255,   0, 128),
                                    RGB (255, 128,   0), RGB (128, 128, 255),
                                    RGB (128, 255, 128), RGB (255, 128, 128),
                                    RGB (128, 255, 255), RGB (255, 128, 255),
                                    RGB (255, 255, 128), RGB (192, 255, 255), 
                                    RGB (255, 192, 255), RGB (255, 255, 192)};

                nItems = SendDlgItemMessage (hDlg, IDC_LISTBOX51,
                                            LB_GETSELITEMS, 12, (LPARAM)list);
                cc.lStructSize = sizeof (CHOOSECOLOR);
                cc.hwndOwner = hDlg;
                cc.rgbResult = SendDlgItemMessage (hDlg, IDC_LISTBOX51,
                                                LB_GETITEMDATA, list[0], 0);
                cc.lpCustColors = dwCustColors;
                cc.Flags = CC_RGBINIT;
                if (!ChooseColor (&cc))
                  return TRUE;
                for (i = 0; i < nItems; i++)
                  SendDlgItemMessage (hDlg, IDC_LISTBOX51, LB_SETITEMDATA,
                                                        list[i], cc.rgbResult);
                hWnd = GetDlgItem (hDlg, IDC_LISTBOX51);
                if (!hWnd)
                  {
                    MessageBox (hDlg, _T("GetDlgItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
                if (!InvalidateRect (hWnd, NULL, TRUE))
                  {
                    MessageBox (hDlg, _T("InvalidateRect"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                    EndDialog (hDlg, IDCANCEL);
                    return TRUE;
                  }
              }
              goto loop;
            case IDC_PUSHBUTTON52:
              {
                CHOOSEFONT cf;

                cf.lStructSize = sizeof (CHOOSEFONT);
                cf.hwndOwner = hDlg;
                cf.lpLogFont = &lf;
                cf.Flags = CF_FORCEFONTEXIST | CF_FIXEDPITCHONLY
                                    | CF_INITTOLOGFONTSTRUCT | CF_SCREENFONTS;
                if (!ChooseFont (&cf))
                  return TRUE;
                lf.lfPitchAndFamily = (BYTE)
                                    (lf.lfPitchAndFamily & 0xfc | FIXED_PITCH);
              }
              goto loop;
            case IDC_PUSHBUTTON53:
              {
                int nPos;

                for (nPos = 0; nPos < nFileType; nPos++)
                  if (lpFileType[nPos].nID == nID)
                    break;
                if (DialogBoxParamGUI (hInst, MAKEINTRESOURCE (DIALOG_4), hDlg,
                                    AssociateDlgProc, (LPARAM)&nPos) != IDOK)
                  return TRUE;
                if (nPos >= 0)
                  {
                    /* ja:t@C^Cv */
                    int i;
                    HWND hWnd;

                    nID = lpFileType[nPos].nID;
                    lf = lpFileType[nPos].lf;
                    /* ja:X^eBbN̐ݒ */
                    if (!SetDlgItemText (hDlg, IDC_STATIC51,
                                                    lpFileType[nPos].szText))
                      {
                        MessageBox (hDlg, _T("SetDlgItemText"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        EndDialog (hDlg, IDCANCEL);
                        return TRUE;
                      }
                    /* ja:`FbN{bNX̐ݒ */
                    if (!CheckDlgButton (hDlg, IDC_CHECKBOX51,
                        lpFileType[nPos].fGline ? BST_CHECKED : BST_UNCHECKED)
                        || !CheckDlgButton (hDlg, IDC_CHECKBOX52,
                        lpFileType[nPos].fSpace ? BST_CHECKED : BST_UNCHECKED)
                        || !CheckDlgButton (hDlg, IDC_CHECKBOX53,
                        lpFileType[nPos].fCRLF ? BST_CHECKED : BST_UNCHECKED)
                        || !CheckDlgButton (hDlg, IDC_CHECKBOX54,
                        lpFileType[nPos].fMline ? BST_CHECKED : BST_UNCHECKED)
                        || !CheckDlgButton (hDlg, IDC_CHECKBOX55,
                        lpFileType[nPos].fLimit ? BST_CHECKED : BST_UNCHECKED)
                        || !CheckDlgButton (hDlg, IDC_CHECKBOX56,
                        lpFileType[nPos].fCode ? BST_CHECKED : BST_UNCHECKED)
                        || !CheckDlgButton (hDlg, IDC_CHECKBOX57,
                        lpFileType[nPos].fUline ? BST_CHECKED : BST_UNCHECKED)
                        || !CheckDlgButton (hDlg, IDC_CHECKBOX58,
                        lpFileType[nPos].fVline ? BST_CHECKED : BST_UNCHECKED)
                        || !CheckDlgButton (hDlg, IDC_CHECKBOX59,
                        lpFileType[nPos].fAutoIndent
                                                ? BST_CHECKED : BST_UNCHECKED)
                        || !CheckDlgButton (hDlg, IDC_CHECKBOX5A,
                        lpFileType[nPos].fTabConv
                                                ? BST_CHECKED : BST_UNCHECKED)
                        || !CheckDlgButton (hDlg, IDC_CHECKBOX5B,
                        lpFileType[nPos].fEOF ? BST_CHECKED : BST_UNCHECKED)
                        || !CheckDlgButton (hDlg, IDC_CHECKBOX5C,
                        lpFileType[nPos].fRecycle
                                                ? BST_CHECKED : BST_UNCHECKED)
                        || !CheckDlgButton (hDlg, IDC_CHECKBOX5D,
                        lpFileType[nPos].fOverWrite
                                                ? BST_CHECKED : BST_UNCHECKED)
                        || !CheckDlgButton (hDlg, IDC_CHECKBOX5E,
                        lpFileType[nPos].fSysColor
                                                ? BST_CHECKED : BST_UNCHECKED))
                      {
                        MessageBox (hDlg, _T("CheckDlgButton"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        EndDialog (hDlg, IDCANCEL);
                        return TRUE;
                      }
                    /* ja:R{{bNX̐ݒ */
                    for (i = SendDlgItemMessage (hDlg, IDC_COMBOBOX51,
                                        CB_GETCOUNT, 0, 0) - 1; i >= 0; i--)
                      if (SendDlgItemMessage (hDlg, IDC_COMBOBOX51,
                            CB_GETITEMDATA, i, 0) == lpFileType[nPos].uCRLF)
                        {
                          SendDlgItemMessage (hDlg, IDC_COMBOBOX51,
                                                        CB_SETCURSEL, i, 0);
                          break;
                        }
                    for (i = SendDlgItemMessage (hDlg, IDC_COMBOBOX52,
                                        CB_GETCOUNT, 0, 0) - 1; i >= 0; i--)
                      if (SendDlgItemMessage (hDlg, IDC_COMBOBOX52,
                            CB_GETITEMDATA, i, 0) == lpFileType[nPos].uCharSet)
                        {
                          SendDlgItemMessage (hDlg, IDC_COMBOBOX52,
                                                        CB_SETCURSEL, i, 0);
                          break;
                        }
                    /* ja:GfBgRg[̐ݒ */
                    if (!SetDlgItemInt (hDlg, IDC_EDIT51,
                                                lpFileType[nPos].nMargin, TRUE)
                            || !SetDlgItemInt (hDlg, IDC_EDIT52,
                                                lpFileType[nPos].nTab, TRUE))
                      {
                        MessageBox (hDlg, _T("SetDlgItemInt"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        EndDialog (hDlg, IDCANCEL);
                        return TRUE;
                      }
                    /* ja:Xg{bNX̐ݒ */
                    hWnd = GetDlgItem (hDlg, IDC_LISTBOX51);
                    if (!hWnd)
                      {
                        MessageBox (hDlg, _T("GetDlgItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        EndDialog (hDlg, IDCANCEL);
                        return TRUE;
                      }
                    if (!InvalidateRect (hWnd, NULL, TRUE))
                      {
                        MessageBox (hDlg, _T("InvalidateRect"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        EndDialog (hDlg, IDCANCEL);
                        return TRUE;
                      }
                    /* ja:Rg[̕\ */
                    if (!EnableDlgItem (hDlg, IDC_LISTBOX51,
                                                !lpFileType[nPos].fSysColor))
                      {
                        MessageBox (hDlg, _T("EnableDlgItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        EndDialog (hDlg, IDCANCEL);
                        return TRUE;
                      }
                  }
                else
                  {
                    /* ja:t@C^CvȂ */
                    nID = -1;
                    if (!SetDlgItemText (hDlg, IDC_STATIC51,
                                        LoadText (hInst, IDS_FTYPE_NOTYPE)))
                      {
                        MessageBox (hDlg, _T("SetDlgItemText"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                        EndDialog (hDlg, IDCANCEL);
                        return TRUE;
                      }
                  }
              }
            case IDC_CHECKBOX51:
            case IDC_CHECKBOX52:
            case IDC_CHECKBOX53:
            case IDC_CHECKBOX54:
            case IDC_CHECKBOX55:
            case IDC_CHECKBOX56:
            case IDC_CHECKBOX57:
            case IDC_CHECKBOX58:
            case IDC_CHECKBOX59:
            case IDC_CHECKBOX5A:
            case IDC_CHECKBOX5B:
            case IDC_CHECKBOX5C:
            case IDC_CHECKBOX5D:
            loop:
              /* ja:Rg[̕\ */
              if (!EnableDlgItem (hDlg, IDOK,
                        GetDlgItemInt (hDlg, IDC_EDIT51, NULL, TRUE) > 0
                        && GetDlgItemInt (hDlg, IDC_EDIT52, NULL, TRUE) > 0))
                {
                  MessageBox (hDlg, _T("EnableDlgItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  EndDialog (hDlg, IDCANCEL);
                }
          }
        return TRUE;
    }
  return FALSE;
}


BOOL CALLBACK
PropDlgProc (HWND   hDlg,
             UINT   uMsg,
             WPARAM wParam,
             LPARAM lParam)
{

  if (uMsg == WM_INITDIALOG)
    {
      LPFILETYPE lpFType;
      LPTSTR lpszText;

      lpFType = (LPFILETYPE)lParam;
      /* ja:X^eBbN̐ݒ */
      if (lpFType->nID >= 0)
        {
          /* ja:t@C^Cv */
          int i;

          for (i = 0; i < nFileType; i++)
            if (lpFType->nID == lpFileType[i].nID)
              {
                lpszText = lpFileType[i].szText;
                break;
              }
          if (i >= nFileType)
            lpszText = LoadText (hInst, IDS_FTYPE_UNKNOW);
        }
      else
        {
          /* ja:t@C^CvȂ */
          lpszText = LoadText (hInst, IDS_FTYPE_NOTYPE);
        }
      if (!SetDlgItemText (hDlg, IDC_STATIC51, lpszText))
        {
          MessageBox (hDlg, _T("SetDlgItemText"),
                            APPLICATION, MB_OK | MB_ICONEXCLAMATION);
          EndDialog (hDlg, IDCANCEL);
          return TRUE;
        }
    }
  return PropertyDlgProc (hDlg, uMsg, wParam, lParam);
}
