/*
    Text maid for Windows
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "edit.h"
#include "memapi.h"


/******************************************************************************
*                                                                             *
* ja:ҏW֐Q                                                               *
*                                                                             *
******************************************************************************/
/*  ja:Cobt@߂
    lpStart,Cobt@
     lpnOff,݂yW
          y,yW
        RET,Cobt@                                                  */
LPLINEBUF
GetLineBuffer (LINEBUF **lpStart,
               int      *lpnOff,
               int       y)
{
  while (y < *lpnOff && (*lpStart)->prev)
    {
      *lpStart = (*lpStart)->prev;
      (*lpnOff)--;
    }
  while (*lpnOff < y && (*lpStart)->next)
    {
      *lpStart = (*lpStart)->next;
      (*lpnOff)++;
    }
  return *lpStart;
}


/*  ja:擾
    lpStart,Cobt@
     lpnOff,݂yW
          y,s
       nTab,^u
        RET,                                                            */
int
GetWidth (LINEBUF **lpStart,
          int      *lpnOff,
          int       y,
          int       nTab)
{
  int nDataPos = 0, nWidth = 0;
  LPLINEBUF p;

  p = GetLineBuffer (lpStart, lpnOff, y);
  if (p->fMargin)
    while (nDataPos < p->nLength - 1)
      if (p->lpszText[nDataPos] == '\t')
        {
          nWidth = (nWidth / nTab + 1) * nTab;
          nDataPos++;
        }
      else if (IsDBCSLeadByteEx (CP_SJIS, p->lpszText[nDataPos]))
        {
          if (nDataPos == p->nLength - 2)
            break;
          nWidth += 2;
          nDataPos += 2;
        }
      else
        {
          nWidth++;
          nDataPos++;
        }
  else
    while (nDataPos < p->nLength)
      if (p->lpszText[nDataPos] == '\t')
        {
          nWidth = (nWidth / nTab + 1) * nTab;
          nDataPos++;
        }
      else if (nDataPos == p->nLength - 1
                        || !IsDBCSLeadByteEx (CP_SJIS, p->lpszText[nDataPos]))
        {
          nWidth++;
          nDataPos++;
        }
      else
        {
          nWidth += 2;
          nDataPos += 2;
        }
  return nWidth;
}


/*  ja:ő包擾
    ptw,TXTEChE
    RET,                                                                */
int
GetWidthMax (LPTEXTWND ptw)
{
  int y, nMax = 0;
  LPLINEBUF p;

  for (y = 0, p = GetLineBuffer (&ptw->lpStart, &ptw->nOff, ptw->ptTop.y);
                y < ptw->siWnd.cy && p; y += ptw->nFontSize * 2, p = p->next)
    {
      int nDataPos, nWidth;

      nWidth = 0;
      for (nDataPos = 0; nDataPos < p->nLength; nDataPos++)
        if (p->lpszText[nDataPos] == '\t')
          nWidth = (nWidth / ptw->nTab + 1) * ptw->nTab;
        else
          nWidth++;
      if (nWidth > nMax)
        nMax = nWidth;
    }
  return nMax;
}


/*  ja:Lbg̃ACgꂽxW߂
    lpStart,Cobt@
     lpnOff,݂yW
          x,xW
          y,yW
       nTab,^u
     fAlign,TRUE:EɊ񂹂,FALSE:Ɋ񂹂
        RET,W                                                            */
int
GetAlignPos (LINEBUF **lpStart,
             int      *lpnOff,
             int       x,
             int       y,
             int       nTab,
             BOOL      fAlign)
{
  int nDataPos = 0, nScreenPos = 0;
  LPLINEBUF p;

  p = GetLineBuffer (lpStart, lpnOff, y);
  if (p->fMargin)
    while (nScreenPos < x && nDataPos < p->nLength - 1)
      if (p->lpszText[nDataPos] == '\t')
        {
          if (x < (nScreenPos / nTab + 1) * nTab)
            return fAlign ? (nScreenPos / nTab + 1) * nTab : nScreenPos;
          nScreenPos = (nScreenPos / nTab + 1) * nTab;
          nDataPos++;
        }
      else if (nDataPos == p->nLength - 1
                        || !IsDBCSLeadByteEx (CP_SJIS, p->lpszText[nDataPos]))
        {
          nScreenPos++;
          nDataPos++;
        }
      else if (nDataPos == p->nLength - 2)
        {
          break;
        }
      else if (x < nScreenPos + 2)
        {
          return fAlign ? nScreenPos + 2 : nScreenPos;
        }
      else
        {
          nScreenPos += 2;
          nDataPos += 2;
        }
  else
    while (nScreenPos < x && nDataPos < p->nLength)
      if (p->lpszText[nDataPos] == '\t')
        {
          if (x < (nScreenPos / nTab + 1) * nTab)
            return fAlign ? (nScreenPos / nTab + 1) * nTab : nScreenPos;
          nScreenPos = (nScreenPos / nTab + 1) * nTab;
          nDataPos++;
        }
      else if (nDataPos == p->nLength - 1
                        || !IsDBCSLeadByteEx (CP_SJIS, p->lpszText[nDataPos]))
        {
          nScreenPos++;
          nDataPos++;
        }
      else if (x < nScreenPos + 2)
        {
          return fAlign ? nScreenPos + 2 : nScreenPos;
        }
      else
        {
          nScreenPos += 2;
          nDataPos += 2;
        }
  return nScreenPos;
}


/*  ja:ʏ̍W烉Cobt@̃AhX߂
    lpStart,Cobt@
     lpnOff,݂yW
          x,xW
          y,yW
       nTab,^u
     fAlign,TRUE:EɊ񂹂,FALSE:Ɋ񂹂
        RET,AhX                                                        */
int
GetDataPos (LINEBUF **lpStart,
            int      *lpnOff,
            int       x,
            int       y,
            int       nTab,
            BOOL      fAlign)
{
  int nDataPos = 0, nScreenPos = 0;
  LPLINEBUF p;

  p = GetLineBuffer (lpStart, lpnOff, y);
  while (nScreenPos < x && nDataPos < p->nLength)
    if (p->lpszText[nDataPos] == '\t')
      {
        nScreenPos = (nScreenPos / nTab + 1) * nTab;
        if (x < nScreenPos)
          return fAlign ? nDataPos + 1 : nDataPos;
        nDataPos++;
      }
    else if (nDataPos == p->nLength - 1
                        || !IsDBCSLeadByteEx (CP_SJIS, p->lpszText[nDataPos]))
      {
        nScreenPos++;
        nDataPos++;
      }
    else if (x < nScreenPos + 2)
      {
        return fAlign ? nDataPos + 2 : nDataPos;
      }
    else
      {
        nScreenPos += 2;
        nDataPos += 2;
      }
  return min (nDataPos, p->nLength);
}


/*  ja:Cobt@̃AhXʏ̍W߂
    lpStart,Cobt@
     lpnOff,݂yW
          x,xW
          y,yW
       nTab,^u
        RET,W                                                            */
int
GetScreenPos (LINEBUF **lpStart,
              int      *lpnOff,
              int       x,
              int       y,
              int       nTab)
{
  int nDataPos, nScreenPos = 0;
  LPLINEBUF p;

  p = GetLineBuffer (lpStart, lpnOff, y);
  for (nDataPos = 0; nDataPos < x; nDataPos++)
    if (p->lpszText[nDataPos] == '\t')
      nScreenPos = (nScreenPos / nTab + 1) * nTab;
    else
      nScreenPos++;
  return nScreenPos;
}


/*  ja:̕
    lpszText,
     nLength,
         RET,                                                           */
DWORD
GetCharType (LPCSTR lpszText,
             int    nLength)
{
  WORD ct1, ct3;

  if (!GetStringTypeExA (LOCALE_USER_DEFAULT,
                                        CT_CTYPE1, lpszText, nLength, &ct1)
        || !GetStringTypeExA (LOCALE_USER_DEFAULT,
                                        CT_CTYPE3, lpszText, nLength, &ct3))
    return -1;
  switch (nLength)
    {
      case 2:
        if (ct3 & C3_KASHIDA)
          return 512;
        if (ct3 & C3_IDEOGRAPH)
          return 256;
        if ((ct3 & (C3_KATAKANA | C3_HIRAGANA)) == (C3_KATAKANA | C3_HIRAGANA))
          return 192;
        if (ct3 & C3_KATAKANA)
          return 128;
        if (ct3 & C3_HIRAGANA)
          return 64;
        if (ct1 & C1_DIGIT)
          return 32;
        if (ct1 & C1_ALPHA)
          return 16;
        if (ct1 & C1_SPACE)
          return 8;
        break;
      case 1:
        if (ct3 & C3_KATAKANA)
          return 4;
        if (ct1 & C1_DIGIT)
          return 2;
        if (ct1 & C1_ALPHA)
          return 1;
    }
  return 0;
}


/*  ja:؂߂
    lpStart,Cobt@
     lpnOff,݂yW
          x,xW
          y,yW
       nTab,^u
      fMove,TRUE:EɈړ,FALSE:Ɉړ
        RET,W                                                            */
int
GetMovePos (LINEBUF **lpStart,
            int      *lpnOff,
            int       x,
            int       y,
            int       nTab,
            int       fMove)
{
  int nDataPos;
  LPLINEBUF p;

  p = GetLineBuffer (lpStart, lpnOff, y);
  if (fMove)
    {
      int ctype, nLength;

      /* ja:Eֈړ */
      nDataPos = GetDataPos (lpStart, lpnOff, x, y, nTab, FALSE);
      nLength = nDataPos < p->nLength - 1
                && IsDBCSLeadByteEx (CP_SJIS, p->lpszText[nDataPos]) ? 2 : 1;
      ctype = GetCharType (p->lpszText + nDataPos, nLength);
      if (ctype == -1)
        return GetScreenPos (lpStart, lpnOff, p->nLength, y, nTab);
      nDataPos += nLength;
      while (nDataPos < p->nLength)
        {
          int ct;

          nLength = nDataPos < p->nLength - 1
                && IsDBCSLeadByteEx (CP_SJIS, p->lpszText[nDataPos]) ? 2 : 1;
          ct = GetCharType (p->lpszText + nDataPos, nLength);
          if (ct == -1)
            return GetScreenPos (lpStart, lpnOff, p->nLength, y, nTab);
          if (!(ctype & ct & 192) && ctype != ct)
            {
              if (ct != 0)
                break;
              ctype = 0;
            }
          nDataPos += nLength;
        }
    }
  else
    {
      int i = 0, ct, ctype, nLength;
      LPBYTE lpbType; /* ja:0:1oCg,1:1oCg,2oCg */

      /* ja:ֈړ */
      nDataPos = GetDataPos (lpStart, lpnOff, x, y, nTab, FALSE);
      lpbType = MemoryAlloc (nDataPos * sizeof (BYTE));
      while (i < nDataPos)
        if (i + 1 < nDataPos && IsDBCSLeadByteEx (CP_SJIS, p->lpszText[i]))
          {
            lpbType[i++] = 1;
            lpbType[i++] = 2;
          }
        else
          {
            lpbType[i++] = 0;
          }
      nLength = lpbType[nDataPos - 1] == 2 ? 2 : 1;
      nDataPos -= nLength;
      ctype = GetCharType (p->lpszText + nDataPos, nLength);
      if (ctype == -1)
        {
          MemoryFree (lpbType);
          return 0;
        }
      while (--nDataPos >= 0)
        {
          int ct;

          if (lpbType[nDataPos] >= 2)
            continue;
          nLength = lpbType[nDataPos] == 1 ? 2 : 1;
          ct = GetCharType (p->lpszText + nDataPos, nLength);
          if (ct == -1)
            {
              MemoryFree (lpbType);
              return 0;
            }
          if (!(ctype & ct & 192) && ctype != ct)
            {
              if (ctype != 0)
                {
                  nDataPos += nLength;
                  break;
                }
              ctype = ct;
            }
        }
      MemoryFree (lpbType);
    }
  return GetScreenPos (lpStart, lpnOff, nDataPos, y, nTab);
}


/*  ja:w͈͂̃oCg߂
      lpStart,Cobt@
       lpnOff,݂yW
    lpptStart,I͈
      lpptEnd,I͈
         nTab,^u
          RET,oCg                                                      */
int
GetSelByte (LINEBUF **lpStart,
            int      *lpnOff,
            LPPOINT   lpptStart,
            LPPOINT   lpptEnd,
            int       nTab)
{
  int nStart, nEnd, nLength;
  LPLINEBUF p;
  POINT ptStart, ptEnd;

  if (lpptStart->y < lpptEnd->y
                    || lpptStart->y == lpptEnd->y && lpptStart->x < lpptEnd->x)
    {
      ptStart = *lpptStart;
      ptEnd = *lpptEnd;
    }
  else
    {
      ptStart = *lpptEnd;
      ptEnd = *lpptStart;
    }
  nStart = GetDataPos (lpStart, lpnOff, ptStart.x, ptStart.y, nTab, FALSE);
  nEnd = GetDataPos (lpStart, lpnOff, ptEnd.x, ptEnd.y, nTab, FALSE);
  if (ptStart.y == ptEnd.y)
    {
      /* ja:s */
      nLength = nEnd - nStart;
    }
  else
    {
      /* ja:Ⴄs */
      int i;

      p = GetLineBuffer (lpStart, lpnOff, ptStart.y);
      nLength = p->nLength - nStart + nEnd + (p->fMargin ? 0 : 2);
      for (i = ptStart.y + 1, p = p->next; i < ptEnd.y && p; i++, p = p->next)
        nLength += p->nLength + (p->fMargin ? 0 : 2);
    }
  return nLength;
}


/*  ja:w͈͂ɃRs[
     lpStart,Cobt@
      lpnOff,݂yW
    pptStart,I͈
     lpptEnd,I͈
        nTab,^u
    lpszText,                                                         */
void
CpySelMem (LINEBUF **lpStart,
           int      *lpnOff,
           LPPOINT   lpptStart,
           LPPOINT   lpptEnd,
           int       nTab,
           LPSTR     lpszText)
{
  int nStart, nEnd;
  LPLINEBUF p;
  POINT ptStart, ptEnd;

  if (lpptStart->y < lpptEnd->y
                    || lpptStart->y == lpptEnd->y && lpptStart->x < lpptEnd->x)
    {
      ptStart = *lpptStart;
      ptEnd = *lpptEnd;
    }
  else
    {
      ptStart = *lpptEnd;
      ptEnd = *lpptStart;
    }
  nStart = GetDataPos (lpStart, lpnOff, ptStart.x, ptStart.y, nTab, FALSE);
  nEnd = GetDataPos (lpStart, lpnOff, ptEnd.x, ptEnd.y, nTab, FALSE);
  p = GetLineBuffer (lpStart, lpnOff, ptStart.y);
  if (ptStart.y == ptEnd.y)
    {
      /* ja:s */
      MemoryCopy (lpszText, p->lpszText + nStart,
                                            (nEnd - nStart) * sizeof (CHAR));
    }
  else
    {
      /* ja:Ⴄs */
      int i, nLength;

      nLength = p->nLength - nStart;
      MemoryCopy (lpszText, p->lpszText + nStart, nLength * sizeof (CHAR));
      if (!p->fMargin)
        {
          MemoryCopy (lpszText + nLength, cCRLF, sizeof (CHAR) * 2);
          nLength += 2;
        }
      for (i = ptStart.y + 1, p = p->next; i < ptEnd.y && p; i++, p = p->next)
        {
          MemoryCopy (lpszText + nLength, p->lpszText,
                                                p->nLength * sizeof (CHAR));
          nLength += p->nLength;
          if (!p->fMargin)
            {
              /* ja:s */
              MemoryCopy (lpszText + nLength, cCRLF, sizeof (CHAR) * 2);
              nLength += 2;
            }
        }
      MemoryCopy (lpszText + nLength, p->lpszText, nEnd * sizeof (CHAR));
    }
}


/*  ja:f[^擾
     lpStart,Cobt@
      lpnOff,݂yW
     lpptGet,擾͂߂f[^W
    lpszText,
     nLength,oCg
         RET,擾łoCg                                             */
int
GetMem (LINEBUF **lpStart,
        int      *lpnOff,
        LPPOINT   lpptGet,
        LPSTR     lpszText,
        int       nLength)
{
  int nMove, nSize, nOff;
  LPLINEBUF p;

  p = GetLineBuffer (lpStart, lpnOff, lpptGet->y);
  nOff = *lpnOff;
  nSize = nLength;
  /* ja:ŏ̍s */
  nMove = min (max (p->nLength - lpptGet->x, 0), nSize);
  MemoryCopy (lpszText, p->lpszText + lpptGet->x, nMove * sizeof (CHAR));
  nSize -= nMove;
  lpszText += nMove;
  if (!p->fMargin)
    {
      /* ja:s */
      nMove = min (nSize, 2);
      MemoryCopy (lpszText + nLength, cCRLF, nMove * sizeof (CHAR));
      nSize -= nMove;
      lpszText += nMove;
    }
  p = p->next;
  while (nSize > 0 && p)
    {
      /* ja:2sڈȍ~ */
      nMove = min (p->nLength, nSize);
      MemoryCopy (lpszText, p->lpszText, nMove * sizeof (CHAR));
      nSize -= nMove;
      lpszText += nMove;
      if (!p->fMargin)
        {
          /* ja:s */
          nMove = min (nSize, 2);
          MemoryCopy (lpszText + nLength, cCRLF, nMove * sizeof (CHAR));
          nSize -= nMove;
          lpszText += nMove;
        }
      p = p->next;
    }
  return nLength - nSize;
}


/*  ja:̓e\t
     lpStart,Cobt@
      lpnOff,݂yW
     lpptPut,\tW
     lpptNew,VW
        nTab,^u
    lpszText,
     nLength,oCg
     nMargin,E}[W(0Ȃΐ܂ԂȂ)
         RET,}ꂽs                                                 */
int
PutMem (LINEBUF **lpStart,
        int      *lpnOff,
        LPPOINT   lpptPut,
        LPPOINT   lpptNew,
        int       nTab,
        LPSTR     lpszText,
        int       nLength,
        int       nMargin)
{
  int nTemp, nInsert = 0, nDataPos;
  LPLINEBUF p;
  LPSTR lpszTemp;

  nDataPos = GetDataPos (lpStart, lpnOff, lpptPut->x, lpptPut->y, nTab, FALSE);
  p = GetLineBuffer (lpStart, lpnOff, lpptPut->y);
  if (nDataPos <= 0 && p->prev && p->prev->fMargin && nLength >= 2
                    && MemoryCompare (lpszText, cCRLF, sizeof (CHAR) * 2) == 0)
    {
      /* ja:sւ̑}őO̍s܂ԂĂA}镶ŝƂ */
      p = p->prev;
      lpptPut->x = 0;
      for (nDataPos = 0; nDataPos < p->nLength; nDataPos++)
        if (p->lpszText[nDataPos] == '\t')
          lpptPut->x = (lpptPut->x / nTab + 1) * nTab;
        else
          lpptPut->x++;
      lpptPut->y--;
      /* ja:O̍s̉E[ֈړ */
    }
  if (nDataPos < p->nLength)
    {
      /* ja:}ʒuȍ~̕obt@ɕۑ */
      nTemp = p->nLength - nDataPos;
      lpszTemp = MemoryAlloc (nTemp + sizeof (CHAR));
      MemoryCopy (lpszTemp, p->lpszText + nDataPos, nTemp * sizeof (CHAR));
      p->nLength = nDataPos;
    }
  else
    {
      lpszTemp = NULL;
    }
  if (nMargin > 0)
    {
      /* ja:E}[WŐ܂Ԃ */
      int i = 0, nScreenPos = 0;

      for (nDataPos = 0; nDataPos < p->nLength; nDataPos++)
        if (p->lpszText[nDataPos] == '\t')
          nScreenPos = (nScreenPos / nTab + 1) * nTab;
        else
          nScreenPos++;
      while (i < nLength)
        {
          nDataPos = i;
          while (nDataPos < nLength && (lpszText[nDataPos] != cCRLF[0]
                                        || lpszText[nDataPos + 1] != cCRLF[1]))
            if (lpszText[nDataPos] == '\t')
              {
                nScreenPos = (nScreenPos / nTab + 1) * nTab;
                if (nMargin < nScreenPos)
                  break;
                nDataPos++;
              }
            else if (nDataPos == nLength - 1
                            || !IsDBCSLeadByteEx (CP_SJIS, lpszText[nDataPos]))
              {
                nScreenPos++;
                if (nMargin < nScreenPos)
                  break;
                nDataPos++;
              }
            else
              {
                nScreenPos += 2;
                if (nMargin < nScreenPos)
                  break;
                nDataPos += 2;
              }
          p->lpszText = MemoryReAlloc (p->lpszText,
                                (p->nLength + nDataPos - i) * sizeof (CHAR));
          MemoryCopy (p->lpszText + p->nLength, lpszText + i,
                                            (nDataPos - i) * sizeof (CHAR));
          p->nLength += nDataPos - i;
          if (nLength <= nDataPos)
            {
              i = nDataPos;
            }
          else
            {
              LPLINEBUF q;

              q = MemoryAlloc (sizeof (LINEBUF));
              q->nLength = 0;
              q->fMargin = p->fMargin;
              q->lpszText = NULL;
              q->prev = p;
              q->next = p->next;
              p->next = q;
              if (q->next)
                q->next->prev = q;
              if (nDataPos <= nLength - 2 && lpszText[nDataPos] == cCRLF[0]
                                        && lpszText[nDataPos + 1] == cCRLF[1])
                {
                  /* ja:s */
                  i = nDataPos + 2;
                  p->fMargin = FALSE;
                }
              else
                {
                  /* ja:[s */
                  i = nDataPos;
                  p->fMargin = TRUE;
                }
              p = q;
              nScreenPos = 0;
              nInsert++;
            }
        }
    }
  else
    {
      /* ja:E}[WŐ܂ԂȂ */
      int i = 0;

      while (i < nLength)
        {
          for (nDataPos = i;
                        nDataPos < nLength && (lpszText[nDataPos] != cCRLF[0]
                        || lpszText[nDataPos + 1] != cCRLF[1]); nDataPos++);
          p->lpszText = MemoryReAlloc (p->lpszText,
                                (p->nLength + nDataPos - i) * sizeof (CHAR));
          MemoryCopy (p->lpszText + p->nLength, lpszText + i,
                                            (nDataPos - i) * sizeof (CHAR));
          p->nLength += nDataPos - i;
          if (nLength <= nDataPos)
            {
              i = nDataPos;
            }
          else
            {
              LPLINEBUF q;

              i = nDataPos + 2;
              q = MemoryAlloc (sizeof (LINEBUF));
              q->nLength = 0;
              q->fMargin = FALSE;
              q->lpszText = NULL;
              q->prev = p;
              q->next = p->next;
              p->next = q;
              if (q->next)
                q->next->prev = q;
              p = q;
              nInsert++;
            }
        }
    }
  if (lpptNew)
    {
      lpptNew->x = 0;
      for (nDataPos = 0; nDataPos < p->nLength; nDataPos++)
        if (p->lpszText[nDataPos] == '\t')
          lpptNew->x = (lpptNew->x / nTab + 1) * nTab;
        else
          lpptNew->x++;
      lpptNew->y = lpptPut->y + nInsert;
      if (nMargin > 0 && p->fMargin && (nMargin <= lpptNew->x
                                || lpszTemp && nMargin - 1 <= lpptNew->x
                                && IsDBCSLeadByteEx (CP_SJIS, lpszTemp[0])))
        {
          lpptNew->x = 0;
          lpptNew->y++;
        }
    }
  if (lpszTemp)
    {
      /* ja:}ʒuȍ~̕߂ */
      p->lpszText = MemoryReAlloc (p->lpszText, p->nLength + nTemp);
      MemoryCopy (p->lpszText + p->nLength, lpszTemp, nTemp * sizeof (CHAR));
      p->nLength += nTemp;
      MemoryFree (lpszTemp);
    }
  if (nMargin > 0)
    /* ja:E}[WŐ܂Ԃ */
    while (p)
      {
        int nScreenPos = 0;

        nDataPos = 0;
        while (nDataPos < p->nLength)
          if (p->lpszText[nDataPos] == '\t')
            {
              nScreenPos = (nScreenPos / nTab + 1) * nTab;
              if (nMargin < nScreenPos)
                break;
              nDataPos++;
            }
          else if (nDataPos == p->nLength - 1
                        || !IsDBCSLeadByteEx (CP_SJIS, p->lpszText[nDataPos]))
            {
              nScreenPos++;
              if (nMargin < nScreenPos)
                break;
              nDataPos++;
            }
          else
            {
              nScreenPos += 2;
              if (nMargin < nScreenPos)
                break;
              nDataPos += 2;
            }
        if (nMargin < nScreenPos)
          {
            /* ja:E}[W𒴂ĂƂA[s */
            LPLINEBUF q;

            q = MemoryAlloc (sizeof (LINEBUF));
            q->nLength = p->nLength - nDataPos;
            q->fMargin = p->fMargin;
            q->lpszText = MemoryAlloc (q->nLength * sizeof (CHAR));
            q->prev = p;
            q->next = p->next;
            p->next = q;
            if (q->next)
              q->next->prev = q;
            MemoryCopy (q->lpszText, p->lpszText + nDataPos,
                                                q->nLength * sizeof (CHAR));
            p->nLength = nDataPos;
            p->fMargin = TRUE;
            p->lpszText = MemoryReAlloc (p->lpszText,
                                                p->nLength * sizeof (CHAR));
            p = q;
            nInsert++;
          }
        else if (nScreenPos < nMargin && p->fMargin && p->next)
          {
            /* ja:E}[W[ŝƂA̍sƂ킹 */
            LPLINEBUF q;

            nDataPos = p->nLength;
            q = p->next;
            if (q->next)
              q->next->prev = p;
            p->next = q->next;
            p->nLength += q->nLength;
            p->fMargin = q->fMargin;
            p->lpszText = MemoryReAlloc (p->lpszText,
                                                p->nLength * sizeof (CHAR));
            MemoryCopy (p->lpszText + nDataPos, q->lpszText,
                                                q->nLength * sizeof (CHAR));
            MemoryFree (q->lpszText);
            MemoryFree (q);
            nInsert--;
          }
        else
          {
            break;
          }
      }
  return nInsert;
}


/*  w͈͂폜
      lpStart,Cobt@
       lpnOff,݂yW
    lpptStart,I͈
      lpptEnd,I͈
         nTab,^u
     nMargin,E}[W(0Ȃΐ܂ԂȂ)
          RET,폜ꂽs                                                */
int
DelSelMem (LINEBUF **lpStart,
           int      *lpnOff,
           LPPOINT   lpptStart,
           LPPOINT   lpptEnd,
           int       nTab,
           int       nMargin)
{
  int i, nStart, nEnd, nDelete;
  LPLINEBUF p, q;
  POINT ptStart, ptEnd;

  if (lpptStart->y < lpptEnd->y
                    || lpptStart->y == lpptEnd->y && lpptStart->x < lpptEnd->x)
    {
      ptStart = *lpptStart;
      ptEnd = *lpptEnd;
    }
  else
    {
      ptStart = *lpptEnd;
      ptEnd = *lpptStart;
    }
  nStart = GetDataPos (lpStart, lpnOff, ptStart.x, ptStart.y, nTab, FALSE);
  nEnd = GetDataPos (lpStart, lpnOff, ptEnd.x, ptEnd.y, nTab, FALSE);
  p = GetLineBuffer (lpStart, lpnOff, ptStart.y);
  if (ptStart.y == ptEnd.y)
    {
      /* ja:s */
      MemoryCopy (p->lpszText + nStart, p->lpszText + nEnd,
                                        (p->nLength - nEnd) * sizeof (CHAR));
      p->nLength -= nEnd - nStart;
      p->lpszText = MemoryReAlloc (p->lpszText, p->nLength);
      nDelete = 0;
    }
  else
    {
      /* ja:Ⴄs */
      LPLINEBUF r;

      for (i = ptStart.y + 1, q = p->next; i < ptEnd.y && q; i++, q = r)
        {
          MemoryFree (q->lpszText);
          r = q->next;
          MemoryFree (q);
        }
      if (q->next)
        q->next->prev = p;
      p->next = q->next;
      p->nLength = nStart + q->nLength - nEnd;
      p->fMargin = q->fMargin;
      p->lpszText = MemoryReAlloc (p->lpszText, p->nLength);
      MemoryCopy (p->lpszText + nStart, q->lpszText + nEnd,
                                        (q->nLength - nEnd) * sizeof (CHAR));
      MemoryFree (q->lpszText);
      MemoryFree (q);
      nDelete = ptEnd.y - ptStart.y;
    }
  q = p->prev;
  if (q && q->fMargin && ptStart.x <= 0)
    {
      /* ja:O̍s[sō폜JnŝƂ */
      int nScreenPos;

      if (p->nLength > 0)
        {
          int nDataPos = 0;

          while (nDataPos < q->nLength)
            if (q->lpszText[nDataPos] == '\t')
              {
                nScreenPos = (nScreenPos / nTab + 1) * nTab;
                nDataPos++;
              }
            else if (IsDBCSLeadByteEx (CP_SJIS, q->lpszText[nDataPos]))
              {
                nScreenPos += 2;
                nDataPos += 2;
              }
            else
              {
                nScreenPos++;
                nDataPos++;
              }
          if (p->lpszText[0] == '\t')
            nScreenPos = (nScreenPos / nTab + 1) * nTab;
          else if (IsDBCSLeadByteEx (CP_SJIS, p->lpszText[0]))
            nScreenPos += 2;
          else
            nScreenPos++;
        }
      if (p->nLength <= 0 || nScreenPos <= nMargin)
        {
          /* ja:E}[W[ŝƂA̍sƂ킹 */
          int nDataPos;

          nDataPos = q->nLength;
          if (p->next)
            p->next->prev = q;
          q->next = p->next;
          q->nLength += p->nLength;
          q->fMargin = p->fMargin;
          q->lpszText = MemoryReAlloc (q->lpszText,
                                                q->nLength * sizeof (CHAR));
          MemoryCopy (q->lpszText + nDataPos, p->lpszText,
                                                p->nLength * sizeof (CHAR));
          MemoryFree (p->lpszText);
          MemoryFree (p);
          nDelete++;
          p = q;
          if (lpptStart->y < lpptEnd->y
                    || lpptStart->y == lpptEnd->y && lpptStart->x < lpptEnd->x)
            {
              lpptStart->x = nScreenPos;
              lpptStart->y--;
            }
          else
            {
              lpptEnd->x = nScreenPos;
              lpptEnd->y--;
            }
        }
    }
  if (nMargin > 0)
    /* ja:E}[WŐ܂Ԃ */
    while (p)
      {
        int nDataPos = 0, nScreenPos = 0;

        while (nDataPos < p->nLength)
          if (p->lpszText[nDataPos] == '\t')
            {
              nScreenPos = (nScreenPos / nTab + 1) * nTab;
              if (nMargin < nScreenPos)
                break;
              nDataPos++;
            }
          else if (nDataPos == p->nLength - 1
                        || !IsDBCSLeadByteEx (CP_SJIS, p->lpszText[nDataPos]))
            {
              nScreenPos++;
              if (nMargin < nScreenPos)
                break;
              nDataPos++;
            }
          else
            {
              nScreenPos += 2;
              if (nMargin < nScreenPos)
                break;
              nDataPos += 2;
            }
        if (nMargin < nScreenPos)
          {
            /* ja:E}[W𒴂ĂƂA[s */
            q = MemoryAlloc (sizeof (LINEBUF));
            q->nLength = p->nLength - nDataPos;
            q->fMargin = p->fMargin;
            q->lpszText = MemoryAlloc (q->nLength * sizeof (CHAR));
            q->prev = p;
            q->next = p->next;
            p->next = q;
            if (q->next)
              q->next->prev = q;
            MemoryCopy (q->lpszText, p->lpszText + nDataPos,
                                                q->nLength * sizeof (CHAR));
            p->nLength = nDataPos;
            p->fMargin = TRUE;
            p->lpszText = MemoryReAlloc (p->lpszText,
                                                p->nLength * sizeof (CHAR));
            p = q;
            nDelete--;
          }
        else if (nScreenPos < nMargin && p->fMargin && p->next)
          {
            /* ja:E}[W[ŝƂA̍sƂ킹 */
            nDataPos = p->nLength;
            q = p->next;
            if (q->next)
              q->next->prev = p;
            p->next = q->next;
            p->nLength += q->nLength;
            p->fMargin = q->fMargin;
            p->lpszText = MemoryReAlloc (p->lpszText,
                                                p->nLength * sizeof (CHAR));
            MemoryCopy (p->lpszText + nDataPos, q->lpszText,
                                                q->nLength * sizeof (CHAR));
            MemoryFree (q->lpszText);
            MemoryFree (q);
            nDelete++;
          }
        else if (!p->fMargin)
          {
            break;
          }
        else
          {
            p = p->next;
          }
      }
  return nDelete;
}
