/*
    Text maid for Windows
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "abort.h"
#include "resource.h"


BOOL fUserBreak;                /* ja:TRUE:p,FALSE:fv */


/******************************************************************************
*                                                                             *
* ja:f֐Q                                                               *
*                                                                             *
******************************************************************************/
BOOL CALLBACK
AbortDlgProc (HWND   hDlg,
              UINT   uMsg,
              WPARAM wParam,
              LPARAM lParam)
{
  switch (uMsg)
    {
      case WM_INITDIALOG:
        {
          RECT rc;

          if (!GetWindowRect (hDlg, &rc))
            {
              MessageBox (hDlg, _T("GetWindowRect"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          if (!SetWindowPos (hDlg, 0,
                    (GetSystemMetrics (SM_CXSCREEN) - rc.right + rc.left) / 2,
                    (GetSystemMetrics (SM_CYSCREEN) - rc.bottom  +rc.top) / 2,
                                            0, 0, SWP_NOSIZE | SWP_NOZORDER))
            {
              MessageBox (hDlg, _T("SetWindowPos"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          if (!SetDlgItemText (hDlg, IDC_STATICG1, (LPCTSTR)lParam))
            {
              MessageBox (hDlg, _T("SetDlgItemText"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
            }
        }
        return TRUE;
      case WM_COMMAND:
        if (LOWORD (wParam) == IDCANCEL)
            fUserBreak = FALSE;
        return TRUE;
    }
  return FALSE;
}
