package pantheon.web;

import static org.hamcrest.core.IsEqual.equalTo;
import static org.junit.Assert.assertThat;

import org.apache.commons.lang.StringUtils;
import org.junit.Test;

import pantheon.model.User;

public class UpdateLoginUserValidatorTest extends AbstractValidatorTest<LoginUserCommand> {

	public UpdateLoginUserValidatorTest() {
		super(LoginUserCommand.class, UpdateLoginUserValidator.class);
	}

	private void setSuccessData() {
		command.setName(StringUtils.repeat("全", User.NAME_LENGTH));
		// command.setPassword(StringUtils.repeat("a", User.PASSWORD_LENGTH));
		command.setNote(StringUtils.repeat("全", User.NOTE_LENGTH));
	}

	@Test
	public void testSuccess() throws Exception {

		// テスト準備
		setSuccessData();

		// 実行
		validator.validate(command, exception);

		// 検証
		assertThat(0, equalTo(exception.getErrorCount()));
	}

	@Test
	public void testBlankError() throws Exception {

		// テスト準備
		// 今回は空データ

		// 実行
		validator.validate(command, exception);

		// 検証
		assertThat(1, equalTo(exception.getErrorCount()));
		assertThat(ValidatorError.ERROR_BLANK.name(), equalTo(exception.getFieldError("name").getCode()));
	}

	@Test
	public void testOverLength() throws Exception {

		// テスト準備
		setSuccessData();
		command.setName(command.getName() + "1");
		command.setNote(command.getNote() + "1");

		// 実行
		validator.validate(command, exception);

		// 検証
		assertThat(2, equalTo(exception.getErrorCount()));
		assertThat(ValidatorError.ERROR_LENGTH.name(), equalTo(exception.getFieldError("name").getCode()));
		assertThat(ValidatorError.ERROR_LENGTH.name(), equalTo(exception.getFieldError("note").getCode()));
	}
}
