package pantheon.model.meta;

import static org.hamcrest.core.IsEqual.equalTo;
import static org.junit.Assert.assertThat;

import org.junit.Test;

public class CenturyTest {

	@Test
	public void test0() throws Exception {
		Century century = Century.getByYear(0);
		assertThat(null, equalTo(century));
	}

	@Test
	public void test1() throws Exception {
		Century century = Century.getByYear(1);
		assertThat("1世紀", equalTo(century.getName()));
	}

	@Test
	public void test100() throws Exception {
		Century century = Century.getByYear(100);
		assertThat("1世紀", equalTo(century.getName()));
	}

	@Test
	public void test101() throws Exception {
		Century century = Century.getByYear(101);
		assertThat("2世紀", equalTo(century.getName()));
	}

	@Test
	public void test50() throws Exception {
		Century century = Century.getByYear(50);
		assertThat("1世紀", equalTo(century.getName()));
	}

	@Test
	public void test1995() throws Exception {
		Century century = Century.getByYear(1995);
		assertThat("20世紀", equalTo(century.getName()));
	}

}
