package pantheon.model;

import static org.hamcrest.core.IsEqual.equalTo;
import static org.junit.Assert.assertThat;

import java.util.ArrayList;
import java.util.List;

import org.junit.Test;

import pantheon.model.meta.Century;

public class PageTest {

	@Test
	public void testZero() throws Exception {
		Page page = new Page(-1, "name", PageType.HORIZONTAL_CENTURY, Century.getByIndex(1), Century.getByIndex(10));
		assertThat(0, equalTo(page.getRecordList().size()));
	}

	@Test
	public void testOne() throws Exception {
		// 人物リスト準備
		List<Item> peopleList = new ArrayList<Item>();
		People people = new People();
		people.setName("PeopleA");
		people.setFromYear(1);
		people.setToYear(100);
		peopleList.add(people);

		Page page = new Page(-1, "name", PageType.HORIZONTAL_CENTURY, 1, 5);
		page.setPeopleList(peopleList);
		assertThat(1, equalTo(page.getRecordList().size()));

		PageRecord record = page.getRecordList().get(0);
		assertThat(1, equalTo(page.getRecordList().size()));

		assertThat(0d, equalTo(record.getStartPosition()));
		assertThat(0.2d, equalTo(record.getEndPosition()));
	}
}
