//====================
//メニューの利用
//====================
MenuEx=function(){
    //エイリアス
        var CheckItem=Ext.menu.CheckItem;
        var ColorMenu=Ext.menu.ColorMenu;
        var DateMenu=Ext.menu.DateMenu;
        var Menu=Ext.menu.Menu;
        var MessageBox=Ext.MessageBox;
    var Toolbar=Ext.Toolbar;

    //変数
    var root;   //ルート
    var toolbar;//ツールバー

    return {
        //初期化
        init:function(){
                        root=this;

            //ツールバーの生成
            toolbar=new Toolbar('toolbar');
            toolbar.add(
                                {
                    text:'メニュー0',
                    cls :'x-btn-text-icon bmenu',
                    menu:root.makeMenu0()
                },{
                    text:'メニュー1',
                    cls :'x-btn-text-icon bmenu',
                    menu:root.makeMenu1()        
                }
            );
        },
    
        //メニュー0の生成
        makeMenu0:function(){
            var menu=new Menu({
                id   :'menu0',
                items:[
                                        {
                        id     :'mi_bold',
                        text   :'<b>ボールド</b>',
                        handler:root.onItemClick
                    },{
                        id     :'mi_italic',
                        text   :'<i>イタリック</i>',
                        handler:root.onItemClick
                    },{
                        id     :'mi_underline',
                        text   :'<u>アンダーライン</u>',
                        handler:root.onItemClick
                    } 
                ]
            });
            return menu;
        },

        //メニュー1の生成
        makeMenu1:function(){
            var menu=new Menu({
                id   :'menu1',
                items:[
                                    //チェックアイテム
                    new Ext.menu.CheckItem({
                        text        :'チェックアイテム',
                        checked     :true,
                        checkHandler:root.onItemCheck 
                    }),
                                        //ラジオ項目
                                        {
                        text:'ラジオ項目',
                        menu:{
                            items: [
                                new CheckItem({
                                    text        :'ラジオ項目1',
                                    checked     :true,
                                    group       :'theme',
                                    checkHandler:root.onItemCheck
                                }),
                                new CheckItem({
                                    text        :'ラジオ項目2',
                                    group       :'theme',
                                    checkHandler:root.onItemCheck
                                })
                            ]
                        }
                    },
                    //セパレータ                     
                    '-', 
                    //日付選択
                    {
                        text:'日付選択',
                        cls :'calendar',
                        menu:new DateMenu({
                            handler:root.onDateClick
                        })
                    },
                    //色選択
                    {
                        text:'色選択',
                        menu:new ColorMenu({
                            handler:root.onColorClick
                        })
                    }
                ]
            });
            return menu;
        },

        //項目クリックイベントの処理
        onItemClick:function(item){
            MessageBox.alert('','項目クリック>'+item.id+","+item.text);
        },
        
        //項目チェックイベントの処理
        onItemCheck:function(item,checked){
            MessageBox.alert('','項目チェック>'+item.text+','+checked);
        },
        
        //日付クリックの処理
        onDateClick:function(dp,date){
            MessageBox.alert('','日付クリック>'+date.format('M j, Y'));
        },
        
        //色クリックの処理
        onColorClick:function(cm,color){
            MessageBox.alert('','色クリック>'+color);
        }
    }
}();
Ext.onReady(MenuEx.init,MenuEx,true);