<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ include file="/WEB-INF/jsp/include.jsp"%>

<html>
<head>
<title><fmt:message key="view.createUser.title" /></title>
</head>
<body>
	<%-- メニュー --%>
	<%@ include file="/WEB-INF/jsp/menu.jsp" %>

	<%-- 本文 --%>
	<div id="container" align="center">
		<h2><fmt:message key="view.createUser.heading" /></h2>
		<form:form method="post" commandName="LoginUserCommand">
			<table>
				<tr>
					<th><fmt:message key="lable.user.name" /></th>
					<td>
						<form:input path="name" /><br/>
						<form:errors path="name" cssClass="error" />
					</td>
					<td>
						ユーザー名はログインIDとしても使用されます。<br/>
						全角、半角、アルファベット、数字、記号、漢字等々入力可能です。<br/>
						（内部的にはDB層までUTF-8で処理されます。）<br/>
						文字種類の入力チェックは一切行ってませんが、<br/>
						サーバ処理中に文字化けするとログインできなくなる可能性があるため、<br/>
						あまりレアな文字は使用しないほうが無難です。<br/>
						（多分、機種依存文字は駄目です。）<br/>
						（※そのうち、半角スペース、半角カンマ等は入力禁止にする予定です。）<br/>
					</td>
				</tr>
				<tr>
					<th><fmt:message key="lable.user.password" /></th>
					<td>
						<form:password path="password" /><br/>
						<form:errors path="password" cssClass="error" />
					</td>
					<td>
						半角のアルファベットか数字のみ入力可能です。<br/>
						DBにはエンコードされて保管されます。<br/>
						（忘れると管理者がDBデータを手作業で変更するしかなくなります。）
					</td>
				</tr>
				<tr>
					<th><fmt:message key="lable.user.note" /></th>
					<td>
						<form:textarea path="note" />
						<form:errors path="note" cssClass="error" />
					</td>
					<td>
						自己紹介欄です。<br/>
						誰でも閲覧できる状態になるため、<br/>
						個人情報は記入しないでください。<br/>
					</td>
				</tr>
			</table>
			<br>
			<input type="submit" align="middle" value="<fmt:message key="view.createUser.btnLogin" />">
		</form:form>
		<div class="developerMsgToUsr">
			登録後にログイン画面に飛びます。自動的にはログインされません。<br />
			これは意図された仕様通りの動作です。<br />
			（これは純粋に開発者の技術不足による止むを得ない仕様です。<br />
			手抜き実装ではありません。<br />
			改善には1人日以上掛かると想定されます。）<br />
		</div>
	</div>
</body>
</html>