<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ include file="/WEB-INF/jsp/include.jsp" %>

<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><fmt:message key="view.createPage.title"/></title>
</head>
<body>
	<%-- メニュー --%>
	<%@ include file="/WEB-INF/jsp/menu.jsp" %>

	<%-- 本文 --%>
	<div id="container" align="center">
		<h2><fmt:message key="view.createPage.heading"/></h2>

		<form:form method="post" commandName="PageCommand">
			<table>
				<tr>
					<th><fmt:message key="lable.page.name" /></th>
					<td>
						<form:input path="name" />
						<br />
						<form:errors path="name" cssClass="error" />
					</td>
				</tr>
				<tr>
					<th><fmt:message key="lable.page.type" /></th>
					<td>
						<form:select path="pageTypeCode" size="1" >
							<form:options items="${pageTypeArray}" itemValue="code" itemLabel="name" />
						</form:select>
						<br />
						<form:errors path="pageTypeCode" cssClass="error" />
					</td>
				</tr>
				<tr>
					<th><fmt:message key="lable.page.fromCentury" /></th>
					<td>
						<form:select path="fromCentury" size="1" >
							<form:options items="${centuryList}" itemValue="index" itemLabel="name" />
						</form:select>
						<br />
						<form:errors path="fromCentury" cssClass="error" />
					</td>
				</tr>
				<tr>
					<th><fmt:message key="lable.page.toCentury" /></th>
					<td>
						<form:select path="toCentury" size="1" >
							<form:options items="${centuryList}" itemValue="index" itemLabel="name" />
						</form:select>
						<br />
						<form:errors path="toCentury" cssClass="error" />
					</td>
				</tr>
				<tr>
					<th>人物の一覧</th>
					<td>
						<form:select path="peopleIds" multiple="true" size="20" >
							<form:options items="${peopleList}" itemValue="id" itemLabel="name" />
						</form:select>
						<form:errors path="peopleIds" cssClass="error" />
					</td>
				</tr>
				<tr>
					<th>その他の一覧</th>
					<td>
						<form:select path="notClassificationItemIds" multiple="true" size="20" >
							<form:options items="${notClassificationItemList}" itemValue="id" itemLabel="name" />
						</form:select>
						<br />
						<form:errors path="notClassificationItemIds" cssClass="error" />
					</td>
				</tr>
			</table>
			<br />
			（[shift]ボタンを押しながらで、複数選択ができます）<br />
			<input type="submit" align="middle" value="<fmt:message key="lable.insert.submit" />">
		</form:form>
		
		<br />
		<br />
		<br />
		<div class="developerMsgToUsr">
			手抜きな画面で済みません。。。
		</div>
		<br />
		
	</div>
</body>
</html>