<%@ page contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file="/WEB-INF/jsp/include.jsp"%>
<table align="center" class="nonBoader-BackColor">
	<tr class="nonBoader-BackColor">
		<td class="nonBoader-BackColor">
			<%-- ロゴ --%>
			<div align="center">
				<a href="<c:url value="/"/>" style="font-size:12px;color:#dddddd;">
					<img alt="<fmt:message key="application.jpName"/><fmt:message key="application.enName"/>"
					     src="<c:url value="/image/pantheon-logo.png"/>">
				</a>
				<div style="font-size:12px;color:#dddddd;"><fmt:message key="application.version"/></div>
				<fmt:message key="application.server.name"/>
			</div>
		</td>

		<%-- このtdの色は背景色と同じ --%>
		<td class="menuback">
			<%-- メニュー --%>
			<table class="menu">
				<tr>
					<th>
						<a href="<c:url value="/page-list.html"/>"><fmt:message key="menu.pageList"/></a>
					</th>
					<th>
						<a href="<c:url value="/people-list.html"/>"><fmt:message key="menu.peopleList"/></a>
					</th>
					<th>
						<a href="<c:url value="/book-list.html"/>"><fmt:message key="menu.bookList"/></a>
					</th>
					<th>
						<a href="<c:url value="/notClassification-list.html"/>"><fmt:message key="menu.notClassificationList"/></a>
					</th>
					<security:authorize ifNotGranted="ROLE_USER,ROLE_ADMIN">
						<th>
							<a href="<c:url value="/login.html"/>"><fmt:message key="menu.login"/></a>
						</th>
						<th>
							<a href="<c:url value="/create-user.html"/>"><fmt:message key="menu.createUser"/></a>
						</th>
					</security:authorize>
					<security:authorize ifAnyGranted="ROLE_USER">
						<th>
							<a href="<c:url value="/logout"/>"><fmt:message key="menu.logout"/></a>
						</th>
					</security:authorize>
				</tr>
				<security:authorize ifAnyGranted="ROLE_USER">
					<tr>
						<th>
							<a href="<c:url value="/login/create-page.html"/>"><fmt:message key="menu.createPage"/></a>
						</th>
						<th>
							<a href="<c:url value="/login/create-people.html"/>"><fmt:message key="menu.createPeople"/></a>
						</th>
						<th>
							<a href="<c:url value="/login/create-book.html"/>"><fmt:message key="menu.createBook"/></a>
						</th>
						<th>
							<a href="<c:url value="/login/create-notClassification.html"/>"><fmt:message key="menu.createNotClassification"/></a>
						</th>
						<th>
							<a href="<c:url value="/login/loginuser-info.html"/>"><fmt:message key="menu.loginUserInfo"/></a>
						</th>
					</tr>
				</security:authorize>

			</table>
		</td>
		<td style="background-color: #D8D8D8;">
			<p>
				<c:set var="userInfo" value="${pageContext.request.userPrincipal}"></c:set>
				<c:if test="${userInfo != null}">
					ログイン中：<br />
					<c:out value="${userInfo.name}" />さん
				</c:if>
				<c:if test="${userInfo == null}">
					ログアウト中
				</c:if>
			</p>
		</td>
	</tr>
</table>
<hr />