<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ include file="/WEB-INF/jsp/include.jsp"%>

<html>
<head>
<title><fmt:message key="view.update${itemType}.title" /></title>
</head>
<body>
	<%-- メニュー --%>
	<%@ include file="/WEB-INF/jsp/menu.jsp" %>

	<%-- 本文 --%>
	<div id="container" align="center">
		<h2><fmt:message key="view.update${itemType}.heading" /></h2>
		<form:form method="post" commandName="ItemCommand">
			<table>
				<tr>
					<th><fmt:message key="lable.item.id" /></th>
					<td><c:out value="${ItemCommand.id}" /></td>
					<form:hidden path="id"/>
					<form:hidden path="version"/>
					<form:errors path="version" cssClass="error" />
				</tr>
				<tr>
					<th><fmt:message key="lable.item.name" /></th>
					<td>
						<form:input path="name" />
						<form:errors path="name" cssClass="error" />
					</td>
				</tr>
				<tr>
					<th><fmt:message key="lable.item.kanaName" /></th>
					<td>
						<form:input path="kanaName" />
						<form:errors path="kanaName" cssClass="error" />
					</td>
				</tr>
				<tr>
					<th><fmt:message key="lable.item.shortName" /></th>
					<td>
						<form:input path="shortName" />
						<form:errors path="shortName" cssClass="error" />
					</td>
				</tr>
				<tr>
					<th><fmt:message key="lable.item.wikiName" /></th>
					<td>
						<form:input path="wikiName" />
						<form:errors path="wikiName" cssClass="error" />
					</td>
				</tr>
				<tr>
					<th><fmt:message key="lable.item.englishName" /></th>
					<td>
						<form:input path="englishName" />
						<form:errors path="englishName" cssClass="error" />
					</td>
				</tr>
				<c:if test="${itemType.hasFromYear}">
					<tr>
						<th>
							<c:choose>
								<c:when test="${itemType == 'PEOPLE'}"><fmt:message key="lable.people.fromYear"/></c:when>
								<c:when test="${itemType == 'BOOK'}"><fmt:message key="lable.book.fromYear"/></c:when>
							</c:choose>
						</th>
						<td>
							<form:input path="fromYear" />
							<form:errors path="fromYear" cssClass="error" />
						</td>
					</tr>
				</c:if>
				<c:if test="${itemType.hasToYear}">
					<tr>
						<th>
							<c:choose>
								<c:when test="${itemType == 'PEOPLE'}"><fmt:message key="lable.people.toYear"/></c:when>
								<c:when test="${itemType == 'BOOK'}"><fmt:message key="lable.book.fromYear"/></c:when>
							</c:choose>
						</th>
						<td>
							<form:input path="toYear" />
							<form:errors path="toYear" cssClass="error" />
						</td>
					</tr>
				</c:if>
				<c:if test="${itemType == 'PEOPLE'}">
					<tr>
						<th>著作物の一覧</th>
						<td>
							<form:select path="propertyBookIds" multiple="true" size="5" >
								<form:options items="${bookList}" itemValue="id" itemLabel="name" />
							</form:select>
							<form:errors path="propertyBookIds" cssClass="error" />
						</td>
					</tr>
				</c:if>
			</table>
			<br />
			<table>
				<tr><th colspan="3">付随する年表データ</th></tr>
				<c:set var="i" value="0"/>
				<c:forEach items="${ItemCommand.propertyFromYear}">
					<tr>
						<td>
							<input type="text"
							       size="6"
							       maxlength="5" 
							       name="propertyFromYear"
							       value="${ItemCommand.propertyFromYear[i]}"><fmt:message key="lable.year" />
							<div class="error">${ItemCommand.propertyFromYearErrMsg[i]}</div>
						</td>
						<th>できごと</th>
						<td>
							<input type="text"
							       size="100" 
							       name="propertyText"
							       value="${ItemCommand.propertyText[i]}">
							<div class="error">${ItemCommand.propertyTextErrMsg[i]}</div>
						</td>
					</tr>
					<c:set var="i" value="${i+1}" />
				</c:forEach>
			</table>
			<br>

			<br />
			<%-- 戻るボタン--%>
			<c:url var="retrnUrl" value="/${itemType.lowerName}.html">
				<c:param name="itemId" value="${ItemCommand.id}" />
			</c:url>
			<input type="button"
			       value="<fmt:message key="lable.return"/>"
			       onClick="location.href='${retrnUrl}'">

			<%-- 更新確定ボタン--%>
			<input type="submit" align="middle" value="<fmt:message key="lable.update.submit" />">
		</form:form>
		<div class="developerMsgToUsr">
			※ご存命の人物には現在対応しておりません。<br />
			※年関係の値は西暦で入力してください。その他の暦には対応していません。<br />
			※ユリウス暦かグレゴリオ暦かは深く考えないでください。<br />
			※紀元前には対応していません。<br />
			※年は5桁まで入力できますが、年表は21世紀までしか表示できません。<br />
			※「付随する年表データ」が10件固定ですが、画面の動的制御を本リリースでは避けたためです。<br />
		</div>
	</div>
</body>
</html>