<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ include file="/WEB-INF/jsp/include.jsp" %>

<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><fmt:message key="view.${itemType}List.title"/></title>
</head>
<body>
	<%-- メニュー --%>
	<%@ include file="/WEB-INF/jsp/menu.jsp" %>

	<%-- 本文 --%>
	<div id="container" align="center">
		<h2><fmt:message key="view.${itemType}List.heading"/></h2>
		<table>
			<tr>
				<th><fmt:message key="lable.item.name"/></th>
				<th><fmt:message key="lable.item.shortName"/></th>
				<th>詳細</th>
				<th>
					<img alt="<fmt:message key="lable.goto.wikipedia"/>" src="<c:url value="/image/gotoWikipedia.png"/>" />
				</th>
				<c:if test="${itemType.hasFromYear}">
					<th>
						<c:choose>
							<c:when test="${itemType == 'PEOPLE'}"><fmt:message key="lable.people.fromYear"/></c:when>
							<c:when test="${itemType == 'BOOK'}"><fmt:message key="lable.book.fromYear"/></c:when>
						</c:choose>
					</th>
				</c:if>
				<c:if test="${itemType.hasToYear}">
					<th>
						<c:choose>
							<c:when test="${itemType == 'PEOPLE'}"><fmt:message key="lable.people.toYear"/></c:when>
						</c:choose>
					</th>
				</c:if>
				<th><fmt:message key="lable.history"/></th>
			</tr>
			<c:forEach items="${itemList}" var="item">
				<tr>
					<td><c:out value="${item.name}"/></td>
					<td><c:out value="${item.shortName}"/></td>
					<td>
						<a href="
							<c:url value="/${itemType.lowerName}.html">
								<c:param name="itemId" value="${item.id}" />
							</c:url>">
							詳細
						</a>
					</td>
					<td>
						<c:if test="${item.wikiName!='' && item.wikiName!=null}">
							<a href="http://ja.wikipedia.org/wiki/${item.wikiName}"
							   onclick="window.open('http://ja.wikipedia.org/wiki/${item.wikiName}'); return false;">
								<img alt="<fmt:message key="lable.goto.wikipedia"/>" src="<c:url value="/image/gotoWikipedia.png"/>" />
							</a>
						</c:if>
					</td>
					<c:if test="${itemType.hasFromYear}">
						<td align="right">
							<c:out value="${item.fromYear}"/><fmt:message key="lable.year"/>
						</td>
					</c:if>
					<c:if test="${itemType.hasToYear}">
						<td>
							<c:out value="${item.toYear}"/><fmt:message key="lable.year"/>
						</td>
					</c:if>
					<td>
						<a href="
							<c:url value="/${itemType.lowerName}-history.html">
								<c:param name="itemId" value="${item.id}" />
							</c:url>"
						>
							<fmt:message key="lable.history"/>
						</a>
					</td>
				</tr>
			</c:forEach>
		</table>
		<br />
	</div>
</body>
</html>