<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ include file="/WEB-INF/jsp/include.jsp"%>

<html>
<head>
<title><fmt:message key="view.${itemType}Info.title" /></title>
</head>
<body>
	<%-- メニュー --%>
	<%@ include file="/WEB-INF/jsp/menu.jsp" %>

	<%-- 本文 --%>
	<div id="container" align="center">
		<h2><fmt:message key="view.${itemType}Info.heading" /></h2>
			<table>
				<tr>
					<th><fmt:message key="lable.item.id" /></th>
					<td><c:out value="${item.id}" /></td>
				</tr>
				<tr>
					<th><fmt:message key="lable.version" /></th>
					<td>
						<fmt:message key="lable.version.prefix"/><c:out value="${item.version}"/><fmt:message key="lable.version.suffix"/>
						<c:if test="${isLastVersion}">
							（最新版）
						</c:if>
					</td>
				</tr>
				<tr>
					<th><fmt:message key="lable.item.name" /></th>
					<td>
						<c:out value="${item.name}" />
					</td>
				</tr>
				<tr>
					<th><fmt:message key="lable.item.kanaName" /></th>
					<td>
						<c:out value="${item.kanaName}" />
					</td>
				</tr>
				<tr>
					<th><fmt:message key="lable.item.shortName" /></th>
					<td>
						<c:out value="${item.shortName}" />
					</td>
				</tr>
				<tr>
					<th><fmt:message key="lable.item.wikiName" /></th>
					<td>
						<c:if test="${item.wikiName!='' && item.wikiName!=null}">
							<a href="http://ja.wikipedia.org/wiki/${item.wikiName}"
							   onclick="window.open('http://ja.wikipedia.org/wiki/${item.wikiName}'); return false;">
								<c:out value="${item.wikiName}" />
							</a>
						</c:if>
					</td>
				</tr>
				<tr>
					<th><fmt:message key="lable.item.englishName" /></th>
					<td>
						<c:out value="${item.englishName}" />
					</td>
				</tr>
				<c:if test="${itemType.hasFromYear}">
					<tr>
						<th>
							<c:choose>
								<c:when test="${itemType == 'PEOPLE'}"><fmt:message key="lable.people.fromYear"/></c:when>
								<c:when test="${itemType == 'BOOK'}"><fmt:message key="lable.book.fromYear"/></c:when>
							</c:choose>
						</th>
						<td>
							<c:out value="${item.fromYear}" />
						</td>
					</tr>
				</c:if>
				<c:if test="${itemType.hasToYear}">
					<tr>
						<th>
							<c:choose>
								<c:when test="${itemType == 'PEOPLE'}"><fmt:message key="lable.people.toYear"/></c:when>
								<c:when test="${itemType == 'BOOK'}"><fmt:message key="lable.book.fromYear"/></c:when>
							</c:choose>
						</th>
						<td>
							<c:out value="${item.toYear}" />
						</td>
					</tr>
				</c:if>

				<%-- 人物情報モードの時の著作物(Book)一覧 --%>
				<c:if test="${itemType == 'PEOPLE' && 0 < bookListSize}">
					<tr>
						<th rowspan="${bookListSize}">著作物</th>
						<td>
							<a href="
								<c:url value="/book.html">
									<c:param name="itemId" value="${bookList[0].id}" />
								</c:url>">
								<c:out value="${bookList[0].name}" />
							</a>
						</td>
					</tr>
					<c:forEach var="book" items="${bookList}" begin="1" >
						<tr>
							<td>
								<a href="
									<c:url value="/book.html">
										<c:param name="itemId" value="${book.id}" />
									</c:url>">
									<c:out value="${book.name}" />
								</a>
							</td>
						</tr>
					</c:forEach>
				</c:if>

				<%-- 書籍情報モードの時の著者(People)一覧 --%>
				<c:if test="${itemType == 'BOOK' && 0 < peopleListSize}">
					<tr>
						<th rowspan="${peopleListSize}">著者</th>
						<td>
							<a href="
								<c:url value="/people.html">
									<c:param name="itemId" value="${peopleList[0].id}" />
								</c:url>">
								<c:out value="${peopleList[0].name}" />
							</a>
						</td>
					</tr>
					<c:forEach var="people" items="${peopleList}" begin="1" >
						<tr>
							<td>
								<a href="
									<c:url value="/people.html">
										<c:param name="itemId" value="${people.id}" />
									</c:url>">
									<c:out value="${people.name}" />
								</a>
							</td>
						</tr>
					</c:forEach>
				</c:if>
			</table>
			<br>
			<h2>付随する年表データ</h2>
			<table>
				<tr>
					<th><fmt:message key="lable.year" /></th>
					<th>できごと</th>
				</tr>
				<c:forEach var="property" items="${item.pointPropertyList}" >
					<tr>
						<td>${property.fromYear}<fmt:message key="lable.year" /></td>
						<td>${property.text}</td>
					</tr>
				</c:forEach>
				<c:if test="${item.pointPropertySize == 0}">
					<tr>
						<td colspan="2">登録データはありません</td>
					</tr>
				</c:if>
			</table>
			<br>

			<br />
			<%-- 戻るボタン--%>
			<input type="button"
			       value="一覧へ"
			       onClick="location.href='<c:url value="/${itemType.lowerName}-list.html"/>'">

			
			<security:authorize ifAnyGranted="ROLE_USER">
				<%-- 更新ボタン--%>
				<c:url var="updateUrl" value="/login/update-${itemType.lowerName}.html">
					<c:param name="itemId" value="${item.id}" />
				</c:url>
				<input type="button"
				       value="<fmt:message key="lable.update"/>"
				       onClick="location.href='${updateUrl}'">
			</security:authorize>
			
	</div>
</body>
</html>