package pantheon.web;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

import pantheon.LoginService;
import pantheon.model.User;

public class UserInfoController implements Controller {
	protected final Log logger = LogFactory.getLog(getClass());
	private String viewName;
	private LoginService loginService;

	public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		String userId = request.getParameter("userId");
		if (!StringUtils.isNumeric(userId)) {
			return new ModelAndView("/403.html");
		}

		User user = loginService.findByUserId(Long.valueOf(userId));

		return new ModelAndView(viewName, "User", user);
	}

	@Required
	public void setViewName(String viewName) {
		this.viewName = viewName;
	}

	@Required
	public void setLoginService(LoginService loginService) {
		this.loginService = loginService;
	}

}
