package pantheon.web;

import org.apache.commons.lang.StringUtils;
import org.springframework.util.Assert;
import org.springframework.validation.Errors;

import pantheon.model.PageType;
import pantheon.model.People;
import pantheon.model.meta.Century;

public class PageValidator extends AbstractPantheonValidator {

	@SuppressWarnings("unchecked")
	public boolean supports(Class clazz) {
		return PageCommand.class.equals(clazz);
	}

	public void validate(Object obj, Errors errors) {
		Assert.notNull(obj);

		PageCommand command = (PageCommand) obj;

		// **************************
		// 名前
		// **************************
		String currentField = "name";
		String currentValue = command.getName();

		if (StringUtils.isBlank(currentValue)) {
			rejectBlankError(errors, currentField, "名前");
		}
		if (!errors.hasFieldErrors(currentField) && People.NAME_LENGTH < currentValue.length()) {
			rejectOverLengthError(errors, currentField, "名前", People.NAME_LENGTH);
		}

		// **************************
		// 表示タイプ
		// **************************
		currentField = "pageTypeCode";
		currentValue = command.getPageTypeCode();

		if (StringUtils.isBlank(currentValue)) {
			rejectBlankError(errors, currentField, "表示タイプ");
		}

		if (!errors.hasFieldErrors(currentField) && PageType.getByCode(currentValue) == null) {
			rejectValue(errors, currentField, "表示タイプ");
		}

		// **************************
		// from世紀
		// **************************
		currentField = "fromCentury";
		int currentIntValue = command.getFromCentury();

		if (Century.getByIndex(currentIntValue) == null) {
			rejectCenturyIndexError(errors, currentField, "描画開始世紀");
		}

		// **************************
		// to世紀
		// **************************
		currentField = "toCentury";
		currentIntValue = command.getToCentury();

		if (Century.getByIndex(currentIntValue) == null) {
			rejectCenturyIndexError(errors, currentField, "描画終了世紀");
		}

		// **************************
		// from世紀,to世紀
		// **************************
		if (!errors.hasFieldErrors("fromCentury") && !errors.hasFieldErrors("toCentury")) {
			if (command.getToCentury() < command.getFromCentury()) {
				errors.rejectValue("fromCentury", ValidatorError.ERROR_CENTURY_FROM_TO.name());
			}
		}

	}

}