package pantheon.web;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

import pantheon.LoginService;
import pantheon.model.User;
import pantheon.user.LoginUser;
import pantheon.user.UserUtility;

public class LoginUserInfoController implements Controller {
	protected final Log logger = LogFactory.getLog(getClass());
	private String viewName;
	private LoginService loginService;

	public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		LoginUser loginUser = UserUtility.getLoginUser(request);

		User user = loginService.findByUserId(loginUser.getId());

		// TODO userInfo変数が式言語で使えるけど、userInfoって何？
		return new ModelAndView(viewName, "User", user);
	}

	@Required
	public void setViewName(String viewName) {
		this.viewName = viewName;
	}

	@Required
	public void setLoginService(LoginService loginService) {
		this.loginService = loginService;
	}
}
