package pantheon.web;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

import pantheon.ItemService;
import pantheon.model.Item;
import pantheon.model.ItemType;
import pantheon.model.Label;

public class ItemInfoController implements Controller {
	protected final Log logger = LogFactory.getLog(getClass());
	private String viewName;
	private ItemType itemType;
	private ItemService itemService;

	public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		// パラメータ取得＆チェック
		String sItemId = request.getParameter("itemId");
		if (!StringUtils.isNumeric(sItemId)) {
			return new ModelAndView("/403.html");
		}
		long itemId = Long.valueOf(sItemId);

		String sVersion = request.getParameter("version");
		Integer version;
		if (StringUtils.isBlank(sVersion)) {
			version = null;
		} else {
			if (!StringUtils.isNumeric(sVersion)) {
				return new ModelAndView("/403.html");
			}
			version = Integer.valueOf(sVersion);
		}

		//
		Map<String, Object> myModel = new HashMap<String, Object>();

		if (version == null) {
			Item item = itemService.findByIdWithProperties(itemId);
			myModel.put("item", item);

			if (itemType == ItemType.PEOPLE) {
				List<Item> bookList = itemService.findAllTargetItem(itemId, Label.WRITTEN);
				myModel.put("bookList", bookList);
				myModel.put("bookListSize", bookList.size());
			} else if (itemType == ItemType.BOOK) {
				List<Item> peopleList = itemService.findAllItemByTargetItem(Label.WRITTEN, itemId);
				myModel.put("peopleList", peopleList);
				myModel.put("peopleListSize", peopleList.size());
			}
			myModel.put("itemType", itemType);
			myModel.put("isLastVersion", true);
		} else {
			Item item = itemService.findByIdWithProperties(itemId, version);
			myModel.put("item", item);

			if (itemType == ItemType.PEOPLE) {
				List<Item> bookList = itemService.findAllTargetItem(itemId, Label.WRITTEN, version);
				myModel.put("bookList", bookList);
				myModel.put("bookListSize", bookList.size());
			} else if (itemType == ItemType.BOOK) {
				// TODO item側のversionしか分からないため、
				// TargetIdとversionを指定して履歴から取得することはできない
				// とりあえず最新情報を表示
				List<Item> peopleList = itemService.findAllItemByTargetItem(Label.WRITTEN, itemId);
				myModel.put("peopleList", peopleList);
				myModel.put("peopleListSize", peopleList.size());
			}
			myModel.put("itemType", itemType);
			myModel.put("isLastVersion", false);
		}

		return new ModelAndView(viewName, myModel);
	}

	@Required
	public void setViewName(String viewName) {
		this.viewName = viewName;
	}

	@Required
	public void setItemType(String itemType) {
		this.itemType = ItemType.valueOf(itemType);
	}

	@Required
	public void setItemService(ItemService itemService) {
		this.itemService = itemService;
	}

}
