package pantheon.web;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import pantheon.model.ItemProperty;
import pantheon.model.ItemType;
import pantheon.model.Label;
import pantheon.model.PropertyType;

public class ItemCommand {
	private Boolean isInsert;// true:Insert false:Update
	private long id;
	private ItemType itemType;
	private String name;
	private String kanaName;
	private String shortName;
	private String wikiName;
	private String englishName;
	private String fromYear;
	private String toYear;
	private int version;
	private String[] propertyFromYear;
	private String[] propertyFromYearErrMsg;
	private String[] propertyText;
	private String[] propertyTextErrMsg;
	private Long[] propertyBookIds;// 人物により書かれた書籍のID。

	public Boolean getIsInsert() {
		return isInsert;
	}

	public void setIsInsert(Boolean isInsert) {
		this.isInsert = isInsert;
	}

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public ItemType getItemType() {
		return itemType;
	}

	public void setItemType(ItemType itemType) {
		this.itemType = itemType;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getKanaName() {
		return kanaName;
	}

	public void setKanaName(String kanaName) {
		this.kanaName = kanaName;
	}

	public String getShortName() {
		return shortName;
	}

	public void setShortName(String shortName) {
		this.shortName = shortName;
	}

	public String getWikiName() {
		return wikiName;
	}

	public void setWikiName(String wikiName) {
		this.wikiName = wikiName;
	}

	public String getEnglishName() {
		return englishName;
	}

	public void setEnglishName(String englishName) {
		this.englishName = englishName;
	}

	public String getFromYear() {
		return fromYear;
	}

	public void setFromYear(String fromYear) {
		this.fromYear = fromYear;
	}

	public String getToYear() {
		return toYear;
	}

	public void setToYear(String toYear) {
		this.toYear = toYear;
	}

	public int getVersion() {
		return version;
	}

	public void setVersion(int version) {
		this.version = version;
	}

	public int getPropertyCount() {
		if (propertyFromYear == null) {
			return 0;
		}
		return propertyFromYear.length;
	}

	public String[] getPropertyFromYear() {
		return propertyFromYear;
	}

	public void setPropertyFromYear(String[] propertyFromYear) {
		this.propertyFromYear = propertyFromYear;
	}

	public String[] getPropertyFromYearErrMsg() {
		return propertyFromYearErrMsg;
	}

	public void setPropertyFromYearErrMsg(String[] propertyFromYearErrMsg) {
		this.propertyFromYearErrMsg = propertyFromYearErrMsg;
	}

	public String[] getPropertyText() {
		return propertyText;
	}

	public void setPropertyText(String[] propertyText) {
		this.propertyText = propertyText;
	}

	public String[] getPropertyTextErrMsg() {
		return propertyTextErrMsg;
	}

	public void setPropertyTextErrMsg(String[] propertyTextErrMsg) {
		this.propertyTextErrMsg = propertyTextErrMsg;
	}

	/**
	 * このメソッドが呼ばれたときは、Validatorによるチェックが終わった後なので、 ノーチェックで処理させている。
	 * 
	 * @return
	 */
	public List<ItemProperty> getPointPropertyList() {
		List<ItemProperty> list = new ArrayList<ItemProperty>();

		for (int i = 0; i < this.getPropertyCount(); i++) {

			String fromYear = propertyFromYear[i];
			String text = propertyText[i];

			if (StringUtils.isBlank(fromYear) && StringUtils.isBlank(text)) {
				continue;
			}

			ItemProperty property = new ItemProperty();
			property.setLabel(Label.NOT_CLASSIFICATION);
			property.setType(PropertyType.POINT);
			property.setFromYear(Integer.parseInt(fromYear));
			property.setText(text);
			list.add(property);
		}

		return list;
	}

	public String getPropertyErr() {
		return null;
	}

	public Long[] getPropertyBookIds() {
		return propertyBookIds;
	}

	public void setPropertyBookIds(Long[] propertyBookIds) {
		this.propertyBookIds = propertyBookIds;
	}

}
