package pantheon.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;
import org.springframework.web.servlet.view.RedirectView;

import pantheon.BookService;
import pantheon.model.Book;
import pantheon.model.ItemType;
import pantheon.user.LoginUser;
import pantheon.user.UserUtility;

public class CreateBookController extends SimpleFormController {
	/** Logger for this class and subclasses */
	protected final Log logger = LogFactory.getLog(getClass());
	private BookService bookService;

	public CreateBookController() {
		super();
		setCommandName("ItemCommand");
		setCommandClass(ItemCommand.class);
	}

	@Override
	protected boolean suppressValidation(HttpServletRequest request, Object command) {
		ItemCommand itemCommand = (ItemCommand) command;
		itemCommand.setIsInsert(Boolean.TRUE);
		itemCommand.setItemType(ItemType.BOOK);
		return super.suppressValidation(request, command);
	}

	@Override
	protected ModelAndView onSubmit(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
		ItemCommand itemCommand = (ItemCommand) command;

		// 名前重複チェック
		if (bookService.findByName(itemCommand.getName()) != null) {
			ObjectError error = new FieldError("ItemCommand", "name", ValidatorError.editSameNameErrMessage(itemCommand.getName()));
			errors.addError(error);
			return super.showForm(request, response, errors);
		}

		LoginUser user = UserUtility.getLoginUser(request);

		Book book = new Book();
		book.setName(itemCommand.getName());
		book.setKanaName(itemCommand.getKanaName());
		book.setShortName(itemCommand.getShortName());
		book.setWikiName(itemCommand.getWikiName());
		book.setEnglishName(itemCommand.getEnglishName());
		book.setFromYear(Integer.parseInt(itemCommand.getFromYear()));

		bookService.insert(book, user.getId());

		return new ModelAndView(new RedirectView(getSuccessView()));
	}

	public void setBookService(BookService bookService) {
		this.bookService = bookService;
	}

}
