package pantheon.web;

import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public abstract class AbstractPantheonValidator implements Validator {
	/** Logger for this class and subclasses */
	protected final Log logger = LogFactory.getLog(getClass());

	boolean isNotNumber(String value) {
		return !NumberUtils.isNumber(value);
	}

	void rejectValue(Errors errors, String fieldName, String viewFieldName) {
		errors.rejectValue(fieldName, ValidatorError.ERROR_VALUE.name(), new Object[] {}, fieldName + " value is err.");
	}

	void rejectVersionError(Errors errors, String fieldName) {
		errors.rejectValue(fieldName, ValidatorError.ERROR_VERSION.name(), new Object[] {}, fieldName + " version is lost.");
	}

	void rejectBlankError(Errors errors, String fieldName, String viewFieldName) {
		errors.rejectValue(fieldName, ValidatorError.ERROR_BLANK.name(), new Object[] { viewFieldName }, fieldName + " is blank.");
	}

	void rejectOverLengthError(Errors errors, String fieldName, String viewFieldName, int length) {
		errors.rejectValue(fieldName, ValidatorError.ERROR_LENGTH.name(), new Object[] { viewFieldName, length }, fieldName + " is lengthOver.");
	}

	void rejectNumericError(Errors errors, String fieldName, String viewFieldName) {
		errors.rejectValue(fieldName, ValidatorError.ERROR_NUMERIC.name(), new Object[] { viewFieldName }, fieldName + " is not numeric.");
	}

	void rejectAlphanumericError(Errors errors, String fieldName, String viewFieldName) {
		errors.rejectValue(fieldName, ValidatorError.ERROR_ALPHANUMERIC.name(), new Object[] { viewFieldName }, fieldName + " is not alphanumeric.");
	}

	void rejectZenkakuKataKanaSpaceError(Errors errors, String fieldName, String viewFieldName) {
		errors.rejectValue(fieldName, ValidatorError.ERROR_ZENKAKU_KATA_KANA.name(), new Object[] { viewFieldName }, fieldName + " is not zenkaku kata-kana.");
	}

	void rejectCenturyIndexError(Errors errors, String fieldName, String viewFieldName) {
		errors
				.rejectValue(fieldName, ValidatorError.ERROR_CENTURY_INDEX.name(), new Object[] { viewFieldName }, fieldName
						+ " is err century index.");
	}
}
