package pantheon.user;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.ArrayList;
import java.util.List;

import javax.sql.DataSource;

import org.springframework.context.ApplicationContextException;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.object.MappingSqlQuery;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UsernameNotFoundException;
import org.springframework.security.userdetails.jdbc.JdbcUserDetailsManager;

public class PantheonJdbcUserDetailsManager extends JdbcUserDetailsManager {
	private final static String FIND_SQL = "SELECT * FROM users WHERE username = ?";

	private MappingSqlQuery myMapping;

	public PantheonJdbcUserDetailsManager() {
		setEnableGroups(false);// とりあえず使用しないので無効化
	}

	@Override
	protected void initDao() throws ApplicationContextException {
		super.initDao();
		this.myMapping = new MyMapping(getDataSource());
	}

	@Override
	@SuppressWarnings("unchecked")
	protected List loadUsersByUsername(String username) {
		throw new UnsupportedOperationException();
	}

	@SuppressWarnings("unchecked")
	protected List<LoginUser> loadUsersByUsernameEx(String username) {
		return myMapping.execute(username);
	}

	@Override
	public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
		List<LoginUser> users = loadUsersByUsernameEx(username);

		if (users.size() == 0) {
			throw new UsernameNotFoundException(messages.getMessage("JdbcDaoImpl.notFound", new Object[] { username }, "Username {0} not found"),
					username);
		}

		LoginUser userFromUserQuery = (LoginUser) users.get(0);

		// 権限追加
		List<GrantedAuthority> dbAuths = new ArrayList<GrantedAuthority>();
		dbAuths.add(new GrantedAuthorityImpl("ROLE_USER"));
		if (userFromUserQuery.getType() == 0) {
			// TODO UserTypeのenum化
			dbAuths.add(new GrantedAuthorityImpl("ROLE_ADMIN"));
		}

		GrantedAuthority[] arrayAuths = (GrantedAuthority[]) dbAuths.toArray(new GrantedAuthority[dbAuths.size()]);
		userFromUserQuery.setAuthorities(arrayAuths);

		return userFromUserQuery;
	}

	@Override
	protected UserDetails createUserDetails(String username, UserDetails userFromUserQuery, GrantedAuthority[] combinedAuthorities) {
		throw new UnsupportedOperationException();
	}

	@Override
	@SuppressWarnings("unchecked")
	protected List loadGroupAuthorities(String username) {
		throw new UnsupportedOperationException();
	}

	@Override
	@SuppressWarnings("unchecked")
	protected List loadUserAuthorities(String username) {
		throw new UnsupportedOperationException();
	}

	private final static class MyMapping extends MappingSqlQuery {

		protected MyMapping(DataSource ds) {
			super(ds, FIND_SQL);
			declareParameter(new SqlParameter(Types.VARCHAR));
			compile();
		}

		@Override
		protected LoginUser mapRow(ResultSet rs, int rownum) throws SQLException {
			long id = rs.getLong("user_id");
			int type = rs.getInt("user_type");
			String username = rs.getString("username");
			String password = rs.getString("password");
			boolean enabled = rs.getBoolean("enabled");

			LoginUser user = new LoginUser(id, type, username, password, enabled);
			return user;
		}
	}
}