package pantheon.user;

import java.util.SortedSet;
import java.util.TreeSet;

import org.springframework.security.GrantedAuthority;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.util.Assert;

public class LoginUser implements UserDetails {

	private static final long serialVersionUID = 1L;

	private long id;
	private int type;
	private String username;
	private String password;
	private GrantedAuthority[] authorities;
	private boolean enabled;

	public LoginUser(long id, int type, String username, String password, boolean enabled) throws IllegalArgumentException {
		this.id = id;
		this.type = type;
		this.username = username;
		this.password = password;
		this.enabled = enabled;
	}

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public int getType() {
		return type;
	}

	public void setType(int type) {
		this.type = type;
	}

	@Override
	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	@Override
	public String getPassword() {
		return password;
	}

	public GrantedAuthority[] getAuthorities() {
		return authorities;
	}

	/**
	 * SpringFrameworkのUser実装のコピペ
	 */
	protected void setAuthorities(GrantedAuthority[] authorities) {
		Assert.notNull(authorities, "Cannot pass a null GrantedAuthority array");
		// Ensure array iteration order is predictable (as per
		// UserDetails.getAuthorities() contract and SEC-xxx)
		SortedSet<GrantedAuthority> sorter = new TreeSet<GrantedAuthority>();
		for (int i = 0; i < authorities.length; i++) {
			Assert.notNull(authorities[i], "Granted authority element " + i + " is null - GrantedAuthority[] cannot contain any null elements");
			sorter.add(authorities[i]);
		}

		this.authorities = (GrantedAuthority[]) sorter.toArray(new GrantedAuthority[sorter.size()]);
	}

	public boolean isAccountNonExpired() {
		return true;
	}

	public boolean isAccountNonLocked() {
		return true;
	}

	public boolean isCredentialsNonExpired() {
		return true;
	}

	public boolean isEnabled() {
		return enabled;
	}

}
