package pantheon.model.meta;

public class PantheonStringUtil {

	private final static String ZENKAKU_KANA_STIRNGS = "アイウエオカキクケコサシスセソタチツテトナニヌネノハニフヘノマミムメモヤユノラリルレロワヲンヴガギグゲゴザジズゼゾダヂヅデドバビブベボパピプペポァィゥェォッャュョー";
	private final static char[] ZENKAKU_KANA_SPACE = (ZENKAKU_KANA_STIRNGS + "　").toCharArray();

	private static boolean inCharArray(char[] charArray, char checkValue) {
		for (char c : charArray) {
			if (checkValue == c) {
				return true;
			}
		}
		return false;
	}

	public static boolean isZenkakuKanaSpace(String value) {
		for (int i = 0; i < value.length(); i++) {
			if (!inCharArray(ZENKAKU_KANA_SPACE, value.charAt(i))) {
				return false;
			}
		}

		return true;
	}

}
