package pantheon.model;

import org.apache.commons.lang.StringUtils;

public enum PageType {

	HORIZONTAL_MILLENIUM(1, "水平方向　概略モード"), //
	HORIZONTAL_CENTURY(2, "水平方向　詳細モード"), //
	;

	public static PageType getByCode(String code) {
		if (code == null) {
			return null;
		}

		if (!StringUtils.isNumeric(code)) {
			return null;
		}

		return getByCode(Integer.parseInt(code));
	}

	public static PageType getByCode(int code) {
		for (PageType pageType : PageType.values()) {
			if (pageType.code == code) {
				return pageType;
			}
		}

		throw new IllegalArgumentException("unknown code. code=" + code);
	}

	private final int code;
	private final String name;

	private PageType(int code, String name) {
		this.code = code;
		this.name = name;
	}

	public int getCode() {
		return code;
	}

	public String getName() {
		return name;
	}

}
