package pantheon.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class Item extends AbstractPanteonModel {
	public final static int NAME_LENGTH = 20;
	public final static int SHORT_NAME_LENGTH = 15;
	public final static int ENGLISH_NAME_LENGTH = 50;
	public final static int YEAR_LENGTH = 5;

	private long id;
	private ItemType type;
	private String name;
	private String kanaName;
	private String shortName;
	private String wikiName;
	private String englishName;
	private int fromYear;
	private int toYear;
	private int version;
	private long updateUserId;
	private User updateUser;
	private Date updateDate;
	private List<ItemProperty> propertyList;

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public ItemType getType() {
		return type;
	}

	public void setType(ItemType type) {
		this.type = type;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getKanaName() {
		return kanaName;
	}

	public void setKanaName(String kanaName) {
		this.kanaName = kanaName;
	}

	public String getShortName() {
		return shortName;
	}

	public void setShortName(String shortName) {
		this.shortName = shortName;
	}

	public String getWikiName() {
		return wikiName;
	}

	public void setWikiName(String wikiName) {
		this.wikiName = wikiName;
	}

	public String getEnglishName() {
		return englishName;
	}

	public void setEnglishName(String englishName) {
		this.englishName = englishName;
	}

	public int getFromYear() {
		return fromYear;
	}

	public void setFromYear(int fromYear) {
		this.fromYear = fromYear;
	}

	public int getToYear() {
		return toYear;
	}

	public void setToYear(int toYear) {
		this.toYear = toYear;
	}

	public int getVersion() {
		return version;
	}

	public void setVersion(int version) {
		this.version = version;
	}

	public long getUpdateUserId() {
		return updateUserId;
	}

	public void setUpdateUserId(long updateUserId) {
		this.updateUserId = updateUserId;
	}

	public User getUpdateUser() {
		return updateUser;
	}

	public void setUpdateUser(User updateUser) {
		this.updateUser = updateUser;
	}

	public Date getUpdateDate() {
		return updateDate;
	}

	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}

	public List<ItemProperty> getPropertyList() {
		return propertyList;
	}

	public void setPropertyList(List<ItemProperty> propertyList) {
		this.propertyList = propertyList;
	}

	/**
	 * 時点プロパティの一覧を取得
	 * 
	 * @return
	 */
	public List<ItemProperty> getPointPropertyList() {
		List<ItemProperty> pointPropertyList = new ArrayList<ItemProperty>();

		for (ItemProperty property : propertyList) {
			if (property.getType() == PropertyType.POINT) {
				pointPropertyList.add(property);
			}
		}

		return pointPropertyList;
	}

	public int getPropertySize() {
		if (propertyList == null) {
			return 0;
		}

		return propertyList.size();
	}

	public int getPointPropertySize() {
		int count = 0;

		for (ItemProperty property : propertyList) {
			if (property.getType() == PropertyType.POINT) {
				count++;
			}
		}

		return count;
	}

	public final static class ItemFromToComparator implements Comparator<Item> {

		@Override
		public int compare(Item p1, Item p2) {
			if (p1.getFromYear() != p2.getFromYear()) {
				return p1.getFromYear() - p2.getFromYear();
			}

			if (p1.getToYear() != p2.getToYear()) {
				return p1.getToYear() - p2.getToYear();
			}

			return p1.getName().compareTo(p2.getName());
		}

	}
}
