/**
 * 
 */
package pantheon.dao;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.springframework.jdbc.core.simple.ParameterizedRowMapper;

import pantheon.model.ItemProperty;
import pantheon.model.Label;
import pantheon.model.PropertyType;

class ItemPropertyMapper implements ParameterizedRowMapper<ItemProperty> {

	public ItemProperty mapRow(ResultSet rs, int rowNum) throws SQLException {
		ItemProperty property = new ItemProperty();
		property.setItemId(rs.getInt("item_id"));
		property.setIndex(rs.getInt("property_index"));
		property.setLabel(Label.getByCode(rs.getInt("label_id")));
		property.setType(PropertyType.getByCode(rs.getInt("property_type")));
		property.setTargetItemId(rs.getInt("target_item_id"));
		property.setFromYear(rs.getInt("from_year"));
		property.setToYear(rs.getInt("to_year"));
		property.setText(rs.getString("text"));
		return property;
	}
}
