package pantheon.dao;

import java.util.List;

import pantheon.model.ItemProperty;

public class ItemPropertyJdbcHsqldbDao extends PantheonJdbcDao implements ItemPropertyDao {
	final static String ALL_FIELDS;
	final static String ORDER = "order by label_id,from_year,to_year,property_index";
	private final static String FIND_BY_ID;
	private final static String INSERT;
	private final static String DELETE_BY_ITEM;

	static {
		{
			StringBuilder sb = new StringBuilder();
			sb.append("select * from item_property ");
			sb.append("where item_id=? ");
			sb.append(ORDER);
			FIND_BY_ID = sb.toString();
		}

		{
			StringBuilder sb = new StringBuilder();
			sb.append("item_id,");
			sb.append("property_index,");
			sb.append("label_id,");
			sb.append("property_type,");
			sb.append("target_item_id,");
			sb.append("from_year,");
			sb.append("to_year,");
			sb.append("text");
			ALL_FIELDS = sb.toString();
		}

		{
			StringBuilder sb = new StringBuilder();
			sb.append("insert into item_property (");
			sb.append(ALL_FIELDS);
			sb.append(")values(");
			sb.append("  ?,");// item_id
			sb.append("  ?,");// property_index
			sb.append("  ?,");// label_id
			sb.append("  ?,");// property_type
			sb.append("  ?,");// target_item_id
			sb.append("  ?,");// from_year
			sb.append("  ?,");// to_year
			sb.append("  ?");// text
			sb.append(")");
			INSERT = sb.toString();
		}
		{
			StringBuilder sb = new StringBuilder();
			sb.append("delete from item_property ");
			sb.append("where item_id=?");
			DELETE_BY_ITEM = sb.toString();
		}
	}

	@Override
	public List<ItemProperty> findAllById(long itemId) {
		return getSimpleJdbcTemplate().query(FIND_BY_ID, new ItemPropertyMapper(), itemId);

	}

	@Override
	public void insert(ItemProperty property) {
		int affectedCount = getSimpleJdbcTemplate().update(INSERT,//
				property.getItemId(), //
				property.getIndex(), //
				property.getLabel().getCode(), //
				property.getType().getCode(), //
				property.getTargetItemId(), //
				property.getFromYear(), //
				property.getToYear(), //
				property.getText() //
				);
		checkHitOneRecord(affectedCount);
	}

	@Override
	public void deleteAll(long itemId) {
		getSimpleJdbcTemplate().update(DELETE_BY_ITEM, itemId);
	}
}
