package pantheon.dao;

import java.util.List;

import pantheon.model.ItemProperty;

public class ItemPropertyHistoryJdbcHsqldbDao extends PantheonJdbcDao implements ItemPropertyHistoryDao {

	private final static String FIND_ALL_BY_ID;
	private final static String BACKUP;

	static {
		{
			StringBuilder sb = new StringBuilder();
			sb.append("select * from item_property_hist ");
			sb.append("where item_id=? and item_version=? ");
			sb.append(ItemPropertyJdbcHsqldbDao.ORDER);
			FIND_ALL_BY_ID = sb.toString();
		}
		{
			StringBuilder sb = new StringBuilder();
			sb.append("insert into item_property_hist (");
			sb.append(ItemPropertyJdbcHsqldbDao.ALL_FIELDS);
			sb.append(",item_version");
			sb.append(") ");
			sb.append("select ");
			sb.append(ItemPropertyJdbcHsqldbDao.ALL_FIELDS);
			sb.append(",? ");
			sb.append("from item_property ");
			sb.append("where item_id=?");
			BACKUP = sb.toString();
		}
	}

	@Override
	public List<ItemProperty> findAllById(long itemId, int version) {// TODO 引数
		return getSimpleJdbcTemplate().query(FIND_ALL_BY_ID, new ItemPropertyMapper(), itemId, version);
	}

	@Override
	public void backup(long itemId, int itemVersion) {
		getSimpleJdbcTemplate().update(BACKUP, itemVersion, itemId);
	}

}
