/**
 * 
 */
package pantheon.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

import org.springframework.jdbc.core.simple.ParameterizedRowMapper;

import pantheon.model.Item;
import pantheon.model.ItemType;

class ItemMapper implements ParameterizedRowMapper<Item> {
	public Item mapRow(ResultSet rs, int rowNum) throws SQLException {
		Item item = new Item();
		item.setId(rs.getInt(ItemJdbcHsqldbDao.FLD_ID));
		item.setType(ItemType.getByCode(rs.getString("item_type")));
		item.setName(rs.getString("item_jp_name"));
		item.setKanaName(rs.getString("item_jp_name_kana"));
		item.setShortName(rs.getString("item_jp_name_short"));
		item.setWikiName(rs.getString("item_wiki_name"));
		item.setEnglishName(rs.getString("item_en_name"));
		item.setFromYear(rs.getInt("fromYear"));
		item.setToYear(rs.getInt("toYear"));
		item.setVersion(rs.getInt("version"));
		item.setUpdateUserId(rs.getInt("update_user_id"));
		item.setUpdateDate(new Date(rs.getTimestamp("update_date").getTime()));
		return item;
	}
}