package pantheon.dao;

import java.util.List;

import pantheon.model.Item;
import pantheon.model.ItemType;
import pantheon.model.Label;

public class ItemJdbcHsqldbDao extends AbstractItemJdbcHsqldbDao implements ItemDao {

	final static String FIND_ALL_ITEM_BY_ITEMTYPE;
	final static String FIND_ALL_TARGET_ITEM;
	final static String FIND_ALL_ITEM_BY_TARGET;
	private final static String INSERT;
	private final static String UPDATE;

	static {
		{
			StringBuilder sb = new StringBuilder();
			sb.append("select * from " + TABLE_NAME + " ");
			sb.append("where item_type=? ");
			sb.append("order by item_id ");
			FIND_ALL_ITEM_BY_ITEMTYPE = sb.toString();
		}

		{
			StringBuilder sb = new StringBuilder();
			sb.append("select * from " + TABLE_NAME + " ");
			sb.append("where " + FLD_ID + " in (");
			sb.append("select target_item_id from item_property ");
			sb.append("where item_id=? and label_id=? ");
			sb.append(")");
			
			FIND_ALL_TARGET_ITEM = sb.toString();
		}

		{
			StringBuilder sb = new StringBuilder();
			sb.append("select * from " + TABLE_NAME + " ");
			sb.append("where " + FLD_ID + " in (");
			sb.append("select item_id from item_property ");
			sb.append("where label_id=? and target_item_id=? ");
			sb.append(")");

			FIND_ALL_ITEM_BY_TARGET = sb.toString();
		}

		{
			StringBuilder sb = new StringBuilder();
			sb.append("insert into " + TABLE_NAME + " (");
			sb.append(ALL_FIELDS_JOIN_COMMA_WITHOUT_ID);
			sb.append(") values (");
			sb.append("?,");// item_type
			sb.append("?,");// item_jp_name
			sb.append("?,");// item_jp_name_kana
			sb.append("?,");// item_jp_name_short
			sb.append("?,");// item_wiki_name
			sb.append("?,");// item_en_name
			sb.append("?,");// fromYear
			sb.append("?,");// toYear
			sb.append(Item.FIRST_VIRSION + ",");// version
			sb.append("?,");// update_user_id
			sb.append("now()");// update_date
			sb.append(")");
			INSERT = sb.toString();
		}

		{
			StringBuilder sb = new StringBuilder();
			sb.append("update " + TABLE_NAME + " ");
			sb.append("set ");
			sb.append("item_jp_name=?,");
			sb.append("item_jp_name_kana=?,");
			sb.append("item_jp_name_short=?,");
			sb.append("item_wiki_name=?,");
			sb.append("item_en_name=?,");
			sb.append("fromYear=?,");
			sb.append("toYear=?,");
			sb.append("version=?,");
			sb.append("update_user_id=?,");
			sb.append("update_date=now() ");
			sb.append("where " + FLD_ID + "=?");
			sb.append(" and version=?");
			sb.append(" and item_type=?");
			UPDATE = sb.toString();
		}
	}

	@Override
	public Item findById(long itemId) {
		List<Item> list = getSimpleJdbcTemplate().query(FIND_BY_ID, new ItemMapper(), itemId);
		return getFirstRecordAfterCheck(list);
	}

	@Override
	public Item findByName(String name) {
		List<Item> list = getSimpleJdbcTemplate().query(FIND_BY_NAME, new ItemMapper(), name);
		return getFirstRecordAfterCheck(list);
	}

	@Override
	public Item findByIdForUpdate(long itemId) {

		List<Item> list = getSimpleJdbcTemplate().query(FIND_BY_ID + " FOR UPDATE", new ItemMapper(), itemId);
		return getFirstRecordAfterCheck(list);
	}

	@Override
	public List<Item> findAllItem(ItemType itemType) {
		return getSimpleJdbcTemplate().query(FIND_ALL_ITEM_BY_ITEMTYPE, new ItemMapper(), itemType.getCode());
	}

	@Override
	public List<Item> findAllTargetItem(long itemId, Label label) {
		return getSimpleJdbcTemplate().query(FIND_ALL_TARGET_ITEM, new ItemMapper(), itemId, label.getCode());
	}

	@Override
	public List<Item> findAllItemByTargetItem(Label label, long tagetId) {
		return getSimpleJdbcTemplate().query(FIND_ALL_ITEM_BY_TARGET, new ItemMapper(), label.getCode(), tagetId);
	}

	@Override
	public List<Item> findAllHistory(long itemId) {
		return getSimpleJdbcTemplate().query(FIND_ALL_HISTORY, new ItemMapper(), itemId);
	}

	// TODO このメソッドはinsertSimpleに移行させる
	@Override
	public long insert(Item item, long userId) {
		// 追加
		int affectedCount = getSimpleJdbcTemplate().update(INSERT,//
				item.getType().getCode(),// item_type
				item.getName(),// item_jp_name
				item.getKanaName(),// item_jp_name_kana
				item.getShortName(),// item_jp_name_short
				item.getWikiName(),// item_wiki_name
				item.getEnglishName(),// item_en_name
				item.getType().isHasFromYear() ? item.getFromYear() : null,// fromYear
				item.getType().isHasToYear() ? item.getToYear() : null,// toYear
				userId// update_user_id
				);
		checkHitOneRecord(affectedCount);

		// 履歴作成
		long itemId = getLastInsertId();
		long version = Item.FIRST_VIRSION;
		affectedCount = getSimpleJdbcTemplate().update(BACKUP_ITEM, itemId, version);
		checkHitOneRecord(affectedCount);

		return itemId;
	}

	@Override
	public long insertSimple(Item item, long userId) {
		// 追加
		int affectedCount = getSimpleJdbcTemplate().update(INSERT,//
				item.getType().getCode(),// item_type
				item.getName(),// item_jp_name
				item.getKanaName(),// item_jp_name_kana
				item.getShortName(),// item_jp_name_short
				item.getWikiName(),// item_wiki_name
				item.getEnglishName(),// item_en_name
				item.getType().isHasFromYear() ? item.getFromYear() : null,// fromYear
				item.getType().isHasToYear() ? item.getToYear() : null,// toYear
				userId// update_user_id
				);
		checkHitOneRecord(affectedCount);

		return getLastInsertId();
	}

	@Override
	public int update(Item item, long userId) {
		if (item.getVersion() < Item.FIRST_VIRSION) {
			throw new IllegalStateException("itemId = " + item.getId());
		}

		int newVersion = item.getVersion() + 1;

		int affectedCount = getSimpleJdbcTemplate().update(UPDATE,//
				item.getName(), // item_jp_name
				item.getKanaName(), // item_jp_name_kana
				item.getShortName(), // item_jp_name_short
				item.getWikiName(), // item_wiki_name
				item.getEnglishName(), // item_en_name
				item.getType().isHasFromYear() ? item.getFromYear() : null,// fromYear
				item.getType().isHasToYear() ? item.getToYear() : null,// toYear
				newVersion,//
				userId,//
				item.getId(),//
				item.getVersion(),//
				item.getType().getCode()//
				);

		checkHitOneRecord(affectedCount);

		// 履歴作成
		long iteId = item.getId();
		affectedCount = getSimpleJdbcTemplate().update(BACKUP_ITEM, iteId, newVersion);
		checkHitOneRecord(affectedCount);

		return newVersion;
	}

	@Override
	public long updateSimple(Item item, long userId) {
		if (item.getVersion() < Item.FIRST_VIRSION) {
			throw new IllegalStateException("itemId = " + item.getId());
		}

		int newVersion = item.getVersion() + 1;

		int affectedCount = getSimpleJdbcTemplate().update(UPDATE,//
				item.getName(), // item_jp_name
				item.getKanaName(), // item_jp_name_kana
				item.getShortName(), // item_jp_name_short
				item.getWikiName(), // item_wiki_name
				item.getEnglishName(), // item_en_name
				item.getType().isHasFromYear() ? item.getFromYear() : null,// fromYear
				item.getType().isHasToYear() ? item.getToYear() : null,// toYear
				newVersion,//
				userId,//
				item.getId(),//
				item.getVersion(),//
				item.getType().getCode()//
				);

		checkHitOneRecord(affectedCount);

		return newVersion;
	}

}
