package pantheon.dao;

public abstract class AbstractItemJdbcHsqldbDao extends PantheonJdbcDao {
	final static String TABLE_NAME = "item";
	final static String HIST_TABLE_NAME = "item_hist";
	final static String FLD_ID = "item_id";

	final static String ALL_FIELDS_JOIN_COMMA;
	final static String ALL_FIELDS_JOIN_COMMA_WITHOUT_ID;

	final static String FIND_ALL_PREFIX;
	final static String FIND_BY_ID = "select * from " + TABLE_NAME + " where " + FLD_ID + "=?";
	final static String FIND_BY_NAME = "select * from " + TABLE_NAME + " where item_jp_name=?";
	final static String BACKUP_ITEM;
	final static String FIND_ALL_HISTORY;

	static {
		{
			StringBuilder sb = new StringBuilder();
			sb.append("item_type,");
			sb.append("item_jp_name,");
			sb.append("item_jp_name_kana,");
			sb.append("item_jp_name_short,");
			sb.append("item_wiki_name,");
			sb.append("item_en_name,");
			sb.append("fromYear,");
			sb.append("toYear,");
			sb.append("version,");
			sb.append("update_user_id,");
			sb.append("update_date");
			ALL_FIELDS_JOIN_COMMA_WITHOUT_ID = sb.toString();
		}

		ALL_FIELDS_JOIN_COMMA = "item_id," + ALL_FIELDS_JOIN_COMMA_WITHOUT_ID;

		{
			StringBuilder sb = new StringBuilder();
			sb.append("select * from " + TABLE_NAME + " ");
			sb.append("where item_type = ");
			FIND_ALL_PREFIX = sb.toString();
		}

		{
			StringBuilder sb = new StringBuilder();
			sb.append("insert into " + HIST_TABLE_NAME + " (");
			sb.append(ALL_FIELDS_JOIN_COMMA);
			sb.append(") ");
			sb.append("select ");
			sb.append(ALL_FIELDS_JOIN_COMMA);
			sb.append(" from " + TABLE_NAME + " ");
			sb.append("where item_id=? and version=?");

			BACKUP_ITEM = sb.toString();
		}

		{
			StringBuilder sb = new StringBuilder();
			sb.append("select * ");
			sb.append("from " + HIST_TABLE_NAME + " where " + FLD_ID + "=? order by version desc");
			FIND_ALL_HISTORY = sb.toString();
		}
	}
}
