package pantheon;

import java.util.List;

import pantheon.model.Book;
import pantheon.model.Item;
import pantheon.model.ItemProperty;
import pantheon.model.ItemType;
import pantheon.model.Label;

public interface ItemService {
	Item findById(long itemId);

	Item findByIdWithProperties(long itemId);

	Item findById(long itemId, int version);

	Item findByIdWithProperties(long itemId, int version);

	Item findByName(String name);

	List<Book> findAllBook();

	List<Item> findAllItem(ItemType itemType);

	List<Item> findAllTargetItem(long itemId, Label label);

	List<Item> findAllTargetItem(long itemId, Label label, int version);

	List<Item> findAllItemByTargetItem(Label label, long tagetId);

	List<Item> findAllHistory(long itemId);

	long insert(Item item, long userId);

	void update(Item item, long userId);

	List<ItemProperty> findAllPropertyByItemId(long propertyId);

	List<ItemProperty> findAllPropertyByItemId(long itemId, int version);

	void insertAllProperties(Item item);
}
