package pantheon;

import java.util.List;

import org.springframework.beans.factory.annotation.Required;
import org.springframework.transaction.annotation.Transactional;

import pantheon.dao.BookDao;
import pantheon.model.Book;

public class BookServiceImpl extends AbstractDefaultReadOnlyService implements BookService {

	private BookDao bookDao;

	@Override
	public List<Book> findAll() {
		return bookDao.findAll();
	}

	@Override
	public Book findById(String itemId) {
		return bookDao.findById(itemId);
	}

	@Override
	public Book findByName(String name) {
		return bookDao.findByName(name);
	}

	@Override
	@Transactional
	public long insert(Book book, long userId) {
		return bookDao.insert(book, userId);
	}

	@Override
	@Transactional
	public void update(Book book, long userId) {
		logger.info("BookServiceImpl#update userId=" + userId);
		bookDao.update(book, userId);
	}

	@Required
	public void setBookDao(BookDao bookDao) {
		this.bookDao = bookDao;
	}
}
