package pantheon;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/**
 * クラスに対し、@Transactional(readOnly = true, propagation=Propagation.REQUIRED)が
 * 設定されている。
 * 
 * @Transactional(propagation=Propagation.SUPPORTS)だと、
 * メソッドで明示的に@Transactionalが指定されていない限り、
 * ロールバックが利かなくなる。
 * http://www.ibm.com/developerworks/jp/java/library/j-ts1.html
 */
@Transactional(
		readOnly = true,
		propagation=Propagation.REQUIRED,
		rollbackFor=Exception.class)
public abstract class AbstractDefaultReadOnlyService {
	protected final Log logger = LogFactory.getLog(getClass());
}
