DROP TABLE IF EXISTS users;
CREATE TABLE users (
	user_id INTEGER NOT NULL AUTO_INCREMENT,
	user_type INTEGER NOT NULL,
	username VARCHAR(60) NOT NULL,
	password VARCHAR(60) NOT NULL,
	note VARCHAR(1000),
	enabled INTEGER NOT NULL,
	create_date DATETIME NOT NULL,
	primary key (user_id)
) TYPE=InnoDB;
alter table users add unique (username);

DROP TABLE IF EXISTS item;
CREATE TABLE item (
	item_id INTEGER NOT NULL AUTO_INCREMENT,
	item_type INTEGER NOT NULL,
	item_jp_name varchar(255) NOT NULL,
	item_jp_name_kana varchar(255),
	item_jp_name_short varchar(255),
	item_wiki_name varchar(255),
	item_en_name varchar(255),
	fromYear INTEGER,
	toYear INTEGER,
	version INTEGER NOT NULL,
	update_user_id INTEGER NOT NULL,
	update_date DATETIME NOT NULL,
	primary key (item_id)
) TYPE=InnoDB;
alter table item add unique (item_jp_name);

DROP TABLE IF EXISTS item_hist;
CREATE TABLE item_hist (
	item_id INTEGER NOT NULL AUTO_INCREMENT,
	item_type INTEGER NOT NULL,
	item_jp_name varchar(255) NOT NULL,
	item_jp_name_kana varchar(255),
	item_jp_name_short varchar(255),
	item_wiki_name varchar(255),
	item_en_name varchar(255),
	fromYear INTEGER,
	toYear INTEGER,
	version INTEGER NOT NULL,
	update_user_id INTEGER NOT NULL,
	update_date DATETIME NOT NULL,
	primary key (item_id,version)
) TYPE=InnoDB;

DROP TABLE IF EXISTS item_property;
CREATE TABLE item_property (
	item_id INTEGER NOT NULL,
	property_index INTEGER NOT NULL,
	label_id INTEGER NOT NULL,
	property_type INTEGER NOT NULL,
	target_item_id INTEGER,
	from_year INTEGER,
	to_year INTEGER,
	text varchar(255),
	primary key (item_id,property_index)
) TYPE=InnoDB;

DROP TABLE IF EXISTS item_property_hist;
CREATE TABLE item_property_hist (
	item_id INTEGER NOT NULL,
	property_index INTEGER NOT NULL,
	label_id INTEGER NOT NULL,
	property_type INTEGER NOT NULL,
	target_item_id INTEGER,
	from_year INTEGER,
	to_year INTEGER,
	text varchar(255),
	item_version INTEGER NOT NULL,
	primary key (item_id,property_index,item_version)
) TYPE=InnoDB;

DROP TABLE IF EXISTS page_ex2;
CREATE TABLE page_ex2 (
	page_id INTEGER NOT NULL AUTO_INCREMENT,
	page_name varchar(255) NOT NULL,
	page_type INTEGER NOT NULL,
	from_century INTEGER NOT NULL,
	to_century INTEGER NOT NULL,
	use_people_ids varchar(1000) NOT NULL,
	use_notclassification_ids varchar(1000) NOT NULL,
	primary key (page_id)
) TYPE=InnoDB;
alter table page_ex2 add unique (page_name);
