// boost::spirit ǤΥѡ 饤֥

#include <boost/spirit.hpp>
#include <boost/spirit/tree/ast.hpp>
#include <boost/function.hpp>
#include <vector>


namespace ray {
  namespace dice {
      using namespace boost::spirit;

      typedef int node_val_data_t;
      typedef node_val_data_factory<node_val_data_t> factory_t;
      typedef char const*         iterator_t;
      typedef tree_match<iterator_t, factory_t> parse_tree_match_t;
      typedef ast_match_policy<iterator_t, factory_t> match_policy_t;
      typedef scanner<iterator_t, scanner_policies<iter_policy_t, match_policy_t> > scanner_t;
      typedef parse_tree_match_t::tree_iterator iter_t;
      typedef parse_tree_match_t::node_t node_t;
      typedef rule<scanner_t> rule_t;
      typedef tree_parse_info<iterator_t,factory_t> parse_info_t;

    //=======================================================================
    // ʸˡ definition ƥץ졼ȤФ˻
    class DiceParser : public grammar<DiceParser> {
    public:
      static const int exprID  = 1;
      static const int stermID = 2;
      static const int mtermID = 3;
      static const int dtermID = 4;
      static const int ptermID = 5;
      static const int valID   = 6;
      static const int identID = 7;
      static const int ftermID = 8;
      static const int pterm2ID = 9;
      
        template<typename S> struct definition
          {
            // ʸˡ
            // expr   ::= val | fterm | dterm
            // sterm  ::= mterm ('+' mterm | '-' mterm)*
            // mterm  ::= pterm ('*' pterm | '/' pterm | '%' pterm)*
            // pterm  ::= val ('^' pterm)*
            // val    ::= int_p | '(' sterm ')'
            // dterm  ::= val ('d' | 'D') val
            // ident  ::= lexeme_d[ alpha_p (alpha_p | '_')* ]
            // fterm  ::= ident '(' (sterm (',' sterm)* )? ')'
            //
            // ϵ
            //   expr

            rule<S, parser_context<>, parser_tag<exprID> >  expr;
            rule<S, parser_context<>, parser_tag<stermID> > sterm;
            rule<S, parser_context<>, parser_tag<mtermID> > mterm;
            rule<S, parser_context<>, parser_tag<dtermID> > dterm;
            rule<S, parser_context<>, parser_tag<ptermID> > pterm;
            rule<S, parser_context<>, parser_tag<valID> >   val;
            rule<S, parser_context<>, parser_tag<identID> > ident;
            rule<S, parser_context<>, parser_tag<ftermID> > fterm;
            rule<S, parser_context<>, parser_tag<pterm2ID> > pterm2;

            definition(const DiceParser& self)
              {
                expr = fterm | sterm;
                
                sterm = mterm >> *( root_node_d[ch_p('+') | '-'] >> mterm);
                mterm = dterm >> *( root_node_d[ch_p('*') | '/' | '%'] >> dterm);
                dterm = pterm >> *(root_node_d[ch_p('d') | 'D'] >> pterm);
		pterm = pterm2 | val;
		pterm2 = val >> root_node_d[ch_p('^')] >> pterm;
                val = leaf_node_d[int_p] | inner_node_d[ ch_p('(') >> sterm >> ')' ] | fterm;
                ident = token_node_d[ lexeme_d[ +(alpha_p | '_' ) ] ];
                fterm = root_node_d[ident] >> inner_node_d[
                    ch_p('(') >> !infix_node_d[ sterm >> *(',' >> sterm) ] >> ')'
                  ];
              }

            const rule<S, parser_context<>, parser_tag<exprID> >& start() const { return expr; }
          };

	template <typename SkipT> parse_info_t ast_parse(const char* buf, SkipT const &skip ) {
	    return ::boost::spirit::ast_parse(buf, buf + strlen(buf), *this, skip, factory_t() );
	}
	template <typename IteratorT, typename SkipT> tree_parse_info<IteratorT,factory_t> ast_parse(std::string str, SkipT const &skip) {
	    return ::boost::spirit::ast_parse(str.begin(), str.end(), *this, skip, factory_t());
	}
      };

      typedef DiceParser::result<scanner_t>::type match_result_t;

      typedef boost::function<int (const char *, ::std::vector<int>)> calc_func_t;

      void calc_val(iter_t const& i, calc_func_t f);
      void tree_out(iter_t const& i, std::ostream& out, const std::string& str);
      void rpn_out(iter_t const& i, std::ostream& out);
      void xml_out(tree_parse_info<> const& p, std::ostream& out, const std::string& str);
      void calc_val_out( iter_t const& i, calc_func_t f, std::ostream& out );
      void calc_val_out( iter_t const& i, std::ostream& out );
  }
}
