/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class tdc
extends JFrame
implements ActionListener,
chatEvent,
MenuListener,
ChangeListener {
    JTextArea logArea = null;
    JTextField inputField = null;
    JScrollPane scrollLog = null;
    JMenuBar menubar = null;
    JMenu mnuFile = null;
    JMenuItem mnuFileQuit = null;
    JMenuItem mnuFileConnect = null;
    JMenuItem mnuFileDisconnect = null;
    private chat connection = null;
    boolean wasLogEnd = true;
    boolean logAppend = false;

    tdc() {
        super("Tiny Dice System - Client");
        this.initApp();
    }

    private void initApp() {
        this.logArea = new JTextArea();
        this.inputField = new JTextField();
        this.scrollLog = new JScrollPane(this.logArea);
        this.menubar = new JMenuBar();
        this.mnuFile = new JMenu("File");
        this.mnuFileQuit = new JMenuItem("Quit");
        this.mnuFileConnect = new JMenuItem("Connect ...");
        this.mnuFileDisconnect = new JMenuItem("Disconnect");
        this.logArea.setEditable(false);
        this.inputField.addActionListener(this);
        this.scrollLog.getViewport().addChangeListener(this);
        this.mnuFileQuit.addActionListener(this);
        this.mnuFileConnect.addActionListener(this);
        this.mnuFileDisconnect.addActionListener(this);
        this.mnuFile.addMenuListener(this);
        this.setDefaultCloseOperation(1);
        Container container = this.getContentPane();
        container.add((Component)this.scrollLog, "Center");
        container.add((Component)this.inputField, "South");
        this.mnuFile.add(this.mnuFileConnect);
        this.mnuFile.add(this.mnuFileDisconnect);
        this.mnuFile.addSeparator();
        this.mnuFile.add(this.mnuFileQuit);
        this.menubar.add(this.mnuFile);
        this.setJMenuBar(this.menubar);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                tdc.quit();
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.inputField)) {
            if (this.connection != null) {
                try {
                    this.connection.putMessage(this.inputField.getText() + "\n");
                }
                catch (IOException iOException) {
                    System.err.println("Message send error.");
                }
                this.inputField.setText("");
                this.inputField.requestFocus();
            }
        } else if (object.equals(this.mnuFileConnect)) {
            this.connect();
        } else if (object.equals(this.mnuFileDisconnect)) {
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
        } else if (object.equals(this.mnuFileQuit)) {
            tdc.quit();
        }
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuSelected(MenuEvent menuEvent) {
        if (menuEvent.getSource().equals(this.mnuFile)) {
            this.mnuFileDisconnect.setEnabled(this.connection != null);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JScrollBar jScrollBar = this.scrollLog.getVerticalScrollBar();
        if (jScrollBar != null) {
            if (this.logAppend && this.wasLogEnd && jScrollBar.getValue() + jScrollBar.getVisibleAmount() != jScrollBar.getMaximum()) {
                jScrollBar.setValue(jScrollBar.getMaximum());
                this.logAppend = false;
            }
            this.wasLogEnd = jScrollBar.getValue() + jScrollBar.getVisibleAmount() == jScrollBar.getMaximum();
        }
    }

    public boolean onGetMessage(String string) {
        JScrollBar jScrollBar = this.scrollLog.getVerticalScrollBar();
        if (jScrollBar != null) {
            this.wasLogEnd = jScrollBar.getValue() + jScrollBar.getVisibleAmount() == jScrollBar.getMaximum();
        }
        this.logAppend = true;
        this.logArea.append(string);
        return true;
    }

    public static void quit() {
        System.exit(0);
    }

    private void connect() {
        int n;
        if (this.connection != null) {
            return;
        }
        JOptionPane jOptionPane = new JOptionPane();
        String string = JOptionPane.showInputDialog(this, (Object)"Hostname");
        if (string == null) {
            return;
        }
        try {
            n = Integer.parseInt(JOptionPane.showInputDialog(this, (Object)"Port number"));
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        try {
            this.connection = new chat(string, n, this);
        }
        catch (IOException iOException) {
            System.err.println("Connect to " + string + ":" + n + " failed.\n");
            this.onGetMessage("*** Connect failed ***\n");
            this.connection = null;
        }
        this.inputField.requestFocus();
    }

    public static void main(String[] stringArray) {
        tdc tdc2 = new tdc();
        tdc2.setSize(450, 300);
        tdc2.show();
    }
}

