/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms timip_of the GNU General Public License as published by
    the Free Software Foundation; either version 2 timip_of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty timip_of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy timip_of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __TIMIP_W32G_UTL_H_
#define __TIMIP_W32G_UTL_H_

#ifdef WIN32
#include "timip_win32.h"
#endif

#ifdef IA_W32G_SYN
#ifndef MAX_PORT
#define MAX_PORT 4
#endif
#endif

// ini & config
#define IniVersion "2.2"
typedef struct SETTING_PLAYER_ {
// Main Window
	int InitMinimizeFlag;
// SubWindow Starting Create Flag
	int DebugWndStartFlag;
	int ConsoleWndStartFlag;
	int ListWndStartFlag;
	int TracerWndStartFlag;
	int DocWndStartFlag;
	int WrdWndStartFlag;
// SubWindow Starting Valid Flag
	int DebugWndFlag;
	int ConsoleWndFlag;
	int ListWndFlag;
	int TracerWndFlag;
	int DocWndFlag;
	int WrdWndFlag;
	int SoundSpecWndFlag;
// SubWindow Max Numer
	int SubWindowMax;
// Default File
	char ConfigFile[MAXPATH + 32];
	char PlaylistFile[MAXPATH + 32];
	char PlaylistHistoryFile[MAXPATH + 32];
// Default Dir
	char MidiFileOpenDir[MAXPATH + 32];
	char ConfigFileOpenDir[MAXPATH + 32];
	char PlaylistFileOpenDir[MAXPATH + 32];
// Thread Priority
	int PlayerThreadPriority;
	int GUIThreadPriority;
// Font
	char SystemFont[256];
	char PlayerFont[256];
	char WrdFont[256];
	char DocFont[256];
	char ListFont[256];
	char TracerFont[256];
	int SystemFontSize;
	int PlayerFontSize;
	int WrdFontSize;
	int DocFontSize;
	int ListFontSize;
	int TracerFontSize;
// Misc.
	int WrdGraphicFlag;
	int TraceGraphicFlag;
	int DocMaxSize;
	char DocFileExt[256];
// End.
	int PlayerLanguage;
	int DocWndIndependent; 
	int DocWndAutoPopup; 
	int SeachDirRecursive;
	int IniFileAutoSave;
	int SecondMode;
  int AutoloadPlaylist;
  int AutosavePlaylist;
  int PosSizeSave;
  char DefaultPlaylistName[256];
// End.
} SETTING_PLAYER;

typedef struct SETTING_TIMIDITY_ {
    // Parameter from command line options.

LIBTIMIPDLL_API     int32 timip_amplification;	// A
LIBTIMIPDLL_API     int timip_antialiasing_allowed;	// a
    int buffer_fragments;	// B
LIBTIMIPDLL_API     int32 timip_control_ratio;	// C
				// c (ignore)
LIBTIMIPDLL_API     ChannelBitMask timip_default_drumchannels, timip_default_drumchannel_mask; // D
				// d (ignore)

				// E...
LIBTIMIPDLL_API     int timip_opt_modulation_wheel;	// E w/W
LIBTIMIPDLL_API     int timip_opt_portamento;		// E p/P
LIBTIMIPDLL_API     int timip_opt_nrpn_vibrato;  	// E v/V
LIBTIMIPDLL_API     int timip_opt_channel_pressure;	// E s/S
LIBTIMIPDLL_API     int timip_opt_trace_text_meta_event; // E t/T
LIBTIMIPDLL_API     int timip_opt_overlap_voice_allow;// E o/O
LIBTIMIPDLL_API     int timip_opt_default_mid;	// E mXX
LIBTIMIPDLL_API     int timip_default_tonebank;	// E b
LIBTIMIPDLL_API     int timip_special_tonebank;	// E B
LIBTIMIPDLL_API     int timip_effect_lr_mode;		// E Fdelay
LIBTIMIPDLL_API     int timip_effect_lr_delay_msec;	// E Fdelay
LIBTIMIPDLL_API     int timip_opt_reverb_control;	// E Freverb
LIBTIMIPDLL_API     int timip_opt_chorus_control;	// E Fchorus
LIBTIMIPDLL_API     int timip_noise_sharp_type;	// E Fns
	int timip_opt_surround_chorus; // E ?
	int timip_opt_tva_attack;			// E ?
	int timip_opt_tva_decay;			// E ?
	int timip_opt_tva_release;		// E ?
	int timip_opt_delay_control;		// E ?
	int timip_opt_default_module;		// --module
	int timip_opt_lpf_def;			// E ?
	int timip_opt_drum_effect;			// E ?
	int timip_opt_modulation_envelope;			// E ?
	int timip_opt_pan_delay;			// E ?
	int timip_opt_eq_control;			// E ?
	int timip_opt_insertion_effect;	// E ?
LIBTIMIPDLL_API     int timip_opt_evil_mode;		// e
LIBTIMIPDLL_API     int timip_adjust_panning_immediately; // F
LIBTIMIPDLL_API     int timip_fast_decay;		// f
#ifdef SUPPORT_SOUNDSPEC
    int view_soundspec_flag;	// g
    double spectrogram_update_sec; // g
#endif
				// h (ignore)
LIBTIMIPDLL_API     int timip_default_program[MAX_CHANNELS]; // I
    char opt_ctl[30];		// i
LIBTIMIPDLL_API     int timip_opt_realtime_playing;	// j
LIBTIMIPDLL_API     int timip_reduce_voice_threshold; // k
				// L (ignore)
    char opt_playmode[16];	// O
    char OutputName[MAXPATH + 32]; // o : string
    char OutputDirName[MAXPATH + 32]; // o : string
	int auto_output_mode;
				// P (ignore)
    int voices;			// p
LIBTIMIPDLL_API     int timip_auto_reduce_polyphony;  // pa
LIBTIMIPDLL_API     ChannelBitMask timip_quietchannels; // Q
LIBTIMIPDLL_API     int timip_temper_type_mute;	// Q
    char opt_qsize[16];		// q
LIBTIMIPDLL_API     int32 timip_modify_release;	// R
LIBTIMIPDLL_API     int32 timip_allocate_cache_size;	// S
	int32 timip_opt_drum_power;	// ?
	int32 timip_opt_amp_compensation;	// ?
	int timip_key_adjust;		// K
	int8 timip_opt_force_keysig;	// H
	int timip_opt_pure_intonation;	// Z
	int8 timip_opt_init_keysig;	// Z
    int output_rate;		// s
LIBTIMIPDLL_API     char timip_output_text_code[16];	// t
LIBTIMIPDLL_API     int timip_free_instruments_afterwards; // U
    char opt_wrd[16];		// W
#if defined(TIMIP___W32__) && defined(SMFCONV)
    int opt_rcpcv_dll;		// wr, wR
#endif
				// x (ignore)
				// Z (ignore)
    /* for w32g_a.c */
    int data_block_bits;
    int data_block_num;
//??    int waveout_data_block_size;
#ifdef IA_W32G_SYN
		int SynIDPort[MAX_PORT];
		int syn_AutoStart;
		DWORD processPriority;
		DWORD syn_ThreadPriority;
		int SynPortNum;
		int SynShTime;
#endif
} SETTING_TIMIDITY;

// #### obsoleted
#define PLAYERMODE_AUTOQUIT				0x0001
#define PLAYERMODE_AUTOREFINE				0x0002
#define PLAYERMODE_AUTOUNIQ				0x0004
#define PLAYERMODE_NOT_CONTINUE			0x0008
#define PLAYERMODE_NOT_DRAG_START	0x0010


extern char *OutputName;

extern void LoadIniFile(SETTING_PLAYER *sp,  SETTING_TIMIDITY *st);
extern void SaveIniFile(SETTING_PLAYER *sp,  SETTING_TIMIDITY *st);

extern SETTING_PLAYER *sp_default, *sp_current, *sp_temp;
extern SETTING_TIMIDITY *st_default, *st_current, *st_temp;
extern CHAR *INI_INVALID;
extern CHAR *INI_SEC_PLAYER;
extern CHAR *INI_SEC_TIMIDITY;
extern char *SystemFont;
extern char *PlayerFont;
extern char *WrdFont;
extern char *DocFont;
extern char *ListFont;
extern char *TracerFont;
extern HFONT hSystemFont;
extern HFONT hPlayerFont;
extern HFONT hWrdFont;
extern HFONT hDocFont;
extern HFONT hListFont;
extern HFONT hTracerFont;
extern int SystemFontSize;
extern int PlayerFontSize;
extern int WrdFontSize;
extern int DocFontSize;
extern int ListFontSize;
extern int TracerFontSize;

extern int IniGetKeyInt32(char *section, char *key,int32 *n);
extern int IniGetKeyInt32Array(char *section, char *key, int32 *n, int arraysize);
extern int IniGetKeyInt(char *section, char *key, int *n);
extern int IniGetKeyInt8(char *section, char *key, int8 *n);
extern int IniGetKeyChar(char *section, char *key, char *c);
extern int IniGetKeyIntArray(char *section, char *key, int *n, int arraysize);
extern int IniGetKeyString(char *section, char *key,char *str);
extern int IniGetKeyStringN(char *section, char *key,char *str, int size);
extern int IniGetKeyFloat(char *section, char *key, FLOAT_T *n);
extern int IniPutKeyInt32(char *section, char *key,int32 *n);
extern int IniPutKeyInt32Array(char *section, char *key, int32 *n, int arraysize);
extern int IniPutKeyInt(char *section, char *key, int *n);
extern int IniPutKeyInt8(char *section, char *key, int8 *n);
extern int IniPutKeyChar(char *section, char *key, char *c);
extern int IniPutKeyIntArray(char *section, char *key, int *n, int arraysize);
extern int IniPutKeyString(char *section, char *key, char *str);
extern int IniPutKeyStringN(char *section, char *key, char *str, int size);
extern int IniPutKeyFloat(char *section, char *key, FLOAT_T n);
extern void ApplySettingPlayer(SETTING_PLAYER *sp);
extern void SaveSettingPlayer(SETTING_PLAYER *sp);
extern void ApplySettingTiMidity(SETTING_TIMIDITY *st);
extern void SaveSettingTiMidity(SETTING_TIMIDITY *st);
extern void SettingCtlFlag(SETTING_TIMIDITY *st, int opt_id, int onoff);
extern int IniVersionCheck(void);
extern void BitBltRect(HDC dst, HDC src, RECT *rc);
#if 0
extern TmColors tm_colors[ /* TMCC_SIZE */ ];
#define TmCc(c) (tm_colors[c].color)
extern void TmInitColor(void);
extern void TmFreeColor(void);
extern void TmFillRect(HDC hdc, RECT *rc, int color);
#endif
extern void w32g_uninitialize(void);
extern void w32g_initialize(void);
extern int is_directory(char *path);
extern int directory_form(char *path_in_out);

extern char *timidity_window_inifile;
extern char *timidity_output_inifile;

#endif /* __TIMIP_W32G_UTL_H_ */
