
#include <libtimi_p_dll.h>
#include "timiwp_timidity.h"

#ifdef TIMIP___W32__

static BOOL WINAPI handler(DWORD dw)
{
#if defined(TIMIP_IA_WINSYN) || defined(IA_PORTMIDISYN)
	if( timip_ctl->id_character == 'W' 
		|| timip_ctl->id_character == 'P' )
	{
    	timip_rtsyn_midiports_close();
	}
#endif	
    printf ("***BREAK" NLS); fflush(stdout);
    timip_intr++;
    return TRUE;
}
#endif

#ifdef	TIMIP_HAVE_SIGNAL
static	TIMIP_RETSIGTYPE sigterm_exit(int sig)
{
    char s[4];

    /* NOTE: Here, fprintf is dangerous because it is not re-enterance
     * function.  It is possible coredump if the signal is called in printf's.
     */

    write(2, "Terminated sig=0x", 17);
    s[0] = "0123456789abcdef"[(sig >> 4) & 0xf];
    s[1] = "0123456789abcdef"[sig & 0xf];
    s[2] = '\n';
    write(2, s, 3);

    timip_safe_exit(1);
}
#endif /*	TIMIP_HAVE_SIGNAL */

static inline bool directory_p(const char* path)
{
    struct stat st;
    if(stat(path, &st) != -1) return S_ISDIR(st.st_mode);
    return false;
}

static inline void canonicalize_path(char* path)
{
    int len = strlen(path);
    if(!len || path[len-1]==PATH_SEP) return;
    path[len] = PATH_SEP;
    path[len+1] = '\0';
}





int timiwp_main_ini(int argc, char **argv)
{
    int c, timip_err;
    int nfiles;
    char **files;
    int main_ret;
    int longind;
	
	
//
//  libtimi_p_dllCjVCY
//
    timip_program_name=argv[0];
//    timip_set_ctl("d");
    timip_timidity_start_initialize();


//
// RtBOt@C̃[h
//

	// fBNg؂蕶łĂȂ΋؂蕶𑫂
// (ex.)    /usr/local/foo/bar --->  /usr/local/foo/bar/
    for(c = 1; c < argc; c++)
    {
	if(directory_p(argv[c]))
	{
	    char *p;
	    p = (char *)timip_safe_malloc(strlen(argv[c]) + 2);
	    strcpy(p, argv[c]);
	    canonicalize_path(p);
		free(argv[c]);
	    argv[c] = p;
	}
    }
// sǂݍ
	if((timip_err = timip_timidity_pre_load_configuration()) != 0)
	return timip_err;
// R}hCIvV̉
    optind = longind = 0;
    while ((c = getopt_long(argc, argv, timip_optcommands, timip_longopts, &longind)) > 0)
	if ((timip_err = timip_set_tim_opt_long(c, optarg, longind)) != 0)
	    break;
// ŏIǂݍ
    timip_err += timip_timidity_post_load_configuration();
// G[
    /* If there were problems, give up now */
    if(timip_err || (optind >= argc &&
	       !strchr(TIMIP_INTERACTIVE_INTERFACE_IDS, timip_ctl->id_character)))
    {
	if(!timip_got_a_configuration)
	{
	    char config1[1024];
	    char config2[1024];

	    memset(config1, 0, sizeof(config1));
	    memset(config2, 0, sizeof(config2));
	    GetWindowsDirectory(config1, 1023 - 13);
	    strcat(config1, "\\TIMIDITY.CFG");
	    if(GetModuleFileName(NULL, config2, 1023))
	    {
		char *strp;
		config2[1023] = '\0';
		if(strp = strrchr(config2, '\\'))
		{
		    *(++strp)='\0';
		    strncat(config2,"TIMIDITY.CFG",sizeof(config2)-strlen(config2)-1);
		}
	    }

	    timip_ctl->cmsg(CMSG_FATAL, VERB_NORMAL,
		      "%s: Can't read any configuration file.\nPlease check "
		      "%s or %s", timip_program_name, config1, config2);

	}
	else
	{
	    timip_ctl->cmsg(CMSG_ERROR, VERB_NORMAL,
		      "Try %s -h for help", timip_program_name);
	}
    	
    }


//
//  tJn
//

	timip_timidity_init_player();

    nfiles = argc - optind;
    files  = argv + optind;
    if(nfiles > 0 && timip_ctl->id_character != 'r' && timip_ctl->id_character != 'A' && timip_ctl->id_character != 'W' && timip_ctl->id_character != 'P')
	files = timip_expand_file_archives(files, &nfiles);
    if(timip_dumb_error_count)
	Sleep(1);

    main_ret = timiwp_play_main_ini(nfiles, files);

	return main_ret;

}


int timiwp_main_close(void)
{
	int i;
	timiwp_play_main_close();
//
//  ̊J
//
	timip_free_instruments(0);
    timip_free_global_mblock();
    timip_free_all_midi_file_info();
	timip_free_userdrum();
	timip_free_userinst();
    timip_tmdy_free_config();
	timip_free_effect_buffers();
	for (i = 0; i < MAX_CHANNELS; i++) {timip_free_drum_effect(i);}

	return 0;
}


static inline int set_default_program(int prog)
{
	int bank;
	Instrument *timip_ip;
	
	bank = (timip_special_tonebank >= 0) ? timip_special_tonebank : timip_default_tonebank;
	if ((timip_ip = timip_play_midi_load_instrument(0, bank, prog)) == NULL)
		return 1;
	timip_default_instrument = timip_ip;
	return 0;
}

int timiwp_play_main_ini(int nfiles, char **files)
{
    int output_fail = 0;


    if(timip_ctl->open(0, 0))
    {
	fprintf(stderr, "Couldn't open %s (`%c')" NLS,
		timip_ctl->id_name, timip_ctl->id_character);
	timip_play_mode->close_output();
	return 3;
    }

/*
    if(timip_wrdt->open(timip_wrdt_open_opts))
    {
	fprintf(stderr, "Couldn't open WRD Tracer: %s (`%c')" NLS,
		timip_wrdt->name, timip_wrdt->id);
	timip_play_mode->close_output();
	timip_ctl->close();
	return 1;
    }
*/

#ifdef TIMIP___W32__

#ifdef	TIMIP_HAVE_SIGNAL
	signal(SIGTERM, sigterm_exit);
#endif
	SetConsoleCtrlHandler(handler, TRUE);

	timip_ctl->cmsg(CMSG_INFO, VERB_DEBUG_SILLY,
		  "Initialize for Critical Section");
	InitializeCriticalSection(&timip_critSect);
	if(timip_opt_evil_mode)
	    if(!SetThreadPriority(GetCurrentThread(),
				  THREAD_PRIORITY_ABOVE_NORMAL))
		timip_ctl->cmsg(CMSG_ERROR, VERB_NORMAL,
			  "Error raising process priority");

#else
	/* UNIX */
#ifdef	TIMIP_HAVE_SIGNAL
	signal(SIGINT, sigterm_exit);
	signal(SIGTERM, sigterm_exit);
#ifdef SIGPIPE
	signal(SIGPIPE, sigterm_exit);    /* Handle broken pipe */
#endif /* SIGPIPE */
#endif /*	TIMIP_HAVE_SIGNAL */

#endif

	/* Open output device */
	timip_ctl->cmsg(CMSG_INFO, VERB_DEBUG_SILLY,
		  "Open output: %c, %s",
		  timip_play_mode->id_character,
		  timip_play_mode->id_name);

	if (timip_play_mode->flag & PF_PCM_STREAM) {
	    timip_play_mode->extra_param[1] = timip_aq_calc_fragsize();
	    timip_ctl->cmsg(CMSG_INFO, VERB_DEBUG_SILLY,
		      "requesting fragment size: %d",
		      timip_play_mode->extra_param[1]);
	}
	if(timip_play_mode->open_output() < 0)
	{
	    timip_ctl->cmsg(CMSG_FATAL, VERB_NORMAL,
		      "Couldn't open %s (`%c')",
		      timip_play_mode->id_name, timip_play_mode->id_character);
	    output_fail = 1;
	    timip_ctl->close();
	    return 2;
	}

	if(!timip_control_ratio)
	{
	    timip_control_ratio = timip_play_mode->rate / CONTROLS_PER_SECOND;
	    if(timip_control_ratio < 1)
		timip_control_ratio = 1;
	    else if (timip_control_ratio > MAX_CONTROL_RATIO)
		timip_control_ratio = MAX_CONTROL_RATIO;
	}

	timip_init_load_soundfont();
	if(!output_fail)
	{
	    timip_aq_setup();
	    timip_timidity_init_aq_buff();
	}
	if(timip_allocate_cache_size > 0)
	    timip_resamp_cache_reset();

	if (timip_def_prog >= 0)
		set_default_program(timip_def_prog);
	if (*timip_def_instr_name)
		timip_set_default_instrument(timip_def_instr_name);

/*
	if(timip_ctl->flags & CTLF_LIST_RANDOM)
	    timip_randomize_string_list(files, nfiles);
	else if(timip_ctl->flags & CTLF_LIST_SORT)
	    timip_sort_pathname(files, nfiles);
*/
	/* Return only when quitting */
	timip_ctl->cmsg(CMSG_INFO, VERB_DEBUG_SILLY,
		  "pass_playing_list() nfiles=%d", nfiles);

 return 0;
}


int timiwp_play_main_close (void)
{

	if(timip_intr)
	    timip_aq_flush(1);


	timip_play_mode->close_output();
	timip_ctl->close();
	timip_wrdt->close();
#ifdef TIMIP___W32__
	DeleteCriticalSection (&timip_critSect);
#endif

#ifdef SUPPORT_SOUNDSPEC
    if(view_soundspec_flag)
	close_soundspec();
#endif /* SUPPORT_SOUNDSPEC */

    timip_free_archive_files();
#ifdef	TIMIP_SUPPORT_SOCKET
    timip_url_news_connection_cache(URL_NEWS_CLOSE_CACHE);
#endif /*	TIMIP_SUPPORT_SOCKET */

    return 0;
}



