// tim_synth.cpp : Implementation of tim_synthApp and DLL registration.

#include "stdafx.h"
#include "timiditydrv.h"
#include "tim_synth.h"

#include "dmksctrl.h"
#include "dmusprop.h"


tim_synth::tim_synth() {
	
	dwUsageCount = 0;
	enabled = false;
	status = false;

	int i;
	// Couldn't figure out a better way to do this.  VC6.0 doesn't see that the
	// first element in KSPROPERTY is a GUID for some reason and was giving me
	// errors trying to convert it to a ULONG.  This works though;
	for(i=0;i<10;i++) {
		switch(i) {
		case 0:
			SynthProperties[i].Set = GUID_DMUS_PROP_GM_Hardware;
			SynthProperties[i].Id = 0;
			SynthProperties[i].Flags = KSPROPERTY_TYPE_GET | KSPROPERTY_TYPE_BASICSUPPORT;
			//SynthProperties[i].Alignment = 0;
 			break;
		case 1:
			SynthProperties[i].Set = GUID_DMUS_PROP_Effects;
			SynthProperties[i].Id = 0;
			SynthProperties[i].Flags = KSPROPERTY_TYPE_GET | KSPROPERTY_TYPE_SET | KSPROPERTY_TYPE_BASICSUPPORT;
			//SynthProperties[i].Alignment = 0;
 			break;
		case 2:
			SynthProperties[i].Set = KSPROPSETID_Synth;
			SynthProperties[i].Id = KSPROPERTY_SYNTH_CAPS;
			SynthProperties[i].Flags = KSPROPERTY_TYPE_GET | KSPROPERTY_TYPE_BASICSUPPORT;
			//SynthProperties[i].Alignment = 0;
 			break;
		case 3:
			SynthProperties[i].Set = KSPROPSETID_Synth;
			SynthProperties[i].Id = KSPROPERTY_SYNTH_PORTPARAMETERS;
			SynthProperties[i].Flags = KSPROPERTY_TYPE_GET | KSPROPERTY_TYPE_BASICSUPPORT;
			//SynthProperties[i].Alignment = 0;
 			break;
		case 4:
			SynthProperties[i].Set = KSPROPSETID_Synth;
			SynthProperties[i].Id = KSPROPERTY_SYNTH_VOLUME;
			SynthProperties[i].Flags = KSPROPERTY_TYPE_GET | KSPROPERTY_TYPE_BASICSUPPORT;
			//SynthProperties[i].Alignment = 0;
 			break;
		case 5:
			SynthProperties[i].Set = KSPROPSETID_Synth;
			SynthProperties[i].Id = KSPROPERTY_SYNTH_VOLUMEBOOST;
			SynthProperties[i].Flags = KSPROPERTY_TYPE_GET | KSPROPERTY_TYPE_BASICSUPPORT;
			//SynthProperties[i].Alignment = 0;
 			break;
		case 6:
			SynthProperties[i].Set = KSPROPSETID_Synth;
			SynthProperties[i].Id = KSPROPERTY_SYNTH_CHANNELGROUPS;
			SynthProperties[i].Flags = KSPROPERTY_TYPE_GET | KSPROPERTY_TYPE_BASICSUPPORT;
			//SynthProperties[i].Alignment = 0;
 			break;
		case 7:
			SynthProperties[i].Set = KSPROPSETID_Synth;
			SynthProperties[i].Id = KSPROPERTY_SYNTH_VOICEPRIORITY;
			SynthProperties[i].Flags = KSPROPERTY_TYPE_GET | KSPROPERTY_TYPE_BASICSUPPORT;
			//SynthProperties[i].Alignment = 0;
 			break;
		case 8:
			SynthProperties[i].Set = KSPROPSETID_Synth;
			SynthProperties[i].Id = KSPROPERTY_SYNTH_RUNNINGSTATS;
			SynthProperties[i].Flags = KSPROPERTY_TYPE_GET | KSPROPERTY_TYPE_BASICSUPPORT;
			//SynthProperties[i].Alignment = 0;
 			break;
		case 9:
			SynthProperties[i].Set = KSPROPSETID_Synth;
			SynthProperties[i].Id = KSPROPERTY_SYNTH_LATENCYCLOCK;
			SynthProperties[i].Flags = KSPROPERTY_TYPE_GET | KSPROPERTY_TYPE_BASICSUPPORT;
			//SynthProperties[i].Alignment = 0;
 			break;

		default:
			break;
		}
	}

	myTIM = new CSynthTIM();

	RecordPoint = NULL;
	PlayPoint = NULL;


	
}

STDMETHODIMP tim_synth::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] = 
	{
		&IID_Itim_synth,
	};

	for (int i=0;i<sizeof(arr)/sizeof(arr[0]);i++)
	{
		if (InlineIsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}

HRESULT tim_synth::Open(THIS_ LPDMUS_PORTPARAMS pPortParams) {

	char dataPatch[2048];
	if(!status) {
		pSynthParams = pPortParams;
		if(getenv("SystemRoot") == NULL) {
			if(getenv("windir") == NULL) {
				// Eventually we'll query from the registry
				strcpy(&dataPatch[0],"c:\\windows");
			} else {
				strcpy(&dataPatch[0],getenv("windir"));
			}
		} else {
			strcpy(&dataPatch[0], getenv("SystemRoot"));
		}
		strcat(&dataPatch[0],"\\system32\\");

		if(!myTIM->ClassicOpen(&dataPatch[0])) return DMUS_E_DRIVER_FAILED;
		status = true;
		return S_OK;
	} else {
		return DMUS_E_ALREADYOPEN;
	}
}

HRESULT tim_synth::Close(THIS) {

	if(status) {
		status = false;
		myTIM->Close();
		return S_OK;
	} else {
		return DMUS_E_ALREADYCLOSED;

	}

}

HRESULT tim_synth::GetAppend(THIS_ DWORD *pdwAppend) {
	// Timidity doesn't need to do DLS downloads
	int a;
	a = 1;
	return E_NOTIMPL;
}

HRESULT tim_synth::Download(THIS_ LPHANDLE phDownload, LPVOID pvData, LPBOOL pbFree) {
	int a;
	a = 1;
	return E_NOTIMPL;
}

HRESULT tim_synth::Unload(THIS_ HANDLE hDownload,HRESULT(CALLBACK *lpFreeHandle)(HANDLE,HANDLE),HANDLE hUserData) {
	int a;
	a = 1;
	return E_NOTIMPL;
}

HRESULT tim_synth::GetFormat(THIS_ LPWAVEFORMATEX pWaveFormatEx, LPDWORD pdwWaveFormatExSize) {
	if(pWaveFormatEx==NULL) {
		return sizeof(LPWAVEFORMATEX);
	} else {
		pWaveFormatEx->cbSize = 0;
		pWaveFormatEx->nAvgBytesPerSec = 44100 * 2 * 2;
		pWaveFormatEx->nBlockAlign = (2*16)/8;
		pWaveFormatEx->wFormatTag = WAVE_FORMAT_PCM;
		pWaveFormatEx->nChannels = 2;
		pWaveFormatEx->nSamplesPerSec = 44100;
		pWaveFormatEx->wBitsPerSample = 16;
		return S_OK;
	}
}

HRESULT tim_synth::SetChannelPriority(THIS_ DWORD dwChannelGroup, DWORD dwChannel, DWORD dwPriority) {
	int a;
	a = 1;
	return S_OK;
}

HRESULT tim_synth::GetChannelPriority(THIS_ DWORD dwChannelGroup, DWORD dwChannel, LPDWORD pdwPriority) {
	int a;
	a = 1;
	return E_NOTIMPL;
}

HRESULT tim_synth::SetNumChannelGroups(THIS_ DWORD dwGroups) {
	int a;
	a = 1;
	return S_OK;
}

HRESULT tim_synth::GetLatencyClock(THIS_ IReferenceClock **pClock) {
	pSink->GetLatencyClock(pClock);

	return S_OK;
}


class BufferReader {
public:
	LPBYTE pbBufPtr;
	signed long dwLen;
	REFERENCE_TIME sTime;

	BufferReader(REFERENCE_TIME startTime, LPBYTE pbBuffer, DWORD len) {
		sTime = startTime;
		pbBufPtr = pbBuffer;
		dwLen = len;
	}
	~BufferReader() {
	};

	HRESULT GetNextEvent(LPREFERENCE_TIME prt, LPDWORD pdwChannelGroup, LPDWORD pdwLength, LPBYTE* ppData)
	{
		if (dwLen<=0) return S_FALSE;

		DMUS_EVENTHEADER *evtPtr = (DMUS_EVENTHEADER *)pbBufPtr;
		DWORD blockSize = DMUS_EVENT_SIZE(evtPtr->cbEvent);

		*prt = sTime + evtPtr->rtDelta;
		*pdwChannelGroup = evtPtr->dwChannelGroup;
		*pdwLength = evtPtr->cbEvent;
		*ppData = (pbBufPtr + sizeof(DMUS_EVENTHEADER));

		dwLen -= blockSize;
		pbBufPtr += blockSize;


		return S_OK;
	};

};


HRESULT tim_synth::PlayBuffer(THIS_ REFERENCE_TIME rt, LPBYTE pbBuffer, DWORD cbBuffer) {

	LONGLONG stTime;
	CMidiEvent * tmpEvent;
	BufferReader *myReader = new BufferReader(rt, pbBuffer, cbBuffer);

	char * tmpSysex;

	REFERENCE_TIME bufRt;
	DWORD chanGroup;
	DWORD bufLen;
	BYTE *bufData;

	while(myReader->GetNextEvent(&bufRt, &chanGroup, &bufLen, &bufData) != S_FALSE) {
		pSink->RefTimeToSample(bufRt, &stTime);
		if(bufLen<=sizeof(DWORD)) {
			tmpEvent = new CMidiEvent();
			tmpEvent->AssignMsg(*(LONG *)bufData, stTime);
			if(RecordPoint!=NULL) RecordPoint->ChainEvent(tmpEvent);
			RecordPoint = tmpEvent;

		} else {
			tmpSysex =(char *)malloc(bufLen);
			if(tmpSysex!=NULL) {
				memcpy(tmpSysex,bufData,bufLen);
				tmpEvent = new CMidiEvent();
				tmpEvent->AssignSysex(tmpSysex,bufLen,stTime);
				if(RecordPoint!=NULL) RecordPoint->ChainEvent(tmpEvent);
				RecordPoint = tmpEvent;

			}
		}
		if(PlayPoint==NULL) PlayPoint=RecordPoint;
	}

	delete myReader;

	return S_OK;
}

HRESULT tim_synth::SetMasterClock(THIS_ IReferenceClock *pClock) {
	this->pClock = pClock;

	return S_OK;
}

HRESULT tim_synth::GetPortCaps(THIS_ LPDMUS_PORTCAPS pCaps) {

	pCaps->dwClass = DMUS_PC_OUTPUTCLASS;
	pCaps->dwEffectFlags = DMUS_EFFECT_REVERB;
	pCaps->dwFlags = DMUS_PC_DIRECTSOUND | DMUS_PC_GMINHARDWARE; //| DMUS_PC_SOFTWARESYNTH;
	pCaps->dwMaxAudioChannels = 2;
	pCaps->dwMaxChannelGroups = 1;
	pCaps->dwMaxVoices = 32;
	pCaps->dwMemorySize = 0;
	pCaps->dwSize = sizeof(DMUS_PORTCAPS);
	//pCaps->dwType = DMUS_PORT_USER_MODE_SYNTH;
	pCaps->dwType = DMUS_PORT_WINMM_DRIVER;
	pCaps->guidPort = CLSID_tim_synth;
	lstrcpyW(&pCaps->wszDescription[0], L"Timidity++ Driver");

	return S_OK;
}

HRESULT tim_synth::GetRunningStats(THIS_ LPDMUS_SYNTHSTATS pStats) {
	int a;
	a = 1;
	return E_NOTIMPL;
}

HRESULT tim_synth::Activate(THIS_ BOOL fEnable) {
	pSink->Activate(fEnable);
	if((!fEnable) && (!enabled)) {
		return S_FALSE;
	} else if (fEnable && enabled) {
		return DMUS_E_SYNTHACTIVE;
	} else {
		enabled = fEnable;
		return S_OK;
	}
}

HRESULT tim_synth::Render(THIS_ short *pBuffer, DWORD dwLength, LONGLONG llPosition) {

	if(!enabled) {
		return DMUS_E_SYNTHINACTIVE;
	} else {

		while(PlayPoint != NULL) {
			if(PlayPoint->getTime()<llPosition) {
				switch(PlayPoint->getType()) {
				case ShortMsg:
					myTIM->PlayMsg(PlayPoint->MidiMsg);
					break;
				case SysexData:
					myTIM->PlaySysex((unsigned char *)PlayPoint->SysexInfo, PlayPoint->sysexLen);
					break;
				default:
					// Shouldn't ever get here
					break;
				}
				CMidiEvent *nextEvent;
				if(PlayPoint->isFinal()) {
					PlayPoint->Consume();
					//delete PlayPoint;
					PlayPoint = NULL;
				} else {
					nextEvent = PlayPoint->Consume();
					delete PlayPoint;
					PlayPoint = nextEvent;
				}

			} else break;
		}


		myTIM->TIM_CallBack((unsigned char *)pBuffer, dwLength);

		//curSampleTime += dwLength;

		return S_OK;
	}
}


HRESULT tim_synth::QueryInterface(THIS_ REFIID Interface , LPVOID FAR * Object) {
   if (IsEqualGUID(Interface, IID_IUnknown))
   {
		*Object = (PVOID)(IDirectMusicSynth *)this;
   } 
   else if (IsEqualGUID(Interface, IID_IDirectMusicSynth))
   {
		*Object = (PVOID)(IDirectMusicSynth *)this;
   }
   else if (IsEqualGUID(Interface, IID_IDirectMusicSynthSink))
   {
		*Object = (PVOID)(IDirectMusicSynthSink *)this;
   }
   else if (IsEqualGUID(Interface, IID_IKsControl))
   {
		*Object = (PVOID)(IKsControl *)this;
   }
   else {
	   *Object = NULL;
   }

   if (*Object) {
	   ((IUnknown *)(*Object))->AddRef();
	   return S_OK;
   }
   return 0xC000000DL;
}

ULONG tim_synth::AddRef(THIS) {
	dwUsageCount++;
	return dwUsageCount;
}

ULONG tim_synth::Release(THIS) {
	dwUsageCount--;

	if(dwUsageCount == 0) {
		delete this;
	}
	return dwUsageCount;
}

HRESULT tim_synth::SetSynthSink(THIS_ IDirectMusicSynthSink *pSynthSink){
	pSink = pSynthSink;
	pSink->Init((IDirectMusicSynth *)this);
	pSink->SetMasterClock(pClock);
	return S_OK;
}

HRESULT tim_synth::KsProperty(THIS_ IN PKSPROPERTY Property, IN ULONG PropertyLength, IN OUT LPVOID PropertyData, IN ULONG DataLength, OUT ULONG* BytesReturned) {
	const WORD  c_wMaxProps = SIZEOF_ARRAY(SynthProperties);
	WORD wPropIdx;

    for (wPropIdx = 0; wPropIdx < c_wMaxProps; wPropIdx++)
    {
        if ( (SynthProperties[wPropIdx].Set == Property->Set)
          && (SynthProperties[wPropIdx].Id == Property->Id) )
        {
            // if return buffer can hold a ULONG, return the access flags
            
			PULONG AccessFlags = (PULONG)PropertyData;
			

            *AccessFlags = SynthProperties[wPropIdx].Flags;

            // set the return value size
            *BytesReturned = sizeof(ULONG);
            break;
        }
    }

    if (wPropIdx == c_wMaxProps)
    {
		*BytesReturned = 0;
        return DMUS_E_UNKNOWN_PROPERTY;
    }
	return S_OK;
}

HRESULT tim_synth::KsEvent(THIS_ IN PKSEVENT Event OPTIONAL, IN ULONG EventLength, IN OUT LPVOID EventData, IN ULONG DataLength, OUT ULONG* BytesReturned) {
	int a;
	a = 1;
	return E_NOTIMPL;
}
							
HRESULT tim_synth::KsMethod(THIS_ IN PKSMETHOD Method, IN ULONG MethodLength, IN OUT LPVOID MethodData, IN ULONG DataLength, OUT ULONG* BytesReturned) {
	int a;
	a = 1;
	return E_NOTIMPL;
}

