# Makefile - mt32emu.dsp

ifndef CFG
CFG=mt32emu - Win32 Debug
endif
CC=gcc
CFLAGS=
CXX=g++
CXXFLAGS=$(CFLAGS)
RC=windres -O COFF
ifeq "$(CFG)"  "mt32emu - Win32 Debug"
CFLAGS+=-W -g -O0 -IC:/WINDDK/2600.1106/inc/ddk/wxp -IC:/WINDDK/2600.1106/inc/wxp -IC:/WINDDK/2600.1106/inc/crt -DWIN32 -D_DEBUG -D_WINDOWS -D_MBCS -D_USRDLL
LD=dllwrap
LDFLAGS=
LDFLAGS+=-LC:/WINDDK/2600.1106/lib/wxp/i386 -Wl,--subsystem,windows
LIBS+=-lkernel32 -luser32 -lgdi32 -lwinspool -lcomdlg32 -ladvapi32 -lshell32 -lole32 -loleaut32 -luuid -lodbc32 -lodbccp32 -lksguid -lksuser

"./regsvr32.trg" : $(InputPath) 
	regsvr32 /s /c ".../.D.e.b.u.g./.m.t.3.2.e.m.u...d.l.l." 
	echo regsvr32 exec. time > "./regsvr32.trg" 
	
else
ifeq "$(CFG)"  "mt32emu - Win32 Unicode Debug"
CFLAGS+=-W -g -O0 -DWIN32 -D_DEBUG -D_WINDOWS -D_USRDLL -D_UNICODE
LD=dllwrap
LDFLAGS=
LDFLAGS+=-Wl,--subsystem,windows
LIBS+=-lkernel32 -luser32 -lgdi32 -lwinspool -lcomdlg32 -ladvapi32 -lshell32 -lole32 -loleaut32 -luuid -lodbc32 -lodbccp32

"./regsvr32.trg" : $(InputPath) 
	if "%OS%"=="" goto NOTNT 
	if not "%OS%"=="Windows_NT" goto NOTNT 
	regsvr32 /s /c ".../.D.e.b.u.g.U./.m.t.3.2.e.m.u...d.l.l." 
	echo regsvr32 exec. time > "./regsvr32.trg" 
	goto end 
	:NOTNT 
	echo Warning : Cannot register Unicode DLL on Windows 95 
	:end 
	
else
ifeq "$(CFG)"  "mt32emu - Win32 Release MinSize"
CFLAGS+=-W -Os -IC:/WINDDK/2600.1106/inc/ddk/wxp -IC:/WINDDK/2600.1106/inc/wxp -IC:/WINDDK/2600.1106/inc/crt -DWIN32 -DNDEBUG -D_WINDOWS -D_MBCS -D_USRDLL -D_ATL_DLL
LD=dllwrap
LDFLAGS=
LDFLAGS+=-LC:/WINDDK/2600.1106/lib/wxp/i386 -Wl,--subsystem,windows
LIBS+=-lkernel32 -luser32 -lgdi32 -lwinspool -lcomdlg32 -ladvapi32 -lshell32 -lole32 -loleaut32 -lodbc32 -lodbccp32 -lksguid -lksuser

"./regsvr32.trg" : $(InputPath) 
	regsvr32 /s /c ".../.R.e.l.e.a.s.e.M.i.n.S.i.z.e./.m.t.3.2.e.m.u...d.l.l." 
	echo regsvr32 exec. time > "./regsvr32.trg" 
	
else
ifeq "$(CFG)"  "mt32emu - Win32 Release MinDependency"
CFLAGS+=-W -Os -IC:/WINDDK/2600.1106/inc/ddk/wxp -IC:/WINDDK/2600.1106/inc/wxp -IC:/WINDDK/2600.1106/inc/crt -DWIN32 -DNDEBUG -D_WINDOWS -D_MBCS -D_USRDLL -D_ATL_STATIC_REGISTRY -D_ATL_MIN_CRT
LD=dllwrap
LDFLAGS=
LDFLAGS+=-LC:/WINDDK/2600.1106/lib/wxp/i386 -Wl,--subsystem,windows
LIBS+=-lkernel32 -luser32 -lgdi32 -lwinspool -lcomdlg32 -ladvapi32 -lshell32 -lole32 -loleaut32 -luuid -lodbc32 -lodbccp32 -lksguid -lksuser -lmsvcrt

"./regsvr32.trg" : $(InputPath) 
	regsvr32 /s /c ".../.R.e.l.e.a.s.e.M.i.n.D.e.p.e.n.d.e.n.c.y./.m.t.3.2.e.m.u...d.l.l." 
	echo regsvr32 exec. time > "./regsvr32.trg" 
	
else
ifeq "$(CFG)"  "mt32emu - Win32 Unicode Release MinSize"
CFLAGS+=-W -Os -DWIN32 -DNDEBUG -D_WINDOWS -D_USRDLL -D_UNICODE -D_ATL_DLL -D_ATL_MIN_CRT
LD=dllwrap
LDFLAGS=
LDFLAGS+=-Wl,--subsystem,windows
LIBS+=-lkernel32 -luser32 -lgdi32 -lwinspool -lcomdlg32 -ladvapi32 -lshell32 -lole32 -loleaut32 -luuid -lodbc32 -lodbccp32

"./regsvr32.trg" : $(InputPath) 
	if "%OS%"=="" goto NOTNT 
	if not "%OS%"=="Windows_NT" goto NOTNT 
	regsvr32 /s /c ".../.R.e.l.e.a.s.e.U.M.i.n.S.i.z.e./.m.t.3.2.e.m.u...d.l.l." 
	echo regsvr32 exec. time > "./regsvr32.trg" 
	goto end 
	:NOTNT 
	echo Warning : Cannot register Unicode DLL on Windows 95 
	:end 
	
else
ifeq "$(CFG)"  "mt32emu - Win32 Unicode Release MinDependency"
CFLAGS+=-W -Os -DWIN32 -DNDEBUG -D_WINDOWS -D_USRDLL -D_UNICODE -D_ATL_STATIC_REGISTRY -D_ATL_MIN_CRT
LD=dllwrap
LDFLAGS=
LDFLAGS+=-Wl,--subsystem,windows
LIBS+=-lkernel32 -luser32 -lgdi32 -lwinspool -lcomdlg32 -ladvapi32 -lshell32 -lole32 -loleaut32 -luuid -lodbc32 -lodbccp32

"./regsvr32.trg" : $(InputPath) 
	if "%OS%"=="" goto NOTNT 
	if not "%OS%"=="Windows_NT" goto NOTNT 
	regsvr32 /s /c ".../.R.e.l.e.a.s.e.U.M.i.n.D.e.p.e.n.d.e.n.c.y./.m.t.3.2.e.m.u...d.l.l." 
	echo regsvr32 exec. time > "./regsvr32.trg" 
	goto end 
	:NOTNT 
	echo Warning : Cannot register Unicode DLL on Windows 95 
	:end 
	
endif
endif
endif
endif
endif
endif

ifndef TARGET
TARGET=mt32emu.dll
endif

.PHONY: all
all: $(TARGET)

%.o: %.c
	$(CC) $(CFLAGS) $(CPPFLAGS) -o $@ -c $<

%.o: %.cc
	$(CXX) $(CXXFLAGS) $(CPPFLAGS) -o $@ -c $<

%.o: %.cpp
	$(CXX) $(CXXFLAGS) $(CPPFLAGS) -o $@ -c $<

%.o: %.cxx
	$(CXX) $(CXXFLAGS) $(CPPFLAGS) -o $@ -c $<

%.res: %.rc
	$(RC) $(CPPFLAGS) -o $@ -i $<

CFLAGS+=
SOURCE_FILES= \
	CSynthMT32.cpp \
	MidiEvent.cpp \
	mt32emu.cpp \
	mt32emu.def \
	mt32emu.idl \
	mt32emu.rc \
	tim_synth.cpp \
	StdAfx.cpp \
	SynthClassFactory.cpp

HEADER_FILES= \
	mathutil.h \
	MidiEvent.h \
	tim_synth.h \
	Resource.h \
	StdAfx.h \
	SynthClassFactory.h \
	SynthMT32.h

RESOURCE_FILES= \
	tim_synth.rgs \
	oemsetup.inf \
	SynthClassFactory.rgs

SRCS=$(SOURCE_FILES) $(HEADER_FILES) $(RESOURCE_FILES) 

OBJS=$(patsubst %.rc,%.res,$(patsubst %.cxx,%.o,$(patsubst %.cpp,%.o,$(patsubst %.cc,%.o,$(patsubst %.c,%.o,$(filter %.c %.cc %.cpp %.cxx %.rc,$(SRCS)))))))

$(TARGET): $(OBJS)
	$(LD) $(LDFLAGS) -o $@ $(OBJS) $(LIBS)

.PHONY: clean
clean:
	-rm -f $(OBJS) $(TARGET) mt32emu.dep

.PHONY: depends
depends:
	-$(CXX) $(CXXFLAGS) $(CPPFLAGS) -MM $(filter %.c %.cc %.cpp %.cxx,$(SRCS)) > mt32emu.dep

-include mt32emu.dep

