// SynthClassFactory.cpp : Implementation of CTimiditydrvApp and DLL registration.

#include "stdafx.h"
#include "timiditydrv.h"
#include "SynthClassFactory.h"
#include "tim_synth.h"

/////////////////////////////////////////////////////////////////////////////
//

STDMETHODIMP SynthClassFactory::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] = 
	{
		&IID_ISynthClassFactory,
	};

	for (int i=0;i<sizeof(arr)/sizeof(arr[0]);i++)
	{
		if (InlineIsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}

HRESULT SynthClassFactory::QueryInterface(THIS_ REFIID Interface , LPVOID FAR * Object) {
   if (IsEqualGUID(Interface, IID_IUnknown))
   {
		*Object = (PVOID)(IClassFactory *)this;
   } 
   else /*if (IsEqualGUID(Interface, IID_IDirectMusicSynth))*/
   {
		*Object = (PVOID)(IClassFactory *)this;
   }
  /* } else {
	   *Object = NULL;
   }*/

   if (*Object) {
	   ((IUnknown *)(*Object))->AddRef();
	   return S_OK;
   }
   return 0xC000000DL;
}

ULONG SynthClassFactory::AddRef(THIS) {
	dwUsageCount++;
	return dwUsageCount;
}

ULONG SynthClassFactory::Release(THIS) {
	dwUsageCount--;

	if(dwUsageCount == 0) {
		delete this;
	}
	return dwUsageCount;
}

HRESULT STDMETHODCALLTYPE SynthClassFactory::CreateInstance(IUnknown __RPC_FAR *pUnkOuter, REFIID riid, void __RPC_FAR *__RPC_FAR *ppvObject){
	tim_synth *Obj = new tim_synth();
	if(FAILED(Obj->QueryInterface(riid, ppvObject))) {
		delete Obj;
		*ppvObject = NULL;
		return E_NOINTERFACE;
	}
	return NO_ERROR;
}

long __stdcall SynthClassFactory::LockServer(int) {
	return S_OK;
}

HRESULT SynthClassFactory::GetTypeInfoCount(UINT *pctinfo) {
	if (pctinfo == NULL) {
		return E_INVALIDARG;
	}
	*pctinfo = 1;
	return NOERROR;


}